/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Compat;

import com.Harbinger.Spore.Core.Sitems;
import com.Harbinger.Spore.Recipes.InjectionRecipe;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class InjectionCraftingCategory
implements IRecipeCategory<InjectionRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("spore", "injection");
    public static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/gui/injection_gui.png");
    public static final RecipeType<InjectionRecipe> INJECTION_TYPE = new RecipeType(UID, InjectionRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public InjectionCraftingCategory(IGuiHelper helper) {
        this.background = helper.drawableBuilder(TEXTURE, 0, 0, 176, 82).setTextureSize(176, 166).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Sitems.SYRINGE.get()));
    }

    public RecipeType<InjectionRecipe> getRecipeType() {
        return INJECTION_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"item.spore.syringe");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayoutBuilder, InjectionRecipe injectionRecipe, IFocusGroup iFocusGroup) {
        iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, 97, 17).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Sitems.SYRINGE.get()}));
        iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, 97, 53).addIngredients(Ingredient.m_43927_((ItemStack[])new ItemStack[]{injectionRecipe.m_8043_()}));
    }

    public void draw(InjectionRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        ResourceLocation location;
        Entity entity;
        super.draw((Object)recipe, recipeSlotsView, stack, mouseX, mouseY);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (entity = ((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(location = new ResourceLocation(recipe.getEntityId()))).m_20615_((Level)level)) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living instanceof VariantKeeper) {
                VariantKeeper keeper = (VariantKeeper)living;
                keeper.setVariant(recipe.getEntityType());
                this.renderEntityInInventoryFollowsAngle(stack, 34, 70, 20, 0.0f, 0.0f, living);
            } else {
                this.renderEntityInInventoryFollowsAngle(stack, 34, 70, 20, 0.0f, 0.0f, living);
            }
        }
    }

    public void renderEntityInInventoryFollowsAngle(PoseStack poseStack, int x, int y, int scale, float angleXComponent, float angleYComponent, LivingEntity entity) {
        poseStack.m_85836_();
        Quaternion pose = new Quaternion(0.0f, 180.0f, 180.0f, true);
        Quaternion cameraOrientation = new Quaternion(angleYComponent * 20.0f, 0.0f, 0.0f, true);
        pose.m_80148_(cameraOrientation);
        float originalBodyRot = entity.f_20883_;
        float originalYRot = entity.m_146908_();
        float originalXRot = entity.m_146909_();
        float originalHeadRotO = entity.f_20886_;
        float originalHeadRot = entity.f_20885_;
        entity.f_20883_ = 180.0f + angleXComponent * 20.0f;
        entity.m_146922_(180.0f + angleXComponent * 40.0f);
        entity.m_146926_(-angleYComponent * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        this.renderEntityInInventory(poseStack, x, y, scale, pose, entity);
        entity.f_20883_ = originalBodyRot;
        entity.m_146922_(originalYRot);
        entity.m_146926_(originalXRot);
        entity.f_20886_ = originalHeadRotO;
        entity.f_20885_ = originalHeadRot;
        poseStack.m_85849_();
    }

    private void renderEntityInInventory(PoseStack poseStack, int x, int y, int scale, Quaternion quaternion, LivingEntity entity) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 50.0);
        poseStack.m_85841_((float)scale, (float)scale, (float)scale);
        poseStack.m_85845_(quaternion);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Lighting.m_166384_();
        RenderSystem.m_157182_();
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        dispatcher.m_114468_(false);
        dispatcher.m_114468_(false);
        RenderSystem.m_69890_(() -> dispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0));
        bufferSource.m_109911_();
        poseStack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }
}

