/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Screens;

import com.Harbinger.Spore.Core.Sitems;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Recipes.InjectionRecipe;
import com.Harbinger.Spore.Screens.InjectionRecipeMenu;
import com.Harbinger.Spore.Screens.TutorialMenuMethods;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sitems.Agents.AbstractSyringe;
import com.Harbinger.Spore.Sitems.Agents.ArmorSyringe;
import com.Harbinger.Spore.Sitems.Agents.WeaponSyringe;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorData;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorMutations;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeToolsMutations;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeWeaponData;
import com.Harbinger.Spore.Sitems.BiologicalReagent;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class InjectionRecipeScreen
extends AbstractContainerScreen<InjectionRecipeMenu>
implements TutorialMenuMethods {
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/gui/injection_recipe_gui.png");
    private final List<InjectionRecipe> recipes;
    private int tickCounter = 0;
    private int currentItemIndex = 0;
    private Button leftButton;
    private Button rightButton;
    private Button leftDownButton;
    private Button rightDownButton;
    private int getCurrentWeaponIndex = 0;
    private int getCurrentArmorIndex = 0;
    private int getCurrentItemIndex = 0;
    private int getCurrentReagentIndex = 0;
    private final List<Item> weaponItems;
    private final List<Item> armorItems;
    private final List<Item> allItems;
    private final List<Item> reagents;
    ClientLevel level;

    public InjectionRecipeScreen(InjectionRecipeMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.level = Minecraft.m_91087_().f_91073_;
        this.weaponItems = Utilities.getItemsFromTag("spore:enchantable_weapon_items");
        this.armorItems = Utilities.getItemsFromTag("spore:enchantable_armor_items");
        this.allItems = Utilities.getItemsFromTag("spore:enchantable_items");
        this.reagents = Utilities.getItemsFromTag("spore:reagents");
        this.f_97726_ = 176;
        this.f_97727_ = 166;
        this.recipes = this.level == null ? new ArrayList<InjectionRecipe>() : this.level.m_7465_().m_44013_((RecipeType)InjectionRecipe.InjectionRecipeType.INSTANCE);
    }

    private void changeRecipe(int direction) {
        if (!this.recipes.isEmpty()) {
            this.currentItemIndex = (this.currentItemIndex + direction) % this.recipes.size();
            this.getCurrentWeaponIndex = 0;
            this.getCurrentArmorIndex = 0;
            if (this.currentItemIndex < 0) {
                this.currentItemIndex += this.recipes.size();
            }
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97731_ = 10000;
        this.f_97729_ = 10000;
        int buttonY = this.f_97736_ - 20;
        int buttonX = this.f_97735_ + 88;
        this.leftButton = (Button)this.m_142416_((GuiEventListener)new Button(buttonX - 10, buttonY, 20, 20, (Component)Component.m_237113_((String)"<"), button -> this.changeRecipe(-1)));
        this.rightButton = (Button)this.m_142416_((GuiEventListener)new Button(buttonX + 10, buttonY, 20, 20, (Component)Component.m_237113_((String)">"), button -> this.changeRecipe(1)));
        this.leftDownButton = (Button)this.m_142416_((GuiEventListener)new Button(buttonX - 10, buttonY + 110, 20, 20, (Component)Component.m_237113_((String)"<"), button -> this.changeReagent(-1)));
        this.rightDownButton = (Button)this.m_142416_((GuiEventListener)new Button(buttonX + 10, buttonY + 110, 20, 20, (Component)Component.m_237113_((String)">"), button -> this.changeReagent(1)));
    }

    protected void m_7286_(PoseStack poseStack, float v, int i, int i1) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        InjectionRecipeScreen.m_93133_((PoseStack)poseStack, (int)this.f_97735_, (int)this.f_97736_, (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)this.f_97726_, (int)this.f_97727_);
        RenderSystem.m_69461_();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, delta);
        int x = this.f_97735_ + 34;
        int y = this.f_97736_ + 70;
        this.m_7025_(poseStack, mouseX, mouseY);
        InjectionRecipe recipe = this.recipes.get(this.currentItemIndex);
        if (recipe == null) {
            return;
        }
        ItemStack stack = recipe.m_8043_();
        this.renderFakeItem(this.f_96542_, this.f_96547_, new ItemStack((ItemLike)Sitems.SYRINGE.get()), this.f_97735_ + 97, this.f_97736_ + 17);
        this.renderFakeItem(this.f_96542_, this.f_96547_, stack.m_41777_(), this.f_97735_ + 97, this.f_97736_ + 53);
        this.renderName(poseStack, stack.m_41786_(), 90, 15);
        ItemStack weapon = new ItemStack((ItemLike)this.weaponItems.get(this.getCurrentWeaponIndex));
        ItemStack armor = new ItemStack((ItemLike)this.armorItems.get(this.getCurrentArmorIndex));
        ItemStack allItems = new ItemStack((ItemLike)this.allItems.get(this.getCurrentItemIndex));
        ItemStack reagent = new ItemStack((ItemLike)this.reagents.get(this.getCurrentReagentIndex));
        ItemStack mutatedTool = this.getCurrentMutantConstruct(stack.m_41777_(), weapon.m_41777_(), armor.m_41777_());
        if (!mutatedTool.equals(ItemStack.f_41583_)) {
            this.renderFakeItem(this.f_96542_, this.f_96547_, mutatedTool.m_41777_(), this.f_97735_ + 133, this.f_97736_ + 53);
        }
        if (stack.m_41720_() instanceof WeaponSyringe) {
            this.renderFakeItem(this.f_96542_, this.f_96547_, weapon.m_41777_(), this.f_97735_ + 133, this.f_97736_ + 17);
        }
        if (stack.m_41720_() instanceof ArmorSyringe) {
            this.renderFakeItem(this.f_96542_, this.f_96547_, armor.m_41777_(), this.f_97735_ + 133, this.f_97736_ + 17);
        }
        this.renderName(poseStack, reagent.m_41786_(), 75, 85);
        this.renderFakeItem(this.f_96542_, this.f_96547_, reagent.m_41777_(), this.f_97735_ + 43, this.f_97736_ + 89);
        ItemStack compatTool = this.getCurrentReagentItem(reagent, weapon, armor, allItems);
        this.renderFakeItem(this.f_96542_, this.f_96547_, compatTool.m_41777_(), this.f_97735_ + 43, this.f_97736_ + 125);
        ItemStack enchantedItem = this.getEnchantedType(reagent, compatTool);
        this.renderFakeItem(this.f_96542_, this.f_96547_, enchantedItem.m_41777_(), this.f_97735_ + 79, this.f_97736_ + 125);
        Enchantment enchantment = this.Enchantment(reagent.m_41777_());
        this.renderName(poseStack, enchantment.m_44700_(1), 90, 155);
        if (this.level != null) {
            int variant = recipe.getEntityType();
            ResourceLocation location = new ResourceLocation(recipe.getEntityId());
            Entity entity = ((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(location)).m_20615_((Level)this.level);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (living instanceof VariantKeeper) {
                    VariantKeeper keeper = (VariantKeeper)living;
                    keeper.setVariant(variant);
                    this.renderEntityInInventoryFollowsAngle(poseStack, x, y, 20, 0.0f, 0.0f, living);
                } else {
                    this.renderEntityInInventoryFollowsAngle(poseStack, x, y, 20, 0.0f, 0.0f, living);
                }
            }
        }
    }

    public ItemStack getCurrentMutantConstruct(ItemStack stack, ItemStack weapon, ItemStack armor) {
        Item item;
        Object mutations;
        AbstractSyringe syringe;
        Item item2 = stack.m_41720_();
        if (item2 instanceof WeaponSyringe) {
            syringe = (WeaponSyringe)item2;
            mutations = ((WeaponSyringe)syringe).getMutations();
            item = weapon.m_41720_();
            if (item instanceof SporeWeaponData) {
                SporeWeaponData sporeToolsBaseItem = (SporeWeaponData)item;
                sporeToolsBaseItem.setVariant((SporeToolsMutations)((Object)mutations), weapon);
                return weapon.m_41777_();
            }
        }
        if ((mutations = stack.m_41720_()) instanceof ArmorSyringe) {
            syringe = (ArmorSyringe)((Object)mutations);
            mutations = ((ArmorSyringe)syringe).getMutations();
            item = armor.m_41720_();
            if (item instanceof SporeArmorData) {
                SporeArmorData sporeToolsBaseItem = (SporeArmorData)item;
                sporeToolsBaseItem.setVariant((SporeArmorMutations)((Object)mutations), armor);
                return armor.m_41777_();
            }
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getCurrentReagentItem(ItemStack stack, ItemStack weapon, ItemStack armor, ItemStack both) {
        Item item = stack.m_41720_();
        if (item instanceof BiologicalReagent) {
            BiologicalReagent biologicalReagent = (BiologicalReagent)item;
            if (biologicalReagent.getType() == BiologicalReagent.AcceptedTypes.ALL_TYPES) {
                return both.m_41777_();
            }
            if (biologicalReagent.getType() == BiologicalReagent.AcceptedTypes.WEAPON_TYPES) {
                return weapon.m_41777_();
            }
            if (biologicalReagent.getType() == BiologicalReagent.AcceptedTypes.ARMOR_TYPES) {
                return armor.m_41777_();
            }
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getEnchantedType(ItemStack stack, ItemStack tool) {
        Item item = stack.m_41720_();
        if (item instanceof BiologicalReagent) {
            BiologicalReagent biologicalReagent = (BiologicalReagent)item;
            tool.m_41663_(biologicalReagent.getAppliedEnchantment(), 1);
            return tool;
        }
        return ItemStack.f_41583_;
    }

    public Enchantment Enchantment(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BiologicalReagent) {
            BiologicalReagent biologicalReagent = (BiologicalReagent)item;
            return biologicalReagent.getAppliedEnchantment();
        }
        return Enchantments.f_44977_;
    }

    private void renderName(PoseStack guiGraphics, Component name, int x, int y) {
        int iconX = this.f_97735_ + x;
        int iconY = this.f_97736_ + y;
        int iconWidth = 32;
        int textX = iconX + iconWidth / 2 - this.f_96547_.m_92852_((FormattedText)name) / 2;
        int textY = iconY - 10;
        InjectionRecipeScreen.m_93243_((PoseStack)guiGraphics, (Font)this.f_96547_, (Component)name, (int)textX, (int)textY, (int)0xFFFFFF);
    }

    public void renderEntityInInventoryFollowsAngle(PoseStack poseStack, int x, int y, int scale, float angleXComponent, float angleYComponent, LivingEntity entity) {
        poseStack.m_85836_();
        Quaternion pose = new Quaternion(0.0f, 180.0f, 180.0f, true);
        Quaternion cameraOrientation = new Quaternion(angleYComponent * 20.0f, 0.0f, 0.0f, true);
        pose.m_80148_(cameraOrientation);
        float originalBodyRot = entity.f_20883_;
        float originalYRot = entity.m_146908_();
        float originalXRot = entity.m_146909_();
        float originalHeadRotO = entity.f_20886_;
        float originalHeadRot = entity.f_20885_;
        entity.f_20883_ = 180.0f + angleXComponent * 20.0f;
        entity.m_146922_(180.0f + angleXComponent * 40.0f);
        entity.m_146926_(-angleYComponent * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        this.renderEntityInInventory(poseStack, x, y, scale, pose, entity);
        entity.f_20883_ = originalBodyRot;
        entity.m_146922_(originalYRot);
        entity.m_146926_(originalXRot);
        entity.f_20886_ = originalHeadRotO;
        entity.f_20885_ = originalHeadRot;
        poseStack.m_85849_();
    }

    private void renderEntityInInventory(PoseStack poseStack, int x, int y, int scale, Quaternion quaternion, LivingEntity entity) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 50.0);
        poseStack.m_85841_((float)scale, (float)scale, (float)scale);
        poseStack.m_85845_(quaternion);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Lighting.m_166384_();
        RenderSystem.m_157182_();
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        dispatcher.m_114468_(false);
        dispatcher.m_114468_(false);
        RenderSystem.m_69890_(() -> dispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0));
        bufferSource.m_109911_();
        poseStack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    private void changeReagent(int direction) {
        if (!this.recipes.isEmpty()) {
            this.getCurrentReagentIndex = (this.getCurrentReagentIndex + direction) % this.reagents.size();
            this.getCurrentWeaponIndex = 0;
            this.getCurrentArmorIndex = 0;
            if (this.getCurrentReagentIndex < 0) {
                this.getCurrentReagentIndex += this.reagents.size();
            }
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        if (!this.recipes.isEmpty()) {
            ++this.tickCounter;
            if (this.tickCounter % 40 == 0) {
                this.getCurrentWeaponIndex = (this.getCurrentWeaponIndex + 1) % this.weaponItems.size();
                this.getCurrentArmorIndex = (this.getCurrentArmorIndex + 1) % this.armorItems.size();
                this.getCurrentItemIndex = (this.getCurrentItemIndex + 1) % this.allItems.size();
            }
        }
    }
}

