/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Hyper;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class Brot
extends Hyper {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(Brot.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int swell;
    private final int maxSwell = 40;
    private boolean leapt = false;

    public Brot(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.brot_loot.get();
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)-1);
    }

    @Override
    public void m_7380_(CompoundTag data) {
        super.m_7380_(data);
        data.m_128376_("Fuse", (short)this.maxSwell);
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void setSwellDir(int data) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)data);
    }

    public void setLeapt(boolean value) {
        this.leapt = value;
    }

    public boolean getLeapt() {
        return this.leapt;
    }

    private void chemAttack(LivingEntity pLivingEntity) {
        AABB boundingBox = pLivingEntity.m_20191_().m_82400_(12.0);
        List entities = pLivingEntity.f_19853_.m_45933_((Entity)pLivingEntity, boundingBox);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (Utilities.helmetList().contains(livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_()) || !this.TARGET_SELECTOR.test(livingEntity)) continue;
            for (String str : (List)SConfig.SERVER.brot_effects.get()) {
                String[] string = str.split("\\|");
                MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(string[0]));
                if (effect == null || livingEntity.m_21023_(effect)) continue;
                livingEntity.m_7292_(new MobEffectInstance(effect, Integer.parseUnsignedInt(string[1]), Integer.parseUnsignedInt(string[2])));
            }
        }
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.f_21345_.m_25352_(2, (Goal)new BrotLeapGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new AOEMeleeAttackGoal((PathfinderMob)this, 1.2, true, 1.2, 5.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.brot_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.brot_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.brot_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            LivingEntity target;
            int i;
            if (this.f_19797_ % 20 == 0 && this.getLeapt() && this.f_19861_) {
                this.setLeapt(false);
            }
            if ((i = this.getSwellDir()) > 0 && this.swell == 0) {
                this.m_5496_((SoundEvent)Ssounds.BRAIOMIL_ATTACK.get(), 1.0f, 0.5f);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.setSwellDir(-1);
                this.chemAttack((LivingEntity)this);
            }
            if (this.f_19797_ % 20 == 0 && (target = this.m_5448_()) != null && this.m_20280_((Entity)target) < 120.0) {
                this.setSwellDir(1);
            }
        }
        super.m_8119_();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        Level world = this.f_19853_;
        if (this.swell >= 25) {
            for (int i = 0; i < 360; ++i) {
                if (i % 20 != 0) continue;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y + 1.0, z, Math.cos(i) * 0.15, Math.sin(i) * Math.cos(i) * 0.15, Math.sin(i) * 0.15);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.BROT_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    public static class BrotLeapGoal
    extends Goal {
        private final Brot mob;
        private LivingEntity target;

        public BrotLeapGoal(Brot value) {
            this.mob = value;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.mob.m_20160_()) {
                return false;
            }
            this.target = this.mob.m_5448_();
            if (this.target == null) {
                return false;
            }
            double d0 = this.mob.m_20280_((Entity)this.target);
            if (!(d0 < 16.0) && !(d0 > 48.0)) {
                if (!this.mob.f_19861_) {
                    return false;
                }
                return this.mob.m_217043_().m_188503_(BrotLeapGoal.m_186073_((int)5)) == 0;
            }
            return false;
        }

        public boolean m_8045_() {
            return !this.mob.f_19861_;
        }

        public void m_8056_() {
            Vec3 vec3 = this.mob.m_20184_();
            Vec3 vec31 = new Vec3(this.target.m_20185_() - this.mob.m_20185_(), 0.0, this.target.m_20189_() - this.mob.m_20189_());
            if (vec31.m_82556_() > 1.0E-7) {
                vec31 = vec31.m_82541_().m_82490_(0.8).m_82549_(vec3.m_82490_(0.3));
            }
            this.mob.m_20334_(vec31.f_82479_, 0.6, vec31.f_82481_);
            this.mob.setLeapt(true);
        }
    }
}

