/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Hyper;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.Projectile.ThrownItemProjectile;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class Hvindicator
extends Hyper
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> RIGHT_SKULL = SynchedEntityData.m_135353_(Hvindicator.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LEFT_SKULL = SynchedEntityData.m_135353_(Hvindicator.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TIME_AXE = SynchedEntityData.m_135353_(Hvindicator.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int attackAnimationTick;
    private int rangedAnimationTick;
    private int blockTime = 0;
    public AnimationState block_attack = new AnimationState();

    public Hvindicator(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.hindicator_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.hindicator_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.hindicator_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("left_skull", ((Boolean)this.f_19804_.m_135370_(LEFT_SKULL)).booleanValue());
        tag.m_128379_("right_skull", ((Boolean)this.f_19804_.m_135370_(RIGHT_SKULL)).booleanValue());
        tag.m_128405_("time_axe", ((Integer)this.f_19804_.m_135370_(TIME_AXE)).intValue());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(LEFT_SKULL, (Object)tag.m_128471_("left_skull"));
        this.f_19804_.m_135381_(RIGHT_SKULL, (Object)tag.m_128471_("right_skull"));
        this.f_19804_.m_135381_(TIME_AXE, (Object)tag.m_128451_("time_axe"));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RIGHT_SKULL, (Object)false);
        this.f_19804_.m_135372_(LEFT_SKULL, (Object)false);
        this.f_19804_.m_135372_(TIME_AXE, (Object)600);
    }

    public boolean hasRightSkull() {
        return (Boolean)this.f_19804_.m_135370_(RIGHT_SKULL);
    }

    public boolean hasLeftSkull() {
        return (Boolean)this.f_19804_.m_135370_(LEFT_SKULL);
    }

    public boolean hasAxe() {
        return (Integer)this.f_19804_.m_135370_(TIME_AXE) >= 600;
    }

    private void tickAxe() {
        if (this.hasAxe()) {
            return;
        }
        this.f_19804_.m_135381_(TIME_AXE, (Object)((Integer)this.f_19804_.m_135370_(TIME_AXE) + 1));
    }

    public void m_7822_(byte value) {
        if (value == 4) {
            this.attackAnimationTick = 10;
        } else if (value == 5) {
            this.block_attack.m_216977_(this.f_19797_);
            this.blockTime = 10;
        } else if (value == 6) {
            this.rangedAnimationTick = 10;
        } else {
            super.m_7822_(value);
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        Player player;
        this.attackAnimationTick = 10;
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        if (entity instanceof Player && (this.doesPlayerHaveShieldInHand(player = (Player)entity, InteractionHand.MAIN_HAND) || this.doesPlayerHaveShieldInHand(player, InteractionHand.OFF_HAND))) {
            player.m_36384_(true);
        }
        return super.m_7327_(entity);
    }

    public boolean doesPlayerHaveShieldInHand(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        return stack.m_41720_() instanceof ShieldItem;
    }

    public void m_8119_() {
        LivingEntity target;
        super.m_8119_();
        this.tickAxe();
        this.setupAnimationStates();
        if (this.f_19797_ % 60 == 0 && this.hasAxe() && (target = this.m_5448_()) != null && this.m_142582_((Entity)target)) {
            this.rangedAnimationTick = 10;
            this.f_19853_.m_7605_((Entity)this, (byte)6);
            this.m_6504_(target, 0.0f);
            this.f_19804_.m_135381_(TIME_AXE, (Object)0);
        }
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.hindicator_loot.get();
    }

    private void setupAnimationStates() {
        if (this.blockTime > 0) {
            if (this.blockTime == 1) {
                this.block_attack.m_216973_();
            }
            --this.blockTime;
        }
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.f_21345_.m_25352_(3, (Goal)new AOEMeleeAttackGoal((PathfinderMob)this, 1.2, true, 1.2, 3.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean m_213824_() {
        super.m_213824_();
        return true;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        float reduction = 1.0f;
        reduction = this.hasLeftSkull() ? reduction - 0.1f : reduction;
        float f = reduction = this.hasRightSkull() ? reduction - 0.1f : reduction;
        if (source.m_19360_() && Math.random() < 0.75) {
            if (!this.f_19853_.m_5776_()) {
                this.m_216990_(SoundEvents.f_12346_);
                this.f_19853_.m_7605_((Entity)this, (byte)5);
            }
            return false;
        }
        if (source.m_7639_() != null && Math.random() < (double)0.3f) {
            if (!this.f_19853_.m_5776_()) {
                this.f_19853_.m_7605_((Entity)this, (byte)5);
            }
            return false;
        }
        return super.m_6469_(source, amount * reduction);
    }

    public void awardSkull(LivingEntity entity) {
        if ((entity instanceof Villager || entity instanceof AbstractIllager || entity instanceof Witch) && !this.hasLeftSkull()) {
            this.f_19804_.m_135381_(LEFT_SKULL, (Object)true);
        }
        if ((entity instanceof Zombie || entity instanceof Player) && !this.hasRightSkull()) {
            this.f_19804_.m_135381_(RIGHT_SKULL, (Object)true);
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public int getRangedAttackAnimationTick() {
        return this.rangedAnimationTick;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        if (this.rangedAnimationTick > 0) {
            --this.rangedAnimationTick;
        }
    }

    public void m_6504_(LivingEntity livingEntity, float v) {
        ThrownItemProjectile thrownItemProjectile = new ThrownItemProjectile(this.f_19853_, (LivingEntity)this, (float)((Double)SConfig.SERVER.hindicator_ranged_damage.get() * 1.0), new ItemStack((ItemLike)Items.f_42386_));
        thrownItemProjectile.setLivingEntityPredicate(this.TARGET_SELECTOR);
        double d0 = livingEntity.m_20185_() - this.m_20185_();
        double d1 = livingEntity.m_20227_(0.3333333333333333) - thrownItemProjectile.m_20186_();
        double d2 = livingEntity.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        thrownItemProjectile.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 2.0f, 2.0f);
        this.m_5496_(SoundEvents.f_12313_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)thrownItemProjectile);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.HINDICATOR_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }
}

