/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Projectile;

import com.Harbinger.Spore.Core.Sentities;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class ThrownBlockProjectile
extends Projectile {
    private Predicate<LivingEntity> victim = livingEntity -> true;
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(ThrownBlockProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private BlockState STATE = Blocks.f_50440_.m_49966_();

    public ThrownBlockProjectile(Level level) {
        super((EntityType)Sentities.THROWN_BLOCK.get(), level);
    }

    public ThrownBlockProjectile(Level level, LivingEntity livingEntity2, Float damage, BlockState state, Predicate<LivingEntity> livingEntityPredicate) {
        super((EntityType)Sentities.THROWN_BLOCK.get(), level);
        this.m_5602_((Entity)livingEntity2);
        this.f_19804_.m_135381_(DAMAGE, (Object)damage);
        this.STATE = state;
        this.victim = livingEntityPredicate;
    }

    public BlockState state() {
        return this.STATE;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(5.0f));
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(tag.m_128457_("damage")));
        this.STATE = NbtUtils.m_129241_((CompoundTag)tag.m_128469_("state"));
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("damage", ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue());
        tag.m_128365_("state", (Tag)NbtUtils.m_129202_((BlockState)this.STATE));
    }

    protected boolean m_5603_(Entity entity) {
        LivingEntity livingEntity;
        return entity != this.m_37282_() || entity instanceof LivingEntity && this.victim.test(livingEntity = (LivingEntity)entity);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ >= 300) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            FallingBlockEntity.m_201971_((Level)this.f_19853_, (BlockPos)new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_()), (BlockState)this.STATE);
        }
        HitResult hitresult = ProjectileUtil.m_37294_((Entity)this, this::m_5603_);
        Vec3 vec3 = this.m_20184_();
        double d0 = this.m_20185_() + vec3.f_82479_;
        double d1 = this.m_20186_() + vec3.f_82480_;
        double d2 = this.m_20189_() + vec3.f_82481_;
        this.m_6034_(d0, d1, d2);
        if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
        this.m_20184_().m_82520_(0.0, -0.2, 0.0);
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity;
        super.m_5790_(result);
        if (!this.f_19853_.f_46443_ && (entity = result.m_82443_()) instanceof LivingEntity) {
            DamageSource damageSource;
            LivingEntity livingEntity = (LivingEntity)entity;
            BlockPos pos = new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_());
            Entity entity2 = this.m_37282_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity livingEntity1 = (LivingEntity)entity2;
                damageSource = DamageSource.m_19370_((LivingEntity)livingEntity1);
            } else {
                damageSource = DamageSource.f_19318_;
            }
            DamageSource damageSource2 = damageSource;
            livingEntity.m_6469_(damageSource2, ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue() * this.STATE.m_60800_((BlockGetter)this.f_19853_, pos));
            FallingBlockEntity.m_201971_((Level)this.f_19853_, (BlockPos)pos, (BlockState)this.STATE);
            this.m_146870_();
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        BlockPos pos = result.m_82425_().m_121945_(result.m_82434_()).m_7494_();
        FallingBlockEntity.m_201971_((Level)this.f_19853_, (BlockPos)pos, (BlockState)this.STATE);
        this.m_146870_();
    }
}

