/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Projectile;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Senchantments;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Sitems;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Fluids.BileLiquid;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeWeaponData;
import com.Harbinger.Spore.Sitems.InfectedSickle;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownSickle
extends AbstractArrow {
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(ThrownSickle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(ThrownSickle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private ItemStack spearItem = new ItemStack((ItemLike)Sitems.SICKLE.get());
    private boolean dealtDamage;
    private SickelState state = SickelState.FLYING;
    private Entity hookedEntity = null;
    private Vec3 hookedBlockPos = null;

    public ThrownSickle(Level level, LivingEntity livingEntity, ItemStack stack, int color) {
        super((EntityType)Sentities.THROWN_SICKEL.get(), livingEntity, level);
        this.m_5602_((Entity)livingEntity);
        this.spearItem = stack.m_41777_();
        this.f_19804_.m_135381_(ID_FOIL, (Object)stack.m_41790_());
        this.f_19804_.m_135381_(COLOR, (Object)color);
    }

    public ThrownSickle(Level level) {
        super((EntityType)Sentities.THROWN_SICKEL.get(), level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
        this.f_19804_.m_135372_(COLOR, (Object)0);
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    public ItemStack getSpearItem() {
        return this.spearItem;
    }

    public void m_8119_() {
        Entity owner;
        if (this.state == SickelState.HOOKED_IN_ENTITY && this.hookedEntity != null && this.hookedEntity.m_6084_()) {
            this.m_6034_(this.hookedEntity.m_20185_(), this.hookedEntity.m_20186_() + (double)this.hookedEntity.m_20206_() * 0.5, this.hookedEntity.m_20189_());
        }
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        if ((owner = this.m_37282_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)owner;
            ItemStack stack = living.m_21205_();
            if (this.m_20270_((Entity)living) > 30.0f || !(stack.m_41720_() instanceof InfectedSickle)) {
                Item item = stack.m_41720_();
                if (item instanceof InfectedSickle) {
                    InfectedSickle sickle = (InfectedSickle)item;
                    sickle.setThrownSickle(stack, false);
                }
                this.m_146870_();
            }
        } else {
            this.m_146870_();
        }
        super.m_8119_();
    }

    protected boolean m_142470_(Player p_150121_) {
        return false;
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 vec3, Vec3 vec31) {
        return this.dealtDamage ? null : super.m_6351_(vec3, vec31);
    }

    protected void m_5790_(EntityHitResult hit) {
        Entity entity1;
        Entity entity = hit.m_82443_();
        float f = (float)((Integer)SConfig.SERVER.sickle_damage.get()).intValue() + 0.5f * (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44977_, (ItemStack)this.spearItem);
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f += EnchantmentHelper.m_44833_((ItemStack)this.spearItem, (MobType)livingentity.m_6336_());
        }
        DamageSource damagesource = DamageSource.m_19337_((Entity)this, (Entity)((entity1 = this.m_37282_()) == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = (SoundEvent)Ssounds.INFECTED_WEAPON_HIT_ENTITY.get();
        if (entity.m_6469_(damagesource, f)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (entity1 instanceof LivingEntity) {
                    LivingEntity owner = (LivingEntity)entity1;
                    EnchantmentHelper.m_44823_((LivingEntity)livingEntity, (Entity)owner);
                    EnchantmentHelper.m_44896_((LivingEntity)owner, (Entity)livingEntity);
                    Item item = this.spearItem.m_41720_();
                    if (item instanceof SporeWeaponData) {
                        SporeWeaponData data = (SporeWeaponData)item;
                        data.abstractMutationBuffs(livingEntity, owner, this.spearItem, data);
                    }
                }
                if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)this.spearItem) > 0) {
                    int j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)this.spearItem);
                    entity.m_20254_(4 * j);
                }
                ThrownSickle.abstractEffects(this.spearItem, livingEntity);
                this.m_7761_(livingEntity);
            }
        }
        this.hookedEntity = entity;
        this.state = SickelState.HOOKED_IN_ENTITY;
        this.m_5496_(soundevent, 1.0f, 1.0f);
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.hookedBlockPos = result.m_82450_();
        this.state = SickelState.HOOKED_BLOCK;
    }

    protected SoundEvent m_7239_() {
        return (SoundEvent)Ssounds.INFECTED_WEAPON_HIT_BLOCK.get();
    }

    public SickelState getHookState() {
        return this.state;
    }

    public Entity getHookedEntity() {
        return this.hookedEntity;
    }

    public Vec3 getHookedBlockPos() {
        return this.hookedBlockPos;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Sickle", 10)) {
            this.spearItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Sickle"));
        }
        this.dealtDamage = tag.m_128471_("DealtDamage");
        if (this.m_37282_() != null) {
            tag.m_128362_("OwnerUUID", this.m_37282_().m_20148_());
        }
        this.f_19804_.m_135381_(COLOR, (Object)tag.m_128451_("color"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Sickle", (Tag)this.spearItem.m_41739_(new CompoundTag()));
        tag.m_128379_("DealtDamage", this.dealtDamage);
        tag.m_128405_("color", ((Integer)this.f_19804_.m_135370_(COLOR)).intValue());
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        Entity entity = this.m_37282_();
        if (entity != null) {
            Entity entity1;
            UUID uuid1 = entity.m_20148_();
            if (!this.f_19853_.f_46443_ && (entity1 = ((ServerLevel)this.f_19853_).m_8791_(uuid1)) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity1;
                this.m_5602_((Entity)livingEntity);
            }
        }
    }

    public void m_6901_() {
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED) {
            super.m_6901_();
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double p_37588_, double p_37589_, double p_37590_) {
        return true;
    }

    public static void abstractEffects(ItemStack stack, LivingEntity livingEntity) {
        if (stack.getEnchantmentLevel((Enchantment)Senchantments.CORROSIVE_POTENCY.get()) > 0) {
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)Seffects.CORROSION.get(), 200, 1));
        }
        if (stack.getEnchantmentLevel((Enchantment)Senchantments.GASTRIC_SPEWAGE.get()) > 0) {
            for (MobEffectInstance instance : BileLiquid.bileEffects()) {
                livingEntity.m_7292_(instance);
            }
        }
        if (stack.getEnchantmentLevel((Enchantment)Senchantments.CRYOGENIC_ASPECT.get()) > 0) {
            livingEntity.m_146917_(livingEntity.m_146888_() + 300);
        }
    }

    public static enum SickelState {
        FLYING,
        HOOKED_IN_ENTITY,
        HOOKED_BLOCK;

    }
}

