/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Client.AnimationTrackers.PCIAnimationTracker;
import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.ScreativeTab;
import com.Harbinger.Spore.Core.Sitems;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sitems.CustomModelArmorData;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class PCI
extends Item
implements CustomModelArmorData,
Vanishable {
    protected final UUID BONUS_DAMAGE_MODIFIER_UUID = UUID.fromString("035e66d6-5a74-402f-b64c-e61432ec39ba");
    protected final UUID BONUS_REACH_MODIFIER_UUID = UUID.fromString("d8c35ba5-f440-4335-92b2-3c8b1b703706");
    protected final UUID ATTACK_SPEED_MODIFIER_UUID = UUID.fromString("61bb4d9f-d2ea-4aa3-9468-9dd25a47bca1");
    private static final String CHARGE = "charge";
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore:textures/item/pci.png");
    private static final int RELOAD_TICKS = 60;

    public PCI() {
        super(new Item.Properties().m_41487_(1).m_41503_(((Integer)SConfig.SERVER.pci_durability.get()).intValue()).m_41491_(ScreativeTab.SPORE_T));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(this.BONUS_DAMAGE_MODIFIER_UUID, "Tool modifier", (double)((Integer)SConfig.SERVER.pci_damage.get() - 1), AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.ATTACK_RANGE.get()), (Object)new AttributeModifier(this.BONUS_REACH_MODIFIER_UUID, "Tool modifier", 2.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(this.ATTACK_SPEED_MODIFIER_UUID, "Delay modifier", -2.4, AttributeModifier.Operation.ADDITION));
        return slot == EquipmentSlot.MAINHAND ? builder.build() : ImmutableMultimap.of();
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return TEXTURE;
    }

    public void setCharge(ItemStack stack, int value) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(CHARGE, value);
    }

    public int getCharge(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128451_(CHARGE);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        Player player;
        if (entity.f_19853_.f_46443_ && entity instanceof Player && !(player = (Player)entity).m_36335_().m_41519_((Item)this)) {
            PCIAnimationTracker.trigger(player);
        }
        return super.onEntitySwing(stack, entity);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Infected infected;
        Player player;
        if (attacker instanceof Player && (player = (Player)attacker).m_36335_().m_41519_((Item)this)) {
            return false;
        }
        if (this.getCharge(stack) > 0 && target instanceof Infected && (infected = (Infected)target).getLinked()) {
            infected.setLinked(false);
        }
        if (attacker instanceof Player) {
            player = (Player)attacker;
            this.playSound(player);
        }
        stack.m_41622_(1, attacker, e -> e.m_21190_(attacker.m_7655_()));
        return true;
    }

    public void playSound(Player player) {
        player.m_6330_((SoundEvent)Ssounds.PCI_INJECT.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.getCharge(stack) < (Integer)SConfig.SERVER.pci_max_charge.get() / 2) {
            this.lookForAmmo(player, stack);
        }
        return super.m_7203_(level, player, hand);
    }

    private boolean lookForAmmo(Player player, ItemStack itemStack) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41720_() != Sitems.ICE_CANISTER.get() || stack.m_41613_() <= 0) continue;
            stack.m_41774_(1);
            this.setCharge(itemStack, (Integer)SConfig.SERVER.pci_max_charge.get());
            player.m_36335_().m_41524_((Item)this, 60);
            player.m_6330_((SoundEvent)Ssounds.CDU_INSERT.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> components, TooltipFlag p_41424_) {
        super.m_7373_(stack, p_41422_, components, p_41424_);
        components.add((Component)Component.m_237113_((String)("Frozen Charge " + this.getCharge(stack) + "/" + SConfig.SERVER.pci_max_charge.get())));
    }
}

