/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Sitems;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorMutations;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeBaseArmor;
import com.Harbinger.Spore.Sitems.CustomModelArmorData;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class UpgradedInfectedExoskeleton
extends SporeBaseArmor
implements CustomModelArmorData {
    private static final ResourceLocation location = new ResourceLocation("spore:textures/armor/living_armor_set_mk.png");

    public UpgradedInfectedExoskeleton(EquipmentSlot type) {
        super(type, new int[]{(Integer)SConfig.SERVER.boots_up_durability.get(), (Integer)SConfig.SERVER.pants_up_durability.get(), (Integer)SConfig.SERVER.chestplate_up_durability.get(), (Integer)SConfig.SERVER.helmet_up_durability.get()}, new int[]{(Integer)SConfig.SERVER.boots_up_protection.get(), (Integer)SConfig.SERVER.pants_up_protection.get(), (Integer)SConfig.SERVER.chestplate_up_protection.get(), (Integer)SConfig.SERVER.helmet_protection.get()}, (Integer)SConfig.SERVER.armor_toughness.get() + 2, ((Integer)SConfig.SERVER.knockback_resistance.get()).intValue(), (SoundEvent)Ssounds.INFECTED_GEAR_EQUIP.get(), "Upgraded Living Armor");
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        this.geteffect((LivingEntity)player);
        super.onArmorTick(stack, level, player);
    }

    public void geteffect(LivingEntity entity) {
        int val;
        if (!entity.m_21023_((MobEffect)Seffects.SYMBIOSIS.get()) && entity.f_19797_ % 20 == 0 && (val = this.getEffectMod(entity)) != -1) {
            entity.m_7292_(new MobEffectInstance((MobEffect)Seffects.SYMBIOSIS.get(), 200, val, false, false));
        }
    }

    private int getEffectMod(LivingEntity living) {
        int i = 0;
        ItemStack helmet = living.m_6844_(EquipmentSlot.HEAD);
        ItemStack chest = living.m_6844_(EquipmentSlot.CHEST);
        ItemStack legs = living.m_6844_(EquipmentSlot.LEGS);
        ItemStack feet = living.m_6844_(EquipmentSlot.FEET);
        if (helmet.equals(ItemStack.f_41583_) || chest.equals(ItemStack.f_41583_) || legs.equals(ItemStack.f_41583_) || feet.equals(ItemStack.f_41583_)) {
            return -1;
        }
        if (helmet.m_41720_().equals(Sitems.INF_UP_HELMET.get())) {
            i += 2;
        }
        if (chest.m_41720_().equals(Sitems.INF_UP_CHESTPLATE.get())) {
            i += 2;
        }
        if (legs.m_41720_().equals(Sitems.INF_UP_PANTS.get())) {
            i += 2;
        }
        if (feet.m_41720_().equals(Sitems.INF_UP_BOOTS.get())) {
            i += 2;
        }
        if (helmet.m_41720_().equals(Sitems.INF_HELMET.get())) {
            ++i;
        }
        if (chest.m_41720_().equals(Sitems.INF_CHEST.get())) {
            ++i;
        }
        if (legs.m_41720_().equals(Sitems.INF_PANTS.get())) {
            ++i;
        }
        if (feet.m_41720_().equals(Sitems.INF_BOOTS.get())) {
            ++i;
        }
        return i < 4 ? -1 : (i > 7 ? 1 : 0);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "spore:textures/entity/empty.png";
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return location;
    }

    public static class InfectedUpBoots
    extends UpgradedInfectedExoskeleton {
        public InfectedUpBoots() {
            super(EquipmentSlot.FEET);
        }

        @Override
        public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            UUID uuid = (UUID)this.UUIDS.get(slot);
            builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", this.calculateTrueDefense(stack, this.protection[slot.m_20749_()]) + this.modifyProtection(stack, this.protection[slot.m_20749_()]), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor modifier", this.calculateTrueToughness(stack, this.f_40382_) + this.modifyToughness(stack, this.f_40382_), AttributeModifier.Operation.ADDITION));
            if (this.knockback > 0.0f) {
                builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", ((double)this.knockback + this.modifyKnockbackResistance(stack, this.knockback)) * (double)0.1f, AttributeModifier.Operation.ADDITION));
            }
            builder.put((Object)((Attribute)ForgeMod.SWIM_SPEED.get()), (Object)new AttributeModifier(uuid, "Armor Speed modifier", this.getVariant(stack) == SporeArmorMutations.DROWNED ? 0.75 : 0.5, AttributeModifier.Operation.ADDITION));
            if (this.getVariant(stack) == SporeArmorMutations.REINFORCED || this.getVariant(stack) == SporeArmorMutations.SKELETAL) {
                builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(uuid, "Armor Speed modifier", this.getVariant(stack) == SporeArmorMutations.REINFORCED ? -0.01 : 0.01, AttributeModifier.Operation.ADDITION));
            }
            return slot == this.f_40377_ && this.tooHurt(stack) ? builder.build() : ImmutableMultimap.of();
        }
    }

    public static class InfectedUpPants
    extends UpgradedInfectedExoskeleton {
        public InfectedUpPants() {
            super(EquipmentSlot.LEGS);
        }

        @Override
        public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            UUID uuid = (UUID)this.UUIDS.get(slot);
            builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", this.calculateTrueDefense(stack, this.protection[slot.m_20749_()]) + this.modifyProtection(stack, this.protection[slot.m_20749_()]), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor modifier", this.calculateTrueToughness(stack, this.f_40382_) + this.modifyToughness(stack, this.f_40382_), AttributeModifier.Operation.ADDITION));
            if (this.knockback > 0.0f) {
                builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", ((double)this.knockback + this.modifyKnockbackResistance(stack, this.knockback)) * (double)0.1f, AttributeModifier.Operation.ADDITION));
            }
            builder.put((Object)((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()), (Object)new AttributeModifier(uuid, "Armor Step modifier", 0.75, AttributeModifier.Operation.ADDITION));
            if (this.getVariant(stack) == SporeArmorMutations.DROWNED) {
                builder.put((Object)((Attribute)ForgeMod.SWIM_SPEED.get()), (Object)new AttributeModifier(uuid, "Armor Speed modifier", 0.25, AttributeModifier.Operation.ADDITION));
            }
            float speed = this.getVariant(stack) == SporeArmorMutations.REINFORCED || this.getVariant(stack) == SporeArmorMutations.SKELETAL ? (this.getVariant(stack) == SporeArmorMutations.REINFORCED ? -0.01f : 0.01f) : 0.0f;
            builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(uuid, "Armor Speed modifier", 0.02 + (double)speed, AttributeModifier.Operation.ADDITION));
            return slot == this.f_40377_ && this.tooHurt(stack) ? builder.build() : ImmutableMultimap.of();
        }

        @Override
        public void onArmorTick(ItemStack stack, Level level, Player player) {
            super.onArmorTick(stack, level, player);
            if (player.f_19797_ % 30 == 0) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 40, 1, false, false));
            }
        }
    }

    public static class InfectedUpHelmet
    extends UpgradedInfectedExoskeleton {
        public InfectedUpHelmet() {
            super(EquipmentSlot.HEAD);
        }

        @Override
        public void onArmorTick(ItemStack stack, Level level, Player player) {
            super.onArmorTick(stack, level, player);
            if (player.f_19797_ % 10 == 0 && player.m_6047_()) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 600, 0, false, false));
            }
            if (player.f_19797_ % 20 == 0 && player.m_20069_()) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 200, 0, false, false));
            }
        }
    }

    public static class InfectedUpChestplate
    extends UpgradedInfectedExoskeleton {
        public InfectedUpChestplate() {
            super(EquipmentSlot.CHEST);
        }

        public static boolean isFlyEnabled(ItemStack stack) {
            return stack.m_41773_() < stack.m_41776_() - 10;
        }

        public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
            return InfectedUpChestplate.isFlyEnabled(stack);
        }

        public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
            int nextFlightTick;
            if (!entity.f_19853_.f_46443_ && (nextFlightTick = flightTicks + 1) % 10 == 0) {
                if (nextFlightTick % 20 == 0) {
                    stack.m_41622_(1, entity, e -> e.m_21166_(EquipmentSlot.CHEST));
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_36399_(0.1f);
                    }
                }
                entity.m_146850_(GameEvent.f_223705_);
            }
            return true;
        }

        @Override
        public void onArmorTick(ItemStack stack, Level level, Player entity) {
            if (entity.f_19862_ && entity.m_6047_()) {
                Vec3 initialVec = entity.m_20184_();
                Vec3 climbVec = new Vec3(initialVec.f_82479_, 0.2, initialVec.f_82481_);
                entity.m_20334_(climbVec.f_82479_ * 0.91, climbVec.f_82480_ * 0.98, climbVec.f_82481_ * 0.91);
            }
            super.onArmorTick(stack, level, entity);
        }

        @Override
        public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
            if (Screen.m_96638_()) {
                components.add((Component)Component.m_237115_((String)"item.armor.shift").m_130940_(ChatFormatting.DARK_RED));
            } else {
                components.add((Component)Component.m_237115_((String)"item.armor.normal").m_130940_(ChatFormatting.GOLD));
            }
            super.m_7373_(itemStack, level, components, tooltipFlag);
        }
    }
}

