/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.SegmentBase;
import com.Harbinger.Spore.Client.Models.TentacleSegmentModel;
import com.Harbinger.Spore.Client.Models.TentacleSegmentModel2;
import com.Harbinger.Spore.Client.Models.TentacleSegmentModel3;
import com.Harbinger.Spore.Sentities.Organoids.Tentacle;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;

public class TentacleRenderer
extends MobRenderer<Tentacle, EntityModel<Tentacle>> {
    private final TentacleSegmentModel<Entity> tentacleModel2 = new TentacleSegmentModel();
    private final TentacleSegmentModel2<Entity> tentacleModel1 = new TentacleSegmentModel2();
    private final TentacleSegmentModel3<Entity> tentacleModel3 = new TentacleSegmentModel3();
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/entity/tentacle_base.png");
    private static final ResourceLocation TENTACLE_SEG = new ResourceLocation("spore", "textures/entity/tentacle.png");

    public TentacleRenderer(EntityRendererProvider.Context context) {
        super(context, new SegmentBase(), 0.2f);
    }

    public EntityModel<Entity> getProperModel(int val) {
        switch (val) {
            case 1: {
                return this.tentacleModel1;
            }
            case 2: {
                return this.tentacleModel3;
            }
        }
        return this.tentacleModel2;
    }

    public void render(Tentacle entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        super.m_7392_((Mob)entity, entityYaw, partialTicks, stack, buffer, packedLight);
        Vec3 entityPos = entity.m_20318_(partialTicks);
        stack.m_85836_();
        stack.m_85837_(-entityPos.f_82479_, -entityPos.f_82480_, -entityPos.f_82481_);
        this.renderTentacle(stack, buffer, entity.getRightSegments(), (LivingEntity)entity, partialTicks);
        this.renderTentacle(stack, buffer, entity.getLeftSegments(), (LivingEntity)entity, partialTicks);
        this.renderTentacle(stack, buffer, entity.getRightBackSegments(), (LivingEntity)entity, partialTicks);
        this.renderTentacle(stack, buffer, entity.getLeftBackSegments(), (LivingEntity)entity, partialTicks);
        stack.m_85849_();
    }

    private void renderTentacle(PoseStack stack, MultiBufferSource buffer, PartEntity<?>[] segments, LivingEntity parent, float partial) {
        if (segments == null || segments.length < 2) {
            return;
        }
        PartEntity<?> entity = parent;
        float hurtTime = (float)parent.f_20916_ - partial;
        float flashIntensity = 0.0f;
        if (hurtTime > 0.0f) {
            flashIntensity = Math.min(hurtTime / 10.0f, 1.0f);
        }
        float red = 1.0f;
        float green = 1.0f - flashIntensity * 0.5f;
        float blue = 1.0f - flashIntensity * 0.5f;
        for (int i = 0; i < segments.length; ++i) {
            PartEntity<?> currentPos = segments[i];
            this.renderConnection((Entity)entity, (Entity)currentPos, stack, buffer, i, partial, red, green, blue);
            entity = currentPos;
        }
    }

    public Vec3 processPosition(Entity entity, float partialTicks) {
        Vec3 interpolatedPos = entity.m_20318_(partialTicks);
        double centerX = interpolatedPos.f_82479_;
        double centerY = interpolatedPos.f_82480_ + (double)(entity.m_20206_() / 2.0f);
        double centerZ = interpolatedPos.f_82481_;
        return new Vec3(centerX, centerY, centerZ);
    }

    private void renderConnection(Entity from, Entity to, PoseStack stack, MultiBufferSource buffer, int index, float partial, float r, float g, float b) {
        if (from == null || to == null) {
            return;
        }
        Vec3 goingTo = this.processPosition(from, partial);
        Vec3 direction = this.processPosition(to, partial).m_82546_(goingTo);
        float length = (float)direction.m_82553_();
        if (length < 1.0E-4f) {
            return;
        }
        direction = direction.m_82541_();
        float yaw = (float)Math.atan2(direction.f_82479_, direction.f_82481_);
        float pitch = (float)(-Math.asin(direction.f_82480_));
        stack.m_85836_();
        stack.m_85837_(goingTo.f_82479_, goingTo.f_82480_, goingTo.f_82481_);
        stack.m_252781_(Axis.f_252436_.m_252961_(yaw));
        stack.m_252781_(Axis.f_252529_.m_252961_(pitch));
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)TENTACLE_SEG));
        stack.m_85836_();
        EntityModel<Entity> model = this.getProperModel(index);
        stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        stack.m_252880_(0.0f, -length / 2.0f, 0.0f);
        stack.m_85841_(1.0f, length * 1.05f, 1.0f);
        model.m_6973_(from, 0.0f, 0.0f, (float)from.f_19797_ + partial, 0.0f, 0.0f);
        model.m_7695_(stack, consumer, 0xF000F0, OverlayTexture.f_118083_, r, g, b, 1.0f);
        stack.m_85849_();
        stack.m_85849_();
    }

    public ResourceLocation getTextureLocation(Tentacle tentacle) {
        return TEXTURE;
    }
}

