/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Utility;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sblocks;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.ExtremelySusThings.SporeSavedData;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.HybridPathNavigation;
import com.Harbinger.Spore.Sentities.ArmorPersentageBypass;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.MovementControls.InfectedWallMovementControl;
import com.Harbinger.Spore.Sentities.Utility.ScentEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class Specter
extends UtilityEntity
implements Enemy,
ArmorPersentageBypass {
    public static final EntityDataAccessor<Boolean> INVISIBLE = SynchedEntityData.m_135353_(Specter.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> BIOMASS = SynchedEntityData.m_135353_(Specter.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> STOMACH = SynchedEntityData.m_135353_(Specter.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final List<BlockState> states = new ArrayList<BlockState>(){
        {
            this.add(Blocks.f_50081_.m_49966_());
            this.add(Blocks.f_50174_.m_49966_());
            this.add(Blocks.f_50077_.m_49966_());
            this.add(((Block)Sblocks.CDU.get()).m_49966_());
        }
    };
    @Nullable
    private BlockPos Targetpos;

    public Specter(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.f_21342_ = new InfectedWallMovementControl((Mob)this);
        this.f_21344_ = new HybridPathNavigation((Mob)this, this.m_9236_());
        this.m_274367_(1.0f);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.gastgaber_loot.get();
    }

    public void m_7023_(Vec3 vec) {
        if (this.m_21515_() && this.isInFluidType()) {
            this.m_19920_(0.1f, vec);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            Vec3 vec3 = this.f_21342_.m_25001_() > this.m_20186_() ? new Vec3(0.0, 0.01, 0.0) : new Vec3(0.0, -0.01, 0.0);
            this.m_20256_(this.m_20184_().m_82490_(0.75).m_82549_(vec3));
            if (this.f_21344_.m_26576_() && this.m_217043_().m_188501_() < 0.4f) {
                this.m_21569_().m_24901_();
            }
        } else {
            super.m_7023_(vec);
        }
    }

    public boolean m_6785_(double value) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SporeSavedData data = SporeSavedData.getDataLocation(serverLevel);
            return data != null && data.getAmountOfHiveminds() >= (Integer)SConfig.SERVER.proto_spawn_world_mod.get() && value > 256.0;
        }
        return false;
    }

    public boolean m_213854_() {
        return this.m_20145_();
    }

    public boolean m_142065_() {
        return !this.m_20145_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.specter_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.specter_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.specter_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22282_, 3.0);
    }

    private void buffAI() {
        if (this.m_21223_() < this.m_21233_() && !this.m_21023_(MobEffects.f_19605_)) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 400, this.m_21223_() < this.m_21233_() / 2.0f ? 1 : 0));
            this.setBiomass(this.getBiomass() - 1);
        }
        if (this.m_6060_() && !this.m_21023_(MobEffects.f_19607_)) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 200, 0));
            this.setBiomass(this.getBiomass() - 1);
        }
    }

    protected void m_8099_() {
        this.addTargettingGoals();
        this.f_21345_.m_25352_(3, (Goal)new CustomMeleeAttackGoal(this, 1.2, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 4.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new SearchAroundGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        super.m_8099_();
    }

    public void m_6842_(boolean value) {
        this.f_19804_.m_135381_(INVISIBLE, (Object)value);
    }

    public boolean m_20145_() {
        return (Boolean)this.f_19804_.m_135370_(INVISIBLE);
    }

    public void setBiomass(int value) {
        this.f_19804_.m_135381_(BIOMASS, (Object)value);
    }

    public int getBiomass() {
        return (Integer)this.f_19804_.m_135370_(BIOMASS);
    }

    public void setStomach(int value) {
        this.f_19804_.m_135381_(STOMACH, (Object)value);
    }

    public int getStomach() {
        return (Integer)this.f_19804_.m_135370_(STOMACH);
    }

    @Nullable
    public BlockPos getTargetPos() {
        return this.Targetpos;
    }

    public void setTargetPos(@Nullable BlockPos pos) {
        this.Targetpos = pos;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(INVISIBLE, (Object)false);
        this.f_19804_.m_135372_(STOMACH, (Object)0);
        this.f_19804_.m_135372_(BIOMASS, (Object)0);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_6842_(tag.m_128471_("invisible"));
        this.setBiomass(tag.m_128451_("biomass"));
        this.setStomach(tag.m_128451_("stomach"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("invisible", this.m_20145_());
        tag.m_128405_("biomass", this.getBiomass());
        tag.m_128405_("stomach", this.getStomach());
    }

    private boolean food(Container container) {
        return container.m_216874_(ItemStack::m_41614_);
    }

    public void searchBlocks() {
        AABB aabb = this.m_20191_().m_82377_(32.0, 4.0, 32.0);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            Container container;
            BlockState block = this.m_9236_().m_8055_(blockpos);
            BlockEntity blockEntity = this.m_9236_().m_7702_(blockpos);
            if (!states.contains(block) && (!(blockEntity instanceof Container) || !this.food(container = (Container)blockEntity)) || !this.hasLineOfSightBlocks(blockpos) || !(this.f_19796_.m_188501_() < 0.5f)) continue;
            this.setTargetPos(blockpos);
            break;
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)Seffects.MYCELIUM.get(), 200, 1));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0));
        }
        return super.m_7327_(entity);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public void m_5993_(Entity p_19953_, int p_19954_, DamageSource p_19955_) {
        this.setBiomass(this.getBiomass() + 1);
        super.m_5993_(p_19953_, p_19954_, p_19955_);
    }

    public boolean blockBreakingParameter(BlockState blockstate, BlockPos blockpos) {
        float value = blockstate.m_60800_((BlockGetter)this.m_9236_(), blockpos);
        return this.f_19797_ % 20 == 0 && value > 0.0f && value <= (float)this.getBreaking();
    }

    public int getBreaking() {
        return (Integer)SConfig.SERVER.hyper_bd.get();
    }

    public boolean hasLineOfSightBlocks(BlockPos pos) {
        BlockHitResult raytraceresult = this.m_9236_().m_45547_(new ClipContext(this.m_20299_(1.0f), new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        BlockPos position = raytraceresult.m_82425_();
        return pos.equals((Object)position) || this.m_9236_().m_46859_(pos) || this.m_9236_().m_7702_(pos) == this.m_9236_().m_7702_(position);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 200 == 0) {
            this.searchBlocks();
            if ((float)this.getStomach() > 10.0f) {
                this.setBiomass(this.getBiomass() + 1);
                this.setStomach(this.getStomach() - 10);
            }
        }
        if (this.f_19797_ % 20 == 0 && this.getBiomass() > 0) {
            this.buffAI();
        }
        if (this.f_19797_ % 40 == 0 && this.f_19862_ && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            this.griefBlocks(this.m_5448_());
        }
    }

    public void m_6710_(@Nullable LivingEntity entity) {
        super.m_6710_(entity);
        this.m_6842_(entity != null && entity.m_20280_((Entity)this) > 50.0);
    }

    private void griefBlocks(LivingEntity livingEntity) {
        AABB aabb = livingEntity != null && livingEntity.m_20186_() > this.m_20186_() ? this.m_20191_().m_82377_(-0.2, 0.5, -0.2).m_82386_(0.0, 0.5, 0.0) : this.m_20191_().m_82400_(0.5).m_82386_(0.0, 0.5, 0.0);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (!this.blockBreakingParameter(blockstate, blockpos)) continue;
            this.interactBlock(blockpos, this.m_9236_());
        }
    }

    protected SoundEvent m_7515_() {
        return this.m_20145_() ? null : (SoundEvent)Ssounds.SPECTER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return (SoundEvent)Ssounds.EVOLVE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    public boolean m_142582_(Entity entity) {
        InventoryCarrier carrier;
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_((MobEffect)Seffects.MARKER.get())) {
            return true;
        }
        if (entity instanceof InventoryCarrier && (carrier = (InventoryCarrier)entity).m_35311_().m_216874_(ItemStack::m_41614_)) {
            return true;
        }
        return super.m_142582_(entity);
    }

    public boolean interractWithBlock(BlockPos pos) {
        Container container;
        BlockEntity blockEntity = this.m_9236_().m_7702_(pos);
        if (blockEntity instanceof Container && this.food(container = (Container)blockEntity)) {
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                FoodProperties properties = stack.getFoodProperties((LivingEntity)this);
                if (!stack.m_41614_() || properties == null) continue;
                int amount = stack.m_41613_() > 1 ? this.f_19796_.m_188503_(stack.m_41613_()) : stack.m_41613_();
                this.m_216990_(SoundEvents.f_11912_);
                stack.m_41774_(amount);
                this.setStomach(this.getStomach() + (int)((float)properties.m_38744_() + properties.m_38745_()) * amount);
            }
        } else {
            this.m_9236_().m_46953_(pos, true, (Entity)this);
        }
        return true;
    }

    public boolean m_6469_(DamageSource source, float p_21017_) {
        if (source.m_7639_() != null && this.f_19796_.m_188501_() < 0.1f) {
            ScentEntity scent = new ScentEntity((EntityType<? extends PathfinderMob>)((EntityType)Sentities.SCENT.get()), this.m_9236_());
            scent.m_6027_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.m_9236_().m_7967_((Entity)scent);
        }
        return super.m_6469_(source, p_21017_);
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        return super.m_5639_(p_21237_, p_21238_) - 15;
    }

    @Override
    public float amountOfDamage(float value) {
        return (float)((Double)SConfig.SERVER.specter_damage.get() * (Double)SConfig.SERVER.global_damage.get() / 4.0);
    }

    public boolean interactBlock(BlockPos blockPos, Level level) {
        BlockState state = level.m_8055_(blockPos);
        if (Utilities.biomass().contains(state)) {
            return level.m_7731_(blockPos, ((Block)Sblocks.MEMBRANE_BLOCK.get()).m_49966_(), 3);
        }
        return level.m_46953_(blockPos, false, (Entity)this);
    }

    public static class SearchAroundGoal
    extends Goal {
        private final Specter specter;
        public int tryTicks;

        public SearchAroundGoal(Specter specter) {
            this.specter = specter;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.specter.getTargetPos() != null && this.specter.m_5448_() == null;
        }

        protected void moveToBlock(BlockPos pos) {
            if (pos != null) {
                this.specter.f_21344_.m_26519_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 1.0);
            }
        }

        public void m_8056_() {
            this.moveToBlock(this.specter.getTargetPos());
            this.tryTicks = 0;
            super.m_8056_();
        }

        public boolean m_8045_() {
            return this.specter.m_5448_() == null;
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 40 == 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.tryTicks;
            BlockPos pos = this.specter.getTargetPos();
            if (pos != null && this.shouldRecalculatePath()) {
                this.moveToBlock(pos);
            }
            if (pos != null && pos.m_203195_((Position)this.specter.m_20182_(), 3.5)) {
                this.specter.interractWithBlock(pos);
                this.openChest(pos);
                this.specter.setTargetPos(null);
                this.specter.searchBlocks();
            }
        }

        public void openChest(BlockPos pos) {
            BlockEntity entity = this.specter.m_9236_().m_7702_(pos);
            if (entity instanceof ChestBlockEntity) {
                ChestBlockEntity chestBlock = (ChestBlockEntity)entity;
                this.specter.m_216990_(SoundEvents.f_11749_);
                this.specter.m_9236_().m_7696_(pos, chestBlock.m_58900_().m_60734_(), 1, 1);
                this.specter.m_9236_().m_46672_(pos, chestBlock.m_58900_().m_60734_());
                this.specter.m_9236_().m_46672_(pos.m_7495_(), chestBlock.m_58900_().m_60734_());
            }
        }
    }
}

