/*
 * Decompiled with CFR 0.152.
 */
package net.redflower.pridecraft.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.redflower.pridecraft.datagen.ModBlockLootTableProvider;
import net.redflower.pridecraft.datagen.ModBlockTagProvider;
import net.redflower.pridecraft.datagen.ModDataPackProvider;
import net.redflower.pridecraft.datagen.ModItemTagProvider;
import net.redflower.pridecraft.datagen.ModModelProvider;
import net.redflower.pridecraft.datagen.ModRecipeProvider;

@EventBusSubscriber(modid="pridecraft")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherClientData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ModBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(true, (DataProvider)new ModRecipeProvider.Runner(packOutput, lookupProvider));
        ModBlockTagProvider blockTagsProvider = new ModBlockTagProvider(packOutput, lookupProvider);
        generator.addProvider(true, (DataProvider)blockTagsProvider);
        generator.addProvider(true, (DataProvider)new ModItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter()));
        generator.addProvider(true, (DataProvider)new ModModelProvider(packOutput));
        generator.addProvider(true, (DataProvider)new ModDataPackProvider(packOutput, lookupProvider));
    }

    @SubscribeEvent
    public static void gatherServerData(GatherDataEvent.Server event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ModBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(true, (DataProvider)new ModRecipeProvider.Runner(packOutput, lookupProvider));
        ModBlockTagProvider blockTagsProvider = new ModBlockTagProvider(packOutput, lookupProvider);
        generator.addProvider(true, (DataProvider)blockTagsProvider);
        generator.addProvider(true, (DataProvider)new ModItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter()));
        generator.addProvider(true, (DataProvider)new ModModelProvider(packOutput));
        generator.addProvider(true, (DataProvider)new ModDataPackProvider(packOutput, lookupProvider));
    }
}

