/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.ghostgear.common.impl.spiritbox;

import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.ghostgear.common.impl.GhostGear;
import net.darkhax.ghostgear.common.impl.spiritbox.ScanMode;
import net.darkhax.ghostgear.common.impl.spiritbox.ScanSpeed;
import net.darkhax.ghostgear.common.impl.spiritbox.SpiritBoxMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.EnumUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpiritBoxBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final CachedSupplier<BlockEntityType<SpiritBoxBlockEntity>> TYPE = CachedSupplier.of((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (ResourceLocation)GhostGear.id("spirit_box")).cast();
    private final DataAccess dataAccess;
    private ScanMode scanMode = ScanMode.WORDS;
    private ScanSpeed scanSpeed = ScanSpeed.STEADY;
    private int wordTimer = 0;
    private int secondWordTimer = -1;

    public SpiritBoxBlockEntity(BlockPos pos, BlockState blockState) {
        this((BlockEntityType)TYPE.get(), pos, blockState);
    }

    public SpiritBoxBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.dataAccess = new DataAccess(this);
    }

    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.scanMode = (ScanMode)EnumUtils.getEnum(ScanMode.class, (String)tag.getString("scan_mode"), (Enum)ScanMode.WORDS);
        this.scanSpeed = (ScanSpeed)EnumUtils.getEnum(ScanSpeed.class, (String)tag.getString("scan_speed"), (Enum)ScanSpeed.STEADY);
        this.wordTimer = tag.getInt("word_timer");
        this.secondWordTimer = tag.getInt("second_word_timer");
    }

    public void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putString("scan_mode", this.scanMode.name());
        tag.putString("scan_speed", this.scanSpeed.name());
        tag.putInt("word_timer", this.wordTimer);
        tag.putInt("second_word_timer", this.secondWordTimer);
    }

    public ContainerData getDataAccess() {
        return this.dataAccess;
    }

    public void update(ScanMode mode, ScanSpeed speed) {
        this.scanMode = mode;
        this.scanSpeed = speed;
        this.wordTimer = this.scanSpeed.scanSpeed();
        this.secondWordTimer = -1;
    }

    public static void tickBox(Level level, BlockPos pos, BlockState state, SpiritBoxBlockEntity box) {
        if (!box.isRemoved() && box.level instanceof ServerLevel) {
            --box.wordTimer;
            if (box.wordTimer <= 0) {
                box.wordTimer = box.scanSpeed.scanSpeed();
                BuiltInRegistries.SOUND_EVENT.getRandomElementOf(box.scanMode.soundTag(), level.random).ifPresent(soundEventHolder -> level.playSound(null, pos, (SoundEvent)soundEventHolder.value(), SoundSource.BLOCKS, 1.0f, 1.0f));
                if (level.getRandom().nextFloat() < 0.45f) {
                    box.secondWordTimer = 60;
                }
            }
            if (box.secondWordTimer > -1) {
                --box.secondWordTimer;
                if (box.secondWordTimer <= 0) {
                    box.secondWordTimer = -1;
                    BuiltInRegistries.SOUND_EVENT.getRandomElementOf(box.scanMode.soundTag(), level.random).ifPresent(soundEventHolder -> level.playSound(null, pos, (SoundEvent)soundEventHolder.value(), SoundSource.BLOCKS, 1.0f, 1.0f));
                }
            }
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.ghostgear.spirit_box");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInv, @NotNull Player player) {
        return SpiritBoxMenu.serverMenu(containerId, playerInv, this);
    }

    public record DataAccess(SpiritBoxBlockEntity box) implements ContainerData
    {
        public int get(int index) {
            return switch (index) {
                case 0 -> this.box.scanMode.ordinal();
                case 1 -> this.box.scanSpeed.ordinal();
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    this.box.scanMode = ScanMode.values()[value];
                    break;
                }
                case 1: {
                    this.box.scanSpeed = ScanSpeed.values()[value];
                }
            }
            this.box.setChanged();
        }

        public int getCount() {
            return 2;
        }
    }
}

