/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client;

import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_7778778;
import net.minecraft.unmapped.C_8105098;
import redstone.multimeter.client.Keybinds;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.gui.screen.MultimeterScreen;
import redstone.multimeter.client.gui.screen.OptionsScreen;
import redstone.multimeter.client.gui.screen.RSMMScreen;
import redstone.multimeter.client.gui.screen.TickPhaseTreeScreen;
import redstone.multimeter.common.meter.event.EventType;

public class InputHandler {
    private final MultimeterClient client;

    public InputHandler(MultimeterClient client) {
        this.client = client;
    }

    public void handleKeybinds() {
        if (!this.client.isConnected()) {
            return;
        }
        while (Keybinds.OPEN_MULTIMETER_SCREEN.m_4823804()) {
            this.client.openScreen(new MultimeterScreen());
        }
        while (Keybinds.OPEN_OPTIONS_MENU.m_4823804()) {
            this.client.openScreen(new OptionsScreen());
        }
        while (Keybinds.VIEW_TICK_PHASE_TREE.m_4823804()) {
            this.client.openScreen(new TickPhaseTreeScreen());
        }
        while (Keybinds.LOAD_METER_GROUP.m_4823804()) {
            this.client.getSavedMeterGroupsManager().setLoading();
        }
        while (Keybinds.SAVE_METER_GROUP.m_4823804()) {
            this.client.getSavedMeterGroupsManager().setSaving();
        }
        if (!Keybinds.LOAD_METER_GROUP.m_7042641() && !Keybinds.SAVE_METER_GROUP.m_7042641()) {
            this.client.getSavedMeterGroupsManager().setIdle();
        }
        if (!this.client.hasSubscription()) {
            return;
        }
        while (Keybinds.TOGGLE_METER.m_4823804()) {
            this.client.toggleMeter();
        }
        while (Keybinds.RESET_METER.m_4823804()) {
            this.client.resetMeter();
        }
        while (Keybinds.TOGGLE_HUD.m_4823804()) {
            this.client.toggleHud();
        }
        while (Keybinds.PRINT_LOGS.m_4823804()) {
            this.client.togglePrinter();
        }
        while (Keybinds.OPEN_METER_CONTROLS.m_4823804()) {
            this.client.openMeterControls();
        }
        for (int index = 0; index < Keybinds.TOGGLE_EVENT_TYPES.length; ++index) {
            C_7778778 keybind = Keybinds.TOGGLE_EVENT_TYPES[index];
            while (keybind.m_4823804()) {
                this.client.toggleEventType(EventType.byId(index));
            }
        }
        if (!this.client.isHudActive()) {
            return;
        }
        while (Keybinds.PAUSE_TIMELINE.m_4823804()) {
            this.client.getHud().togglePaused();
        }
        while (Keybinds.TOGGLE_FOCUS_MODE.m_4823804()) {
            this.client.getHud().toggleFocusMode();
        }
        while (Keybinds.TOGGLE_MARKER.m_4823804()) {
            this.client.getHud().toggleTickMarker(C_3020744.m_7566055());
        }
        while (Keybinds.STEP_BACKWARD.m_4823804()) {
            this.client.getHud().stepBackward(C_3020744.m_7566055());
        }
        while (Keybinds.STEP_FORWARD.m_4823804()) {
            this.client.getHud().stepForward(C_3020744.m_7566055());
        }
    }

    public boolean handleHotbarKeybinds(int slot) {
        if (!this.client.isConnected()) {
            return false;
        }
        ++slot;
        if (Keybinds.LOAD_METER_GROUP.m_7042641()) {
            return this.client.getSavedMeterGroupsManager().loadSlot(slot);
        }
        if (Keybinds.SAVE_METER_GROUP.m_7042641()) {
            return this.client.getSavedMeterGroupsManager().saveSlot(slot);
        }
        return false;
    }

    public boolean handleMouseScroll(double scrollX, double scrollY) {
        if (Keybinds.SCROLL_HUD.m_7042641() && this.client.isHudActive() && this.client.getHud().isPaused()) {
            boolean forward;
            int scroll = (int)Math.round(scrollY);
            boolean bl = forward = scroll < 0;
            if (scroll != 0) {
                this.client.getHud().scroll(Math.abs(scroll), forward);
            }
        } else {
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mouseClick(RSMMScreen screen, double mouseX, double mouseY, int button) {
        if (Keybinds.matchesButton(Keybinds.OPEN_MULTIMETER_SCREEN, button)) {
            if (screen instanceof MultimeterScreen) {
                screen.close();
                return true;
            } else {
                C_8105098 minecraft = this.client.getMinecraft();
                if (minecraft.f_7663840 == null) return true;
                this.client.openScreen(new MultimeterScreen());
            }
            return true;
        } else if (Keybinds.matchesButton(Keybinds.OPEN_OPTIONS_MENU, button)) {
            if (screen instanceof OptionsScreen) {
                screen.close();
                return true;
            } else {
                this.client.openScreen(new OptionsScreen());
            }
            return true;
        } else if (Keybinds.matchesButton(Keybinds.VIEW_TICK_PHASE_TREE, button)) {
            if (!this.client.isConnected()) {
                return false;
            }
            if (screen instanceof TickPhaseTreeScreen) {
                screen.close();
                return true;
            } else {
                this.client.openScreen(new TickPhaseTreeScreen());
            }
            return true;
        } else {
            if (!(screen instanceof MultimeterScreen)) return false;
            if (Keybinds.matchesButton(Keybinds.PAUSE_TIMELINE, button)) {
                this.client.getHud().togglePaused();
                return true;
            } else if (Keybinds.matchesButton(Keybinds.TOGGLE_FOCUS_MODE, button)) {
                this.client.getHud().toggleFocusMode();
                return true;
            } else if (Keybinds.matchesButton(Keybinds.TOGGLE_MARKER, button)) {
                this.client.getHud().toggleTickMarker(C_3020744.m_7566055());
                return true;
            } else if (Keybinds.matchesButton(Keybinds.STEP_BACKWARD, button)) {
                this.client.getHud().stepBackward(C_3020744.m_7566055());
                return true;
            } else {
                if (!Keybinds.matchesButton(Keybinds.STEP_FORWARD, button)) return false;
                this.client.getHud().stepForward(C_3020744.m_7566055());
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean keyPress(RSMMScreen screen, int keyCode) {
        if (Keybinds.matchesKey(Keybinds.OPEN_MULTIMETER_SCREEN, keyCode)) {
            if (screen instanceof MultimeterScreen) {
                screen.close();
                return true;
            } else {
                C_8105098 minecraft = this.client.getMinecraft();
                if (minecraft.f_7663840 == null) return true;
                this.client.openScreen(new MultimeterScreen());
            }
            return true;
        } else if (Keybinds.matchesKey(Keybinds.OPEN_OPTIONS_MENU, keyCode)) {
            if (screen instanceof OptionsScreen) {
                screen.close();
                return true;
            } else {
                this.client.openScreen(new OptionsScreen());
            }
            return true;
        } else if (Keybinds.matchesKey(Keybinds.VIEW_TICK_PHASE_TREE, keyCode)) {
            if (!this.client.isConnected()) {
                return false;
            }
            if (screen instanceof TickPhaseTreeScreen) {
                screen.close();
                return true;
            } else {
                this.client.openScreen(new TickPhaseTreeScreen());
            }
            return true;
        } else {
            if (!(screen instanceof MultimeterScreen)) return false;
            if (Keybinds.matchesKey(Keybinds.PAUSE_TIMELINE, keyCode)) {
                this.client.getHud().togglePaused();
                return true;
            } else if (Keybinds.matchesKey(Keybinds.TOGGLE_FOCUS_MODE, keyCode)) {
                this.client.getHud().toggleFocusMode();
                return true;
            } else if (Keybinds.matchesKey(Keybinds.TOGGLE_MARKER, keyCode)) {
                this.client.getHud().toggleTickMarker(C_3020744.m_7566055());
                return true;
            } else if (Keybinds.matchesKey(Keybinds.STEP_BACKWARD, keyCode)) {
                this.client.getHud().stepBackward(C_3020744.m_7566055());
                return true;
            } else {
                if (!Keybinds.matchesKey(Keybinds.STEP_FORWARD, keyCode)) return false;
                this.client.getHud().stepForward(C_3020744.m_7566055());
            }
        }
        return true;
    }

    public boolean mouseScroll(RSMMScreen screen, double scrollX, double scrollY) {
        if (screen instanceof MultimeterScreen) {
            if (!this.isPressed(Keybinds.SCROLL_HUD)) {
                return false;
            }
        } else {
            return false;
        }
        this.client.getHud().scroll((int)Math.round(scrollY), true);
        return true;
    }

    private boolean isPressed(C_7778778 keybind) {
        return Keybinds.isPressed(keybind);
    }
}

