/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.unmapped.C_7778778;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import redstone.multimeter.RedstoneMultimeterMod;
import redstone.multimeter.common.meter.event.EventType;

public class Keybinds {
    private static final String FILE_NAME = "hotkeys-legacy.txt";
    private static final Set<String> CATEGORIES = new LinkedHashSet<String>();
    private static final Map<String, C_7778778> KEYBINDS = new LinkedHashMap<String, C_7778778>();
    private static final Map<String, C_7778778> LEGACY_KEYBINDS = new HashMap<String, C_7778778>();
    public static final C_7778778[] TOGGLE_EVENT_TYPES = new C_7778778[EventType.ALL.length];
    public static final String MAIN = Keybinds.registerCategory("redstoneMultimeter");
    public static final String METER_EVENT_TYPES = Keybinds.registerCategory("meterEventTypes");
    public static final C_7778778 TOGGLE_METER = Keybinds.registerKeybind("toggleMeter", "Toggle Meter", MAIN, 50);
    public static final C_7778778 RESET_METER = Keybinds.registerKeybind("resetMeter", "Reset Meter", MAIN, 48);
    public static final C_7778778 LOAD_METER_GROUP = Keybinds.registerKeybind("loadMeterGroup", "Load Meter Group", MAIN, 26);
    public static final C_7778778 SAVE_METER_GROUP = Keybinds.registerKeybind("saveMeterGroup", "Save Meter Group", MAIN, 27);
    public static final C_7778778 PAUSE_TIMELINE = Keybinds.registerKeybind("pauseTimeline", "Pause Meters", MAIN, 49);
    public static final C_7778778 TOGGLE_FOCUS_MODE;
    public static final C_7778778 TOGGLE_MARKER;
    public static final C_7778778 STEP_BACKWARD;
    public static final C_7778778 STEP_FORWARD;
    public static final C_7778778 SCROLL_HUD;
    public static final C_7778778 TOGGLE_HUD;
    public static final C_7778778 OPEN_MULTIMETER_SCREEN;
    public static final C_7778778 OPEN_METER_CONTROLS;
    public static final C_7778778 OPEN_OPTIONS_MENU;
    public static final C_7778778 VIEW_TICK_PHASE_TREE;
    public static final C_7778778 PRINT_LOGS;
    private static final int MOUSE_BUTTON_OFFSET = 100;

    private static String registerCategory(String category) {
        category = "rsmm.keybind.category." + category;
        if (!CATEGORIES.add(category)) {
            throw new IllegalStateException("Cannot register multiple keybind categories with the same name! (" + category + ")");
        }
        return category;
    }

    private static C_7778778 registerKeybind(String name, String legacyName, String category, int defaultKey) {
        name = "rsmm.keybind." + name;
        if (KEYBINDS.containsKey(name)) {
            throw new IllegalStateException("Cannot register multiple keybinds with the same name! (" + name + ")");
        }
        C_7778778 keybind = new C_7778778(name, defaultKey, category);
        KEYBINDS.put(name, keybind);
        if (legacyName != null) {
            LEGACY_KEYBINDS.put(legacyName, keybind);
        }
        return keybind;
    }

    public static Collection<String> getCategories() {
        return Collections.unmodifiableSet(CATEGORIES);
    }

    public static Collection<C_7778778> getKeybinds() {
        return Collections.unmodifiableCollection(KEYBINDS.values());
    }

    public static void load(Path dir) {
        Path file = dir.resolve(FILE_NAME);
        if (!Files.exists(file, new LinkOption[0])) {
            Keybinds.save(dir);
            return;
        }
        try (BufferedReader br = Files.newBufferedReader(file);){
            String line;
            while ((line = br.readLine()) != null) {
                String[] args = line.split("=", 2);
                if (args.length < 2) continue;
                String name = args[0];
                String key = args[1];
                C_7778778 keybind = KEYBINDS.get(name);
                if (keybind == null) {
                    keybind = LEGACY_KEYBINDS.get(name);
                }
                if (keybind == null) continue;
                keybind.m_8120131(Integer.parseInt(key));
            }
        }
        catch (IOException e) {
            RedstoneMultimeterMod.LOGGER.warn("exception while loading keybinds", (Throwable)e);
        }
    }

    public static void save(Path dir) {
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("unable to create parent directories of keybinds file", e);
            }
        }
        Path file = dir.resolve(FILE_NAME);
        try (BufferedWriter bw = Files.newBufferedWriter(file, new OpenOption[0]);){
            for (C_7778778 keybind : KEYBINDS.values()) {
                String name = keybind.m_4400998();
                int key = keybind.m_6463487();
                bw.write(name + "=" + key);
                bw.newLine();
            }
        }
        catch (IOException e) {
            RedstoneMultimeterMod.LOGGER.warn("exception while saving keybinds", (Throwable)e);
        }
    }

    public static boolean matchesButton(C_7778778 keybind, int button) {
        return button == keybind.m_6463487() + 100;
    }

    public static boolean matchesKey(C_7778778 keybind, int key) {
        return key == keybind.m_6463487();
    }

    public static boolean isPressed(C_7778778 keybind) {
        int key = keybind.m_6463487();
        if (key < 0) {
            return Mouse.isButtonDown((int)(key + 100));
        }
        return Keyboard.isKeyDown((int)key);
    }

    static {
        STEP_BACKWARD = Keybinds.registerKeybind("stepBackwardTimeline", "Step Backward", MAIN, 51);
        STEP_FORWARD = Keybinds.registerKeybind("stepForwardTimeline", "Step Forward", MAIN, 52);
        SCROLL_HUD = Keybinds.registerKeybind("scrollTimeline", "Scroll HUD", MAIN, 56);
        TOGGLE_HUD = Keybinds.registerKeybind("toggleHud", "Toggle HUD", MAIN, 35);
        TOGGLE_MARKER = Keybinds.registerKeybind("toggleTickMarker", "Toggle Tick Marker", MAIN, 21);
        TOGGLE_FOCUS_MODE = Keybinds.registerKeybind("toggleFocusMode", "Toggle Focus Mode", MAIN, 33);
        OPEN_MULTIMETER_SCREEN = Keybinds.registerKeybind("openMultimeterScreen", "Open Multimeter Screen", MAIN, 34);
        OPEN_METER_CONTROLS = Keybinds.registerKeybind("openMeterControlsScreen", "Open Meter Controls", MAIN, 23);
        OPEN_OPTIONS_MENU = Keybinds.registerKeybind("openOptionsScreen", "Open Options Menu", MAIN, 24);
        VIEW_TICK_PHASE_TREE = Keybinds.registerKeybind("openTickPhaseTreeScreen", "View Tick Phases", MAIN, 22);
        PRINT_LOGS = Keybinds.registerKeybind("toggleLogPrinter", "Print Logs To File", MAIN, 25);
        for (int index = 0; index < EventType.ALL.length; ++index) {
            Keybinds.TOGGLE_EVENT_TYPES[index] = Keybinds.registerKeybind("toggleMeterEventType." + EventType.byId(index).getKey(), String.format("Toggle '%s'", EventType.byId(index).getLegacyKey()), METER_EVENT_TYPES, 0);
        }
    }
}

