/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.unmapped.C_2018497;
import net.minecraft.unmapped.C_3225627;
import net.minecraft.unmapped.C_5693434;
import net.minecraft.unmapped.C_7887747;
import redstone.multimeter.RedstoneMultimeterMod;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.SavedMeterGroup;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.meter.ClientMeterGroup;
import redstone.multimeter.client.option.Options;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.common.meter.MeterProperties;
import redstone.multimeter.common.network.packets.SetMetersPacket;

public class SavedMeterGroupsManager {
    private static final String SAVED_METER_GROUPS_FILE_NAME = "saved_meter_groups.nbt";
    private static final int SLOT_COUNT = 9;
    private static final int SLOT_OFFSET = -1;
    private static final int WARNING_TIME = 60;
    private final MultimeterClient client;
    private final SavedMeterGroup[] meterGroups;
    private final Path file;
    private State state = State.IDLE;
    private int lastLoadWarningSlot;
    private int bypassLoadWarningTicks;
    private int lastSaveWarningSlot;
    private int bypassSaveWarningTicks;
    private int previewSlot;

    public SavedMeterGroupsManager(MultimeterClient client) {
        this.client = client;
        this.meterGroups = new SavedMeterGroup[9];
        this.file = this.client.getConfigDirectory().resolve(SAVED_METER_GROUPS_FILE_NAME);
        this.lastLoadWarningSlot = -1;
        this.bypassLoadWarningTicks = -1;
        this.lastSaveWarningSlot = -1;
        this.bypassSaveWarningTicks = -1;
    }

    public void load() {
        try {
            C_2018497 nbt = C_7887747.m_3179139((File)this.file.toFile());
            if (nbt == null) {
                return;
            }
            for (int i = 0; i < this.meterGroups.length; ++i) {
                int slot = i - -1;
                String key = "slot_" + slot;
                if (!nbt.m_6440996(key)) continue;
                C_2018497 meterGroupNbt = nbt.m_6015642(key);
                String name = meterGroupNbt.m_1107321("name");
                C_5693434 metersNbt = meterGroupNbt.m_7623152("meters", 10);
                ArrayList<MeterProperties> meters = new ArrayList<MeterProperties>();
                for (int j = 0; j < metersNbt.m_8051737(); ++j) {
                    meters.add(MeterProperties.fromNbt(metersNbt.m_1469498(j)));
                }
                this.meterGroups[i] = new SavedMeterGroup(name, meters);
            }
        }
        catch (Exception e) {
            RedstoneMultimeterMod.LOGGER.warn("failed to load saved meter groups", (Throwable)e);
        }
    }

    public void save() {
        try {
            C_2018497 nbt = new C_2018497();
            for (int i = 0; i < this.meterGroups.length; ++i) {
                int slot = i - -1;
                String key = "slot_" + slot;
                SavedMeterGroup meterGroup = this.meterGroups[i];
                if (meterGroup == null) continue;
                C_2018497 meterGroupNbt = new C_2018497();
                meterGroupNbt.m_1991972("name", meterGroup.getName());
                C_5693434 metersNbt = new C_5693434();
                meterGroupNbt.m_2972230("meters", (C_3225627)metersNbt);
                for (MeterProperties meter : meterGroup.getMeters()) {
                    metersNbt.m_0728373((C_3225627)meter.toNbt());
                }
                nbt.m_2972230(key, (C_3225627)meterGroupNbt);
            }
            C_7887747.m_7680559((C_2018497)nbt, (File)this.file.toFile());
        }
        catch (Exception e) {
            RedstoneMultimeterMod.LOGGER.warn("failed to save saved meter groups", (Throwable)e);
        }
    }

    public SavedMeterGroup getSavedMeterGroup(int slot) {
        return this.meterGroups[slot + -1];
    }

    public void tick() {
        if (this.bypassLoadWarningTicks >= 0) {
            --this.bypassLoadWarningTicks;
        }
        if (this.bypassSaveWarningTicks >= 0) {
            --this.bypassSaveWarningTicks;
        }
    }

    public void setLoading() {
        if (this.state == State.LOADING) {
            return;
        }
        this.state = State.LOADING;
        this.resetLoadWarning();
        this.stopPreviewing();
        if (((Boolean)Options.RedstoneMultimeter.PREVIEW_METER_GROUPS.get()).booleanValue()) {
            this.client.sendMessage(Texts.translatable("rsmm.meterGroups.preview"), true);
        } else {
            this.client.sendMessage(Texts.translatable("rsmm.meterGroups.load"), true);
        }
    }

    public boolean loadSlot(int slot) {
        SavedMeterGroup meterGroup;
        if (this.state != State.LOADING) {
            return false;
        }
        if (((Boolean)Options.RedstoneMultimeter.PREVIEW_METER_GROUPS.get()).booleanValue()) {
            meterGroup = this.meterGroups[slot + -1];
            if (slot != this.previewSlot) {
                if (meterGroup == null) {
                    return this.previewSlot(slot, null, null);
                }
                String name = meterGroup.getName();
                List<MeterProperties> meters = meterGroup.getMeters();
                return this.previewSlot(slot, name, meters);
            }
            slot = this.previewSlot;
        }
        if ((meterGroup = this.meterGroups[slot + -1]) == null) {
            return this.loadMeterGroup(slot, null, null);
        }
        String name = meterGroup.getName();
        List<MeterProperties> meters = meterGroup.getMeters();
        return this.loadMeterGroup(slot, name, meters);
    }

    private boolean previewSlot(int slot, String name, List<MeterProperties> meters) {
        SavedMeterGroup meterGroup = this.meterGroups[slot + -1];
        if (meterGroup == null) {
            this.client.sendMessage(Texts.translatable("rsmm.meterGroups.preview.failure.emptySlot", slot), true);
        } else {
            this.client.getMeterGroupPreview().preview(slot, name, meters);
            this.client.sendMessage(Texts.translatable("rsmm.meterGroups.preview.success", name, slot), true);
        }
        this.previewSlot = slot;
        return true;
    }

    private boolean loadMeterGroup(int slot, String name, List<MeterProperties> meters) {
        boolean bypassWarnings;
        if (slot != this.lastLoadWarningSlot) {
            this.resetLoadWarning();
        }
        boolean bl = bypassWarnings = this.bypassLoadWarningTicks >= 0 || (Boolean)Options.RedstoneMultimeter.BYPASS_WARNINGS.get() != false;
        if (name == null) {
            if (this.client.hasSubscription()) {
                if (bypassWarnings) {
                    this.client.unsubscribeFromMeterGroup();
                    this.client.sendMessage(Texts.translatable("rsmm.meterGroups.load.success.unsubscribed", slot), true);
                    this.setIdle();
                } else {
                    this.sendLoadWarning(slot, Texts.translatable("rsmm.meterGroups.load.failure.emptySlot", slot));
                }
            }
        } else {
            this.client.subscribeToMeterGroup(slot, name);
            this.client.sendMessage(Texts.translatable("rsmm.meterGroups.load.success.subscribed", name, slot), true);
            SetMetersPacket packet = new SetMetersPacket(meters);
            this.client.sendPacket(packet);
            this.setIdle();
        }
        return true;
    }

    private void resetLoadWarning() {
        this.lastLoadWarningSlot = -1;
        this.bypassLoadWarningTicks = -1;
    }

    private void sendLoadWarning(int slot, Text warning) {
        this.lastLoadWarningSlot = slot;
        this.bypassLoadWarningTicks = 60;
        this.client.sendMessage(warning, true);
    }

    public void setSaving() {
        if (this.state == State.SAVING) {
            return;
        }
        this.state = State.SAVING;
        this.resetSaveWarning();
        this.stopPreviewing();
        if (this.client.hasSubscription()) {
            this.client.sendMessage(Texts.translatable("rsmm.meterGroups.save"), true);
        } else {
            this.client.sendMessage(Texts.translatable("rsmm.meterGroups.clear"), true);
        }
    }

    public boolean saveSlot(int slot) {
        if (this.state != State.SAVING) {
            return false;
        }
        if (!this.client.hasSubscription()) {
            return this.saveMeterGroup(slot, null, null);
        }
        ClientMeterGroup meterGroup = this.client.getMeterGroup();
        String name = meterGroup.getName();
        List<Meter> meters = meterGroup.getMeters();
        return this.saveMeterGroup(slot, name, meters);
    }

    private boolean saveMeterGroup(int slot, String name, List<Meter> meters) {
        boolean bypassWarnings;
        if (slot != this.lastSaveWarningSlot) {
            this.resetSaveWarning();
        }
        boolean bl = bypassWarnings = this.bypassSaveWarningTicks >= 0 || (Boolean)Options.RedstoneMultimeter.BYPASS_WARNINGS.get() != false;
        if (name == null) {
            if (bypassWarnings) {
                this.meterGroups[slot + -1] = null;
                this.client.sendMessage(Texts.translatable("rsmm.meterGroups.clear.success", slot), true);
            } else {
                this.sendSaveWarning(slot, Texts.translatable("rsmm.meterGroups.clear.failure.emptyMeterGroup", slot));
            }
        } else if (meters.isEmpty() && !bypassWarnings) {
            this.sendSaveWarning(slot, Texts.translatable("rsmm.meterGroups.save.failure.emptyMeterGroup", slot));
        } else {
            ArrayList<MeterProperties> savedMeters = new ArrayList<MeterProperties>();
            for (Meter meter : meters) {
                savedMeters.add(meter.getProperties());
            }
            this.meterGroups[slot + -1] = new SavedMeterGroup(name, savedMeters);
            this.client.sendMessage(Texts.translatable("rsmm.meterGroups.save.success", name, slot), true);
        }
        return true;
    }

    private void resetSaveWarning() {
        this.lastSaveWarningSlot = -1;
        this.bypassSaveWarningTicks = -1;
    }

    private void sendSaveWarning(int slot, Text warning) {
        this.lastSaveWarningSlot = slot;
        this.bypassSaveWarningTicks = 60;
        this.client.sendMessage(warning, true);
    }

    public void setIdle() {
        if (this.state == State.IDLE) {
            return;
        }
        this.state = State.IDLE;
        this.resetLoadWarning();
        this.resetSaveWarning();
        this.stopPreviewing();
    }

    private void stopPreviewing() {
        if (this.previewSlot != -1) {
            this.client.getMeterGroupPreview().stopPreviewing();
        }
        this.previewSlot = -1;
    }

    private static enum State {
        IDLE,
        LOADING,
        SAVING;

    }
}

