/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_8105098;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.TextColor;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.gui.tooltip.Tooltip;
import redstone.multimeter.util.ColorUtils;

public class FontRenderer {
    final C_3831727 font;

    public FontRenderer(MultimeterClient client) {
        C_8105098 minecraft = client.getMinecraft();
        this.font = minecraft.f_0426313;
    }

    public int height() {
        return this.font.f_6725889;
    }

    public void draw(String s, int x, int y) {
        this.font.m_4683674(s, x, y, -1);
    }

    public void draw(Text t, int x, int y) {
        this.font.m_4683674(t.buildFormattedString(), x, y, this.resolveColor(t, -1));
    }

    public void draw(String s, int x, int y, int color) {
        this.font.m_4683674(s, x, y, color);
    }

    public void draw(Text t, int x, int y, int color) {
        this.font.m_4683674(t.buildFormattedString(), x, y, this.resolveColor(t, color));
    }

    public void drawWithShadow(String s, int x, int y) {
        this.font.m_1950885(s, x, y, -1);
    }

    public void drawWithShadow(Text t, int x, int y) {
        this.font.m_1950885(t.buildFormattedString(), x, y, this.resolveColor(t, -1));
    }

    public void drawWithShadow(String s, int x, int y, int color) {
        this.font.m_1950885(s, x, y, color);
    }

    public void drawWithShadow(Text t, int x, int y, int color) {
        this.font.m_1950885(t.buildFormattedString(), x, y, this.resolveColor(t, color));
    }

    public void draw(String s, int x, int y, int color, boolean shadow) {
        if (shadow) {
            this.drawWithShadow(s, x, y, color);
        } else {
            this.draw(s, x, y, color);
        }
    }

    public void draw(Text t, int x, int y, int color, boolean shadow) {
        if (shadow) {
            this.drawWithShadow(t, x, y, color);
        } else {
            this.draw(t, x, y, color);
        }
    }

    private int resolveColor(Text t, int color) {
        TextColor textColor = t.getStyle().getColor();
        if (textColor != null) {
            int rgb = textColor.getColor();
            int alpha = ColorUtils.getAlpha(color);
            color = ColorUtils.setAlpha(rgb, alpha);
        }
        return color;
    }

    public String trim(String s, int width) {
        return this.font.m_3198719(s, width);
    }

    public String trim(String s, int width, boolean rightToLeft) {
        return this.font.m_6733238(s, width, rightToLeft);
    }

    public List<String> split(String s, int width) {
        ArrayList<String> lines = new ArrayList<String>();
        while (!s.isEmpty()) {
            int lastSpace = -1;
            int length = 0;
            while (++length < s.length()) {
                String substring;
                int index = length - 1;
                if (s.charAt(index) == ' ') {
                    lastSpace = index;
                }
                if (this.width(substring = s.substring(0, length)) <= width) continue;
                if (lastSpace >= 0) {
                    substring = s.substring(0, lastSpace);
                    length = lastSpace + 1;
                }
                lines.add(substring);
                break;
            }
            if (length == s.length()) {
                if (length <= 0) break;
                lines.add(s);
                break;
            }
            s = s.substring(length);
        }
        return lines;
    }

    public List<Text> split(Text s, int width) {
        return this.split(s.buildFormattedString(), width).stream().map(Texts::resolve).collect(Collectors.toList());
    }

    public int width(String s) {
        return this.font.m_0040387(s);
    }

    public int width(Text t) {
        return this.font.m_0040387(t.buildFormattedString());
    }

    public int width(Tooltip t) {
        int width = 0;
        for (Text line : t) {
            int w = this.width(line);
            if (w <= width) continue;
            width = w;
        }
        return width;
    }

    public int height(Tooltip t) {
        int height = -1;
        for (Text line : t) {
            height += this.height() + 1;
        }
        return height;
    }
}

