/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui;

import java.util.Stack;
import net.minecraft.unmapped.C_0876962;
import net.minecraft.unmapped.C_2454309;
import net.minecraft.unmapped.C_2899740;
import net.minecraft.unmapped.C_5585855;
import net.minecraft.unmapped.C_5786166;
import net.minecraft.unmapped.C_5837633;
import net.minecraft.unmapped.C_6823239;
import net.minecraft.unmapped.C_7799337;
import net.minecraft.unmapped.C_8105098;
import org.lwjgl.opengl.GL11;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.gui.FontRenderer;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.texture.Texture;
import redstone.multimeter.client.gui.texture.TextureRegion;
import redstone.multimeter.client.gui.tooltip.Tooltip;
import redstone.multimeter.util.ColorUtils;

public class GuiRenderer {
    final FontRenderer font;
    private final C_6823239 itemRenderer;
    private final C_0876962 textureManager;
    private final ScissorStack scissorStack = new ScissorStack();

    public GuiRenderer(GuiRenderer delegate) {
        this(delegate.font);
    }

    public GuiRenderer() {
        this(MultimeterClient.INSTANCE.getFontRenderer());
    }

    private GuiRenderer(FontRenderer font) {
        this.font = font;
        this.itemRenderer = new C_6823239();
        this.textureManager = MultimeterClient.MINECRAFT.m_1218956();
        GL11.glEnable((int)3042);
    }

    public void pushMatrix() {
        GL11.glPushMatrix();
    }

    public void translate(double dx, double dy, double dz) {
        GL11.glTranslated((double)dx, (double)dy, (double)dz);
    }

    public void popMatrix() {
        GL11.glPopMatrix();
    }

    public void fill(int x0, int y0, int x1, int y1, int color) {
        GL11.glEnable((int)2929);
        this.innerFill(x0, y0, x1, y1, color);
    }

    public void gradient(int x0, int y0, int x1, int y1, int color0, int color1) {
        GL11.glEnable((int)2929);
        this.innerFill(x0, y0, x1, y1, color0, color1);
    }

    public void highlight(int x0, int y0, int x1, int y1, int color) {
        GL11.glEnable((int)3058);
        GL11.glLogicOp((int)5387);
        GL11.glDisable((int)2929);
        this.innerFill(x0, y0, x1, y1, color);
        GL11.glDisable((int)3058);
    }

    private void innerFill(int x0, int y0, int x1, int y1, int color) {
        this.innerFill(x0, y0, x1, y1, color, color);
    }

    private void innerFill(int x0, int y0, int x1, int y1, int color0, int color1) {
        int a0 = ColorUtils.getAlpha(color0);
        int r0 = ColorUtils.getRed(color0);
        int g0 = ColorUtils.getGreen(color0);
        int b0 = ColorUtils.getBlue(color0);
        int a1 = ColorUtils.getAlpha(color1);
        int r1 = ColorUtils.getRed(color1);
        int g1 = ColorUtils.getGreen(color1);
        int b1 = ColorUtils.getBlue(color1);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        C_5585855.m_8613475((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        C_5786166 builder = C_5786166.f_7436514;
        builder.m_0346438(7);
        builder.m_7869387(r0, g0, b0, a0);
        builder.m_4415074((double)x1, (double)y0, 0.0);
        builder.m_4415074((double)x0, (double)y0, 0.0);
        builder.m_7869387(r1, g1, b1, a1);
        builder.m_4415074((double)x0, (double)y1, 0.0);
        builder.m_4415074((double)x1, (double)y1, 0.0);
        builder.m_7459300();
        GL11.glEnable((int)3553);
    }

    public void borders(int x0, int y0, int x1, int y1, int color) {
        this.borders(x0, y0, x1, y1, 1, color);
    }

    public void borders(int x0, int y0, int x1, int y1, int w, int color) {
        this.fill(x0, y0, x0 + w, y1 - w, color);
        this.fill(x0, y1 - w, x1 - w, y1, color);
        this.fill(x1 - w, y0 + w, x1, y1, color);
        this.fill(x0 + w, y0, x1, y0 + w, color);
    }

    public void tooltip(Tooltip tooltip, int mouseX, int mouseY) {
        C_8105098 minecraft = MultimeterClient.MINECRAFT;
        C_7799337 window = new C_7799337(minecraft.f_9967940, minecraft.f_0545414, minecraft.f_5990000);
        int width = this.font.width(tooltip) + 8;
        int height = this.font.height(tooltip) + 8;
        int x = mouseX + 15;
        int y = mouseY;
        if (x + width > window.m_1713651()) {
            x = mouseX - 15 - width;
        }
        if (y + height > window.m_5421693()) {
            y = mouseY - height;
        }
        this.tooltip(tooltip, x, y, x + width, y + height);
    }

    public void tooltip(Tooltip tooltip, int x0, int y0, int x1, int y1) {
        this.tooltip(tooltip, x0, y0, x1, y1, -267386864, 0x505000FF, 1344798847);
    }

    public void tooltip(Tooltip tooltip, int x0, int y0, int x1, int y1, int backgroundColor, int borderColor0, int borderColor1) {
        this.pushMatrix();
        this.translate(0.0, 0.0, 400.0);
        this.fill(x0, y0 + 1, x1, y1 - 1, backgroundColor);
        this.fill(x0 + 1, y0, x1 - 1, y0 + 1, backgroundColor);
        this.fill(x0 + 1, y1 - 1, x1 - 1, y1, backgroundColor);
        this.gradient(x0 + 1, y0 + 2, x0 + 2, y1 - 2, borderColor0, borderColor1);
        this.fill(x0 + 1, y1 - 2, x1 - 1, y1 - 1, borderColor1);
        this.gradient(x1 - 2, y0 + 2, x1 - 1, y1 - 2, borderColor0, borderColor1);
        this.fill(x0 + 1, y0 + 1, x1 - 1, y0 + 2, borderColor0);
        int textX = x0 + 4;
        int textY = y0 + 4;
        for (Text line : tooltip) {
            this.drawStringWithShadow(line, textX, textY);
            textY += this.font.height() + 1;
        }
        this.popMatrix();
    }

    public void blit(Texture t, int x0, int y0, int x1, int y1) {
        this.blit(t, x0, y0, x1, y1, 0, 0, t.width, t.height);
    }

    public void blit(Texture t, int x0, int y0, int x1, int y1, int color) {
        this.blit(t, x0, y0, x1, y1, 0, 0, t.width, t.height, color);
    }

    public void blit(Texture t, int x0, int y0, int x1, int y1, int u0, int v0, int u1, int v1) {
        this.blit(t, x0, y0, x1, y1, u0, v0, u1, v1, -1);
    }

    public void blit(Texture t, int x0, int y0, int x1, int y1, int u0, int v0, int u1, int v1, int color) {
        this.innerBlit(t, x0, x1, y0, y1, (float)u0 / (float)t.width, (float)u1 / (float)t.width, (float)v0 / (float)t.height, (float)v1 / (float)t.height, color);
    }

    public void blit(TextureRegion t, int x0, int y0, int x1, int y1) {
        this.blit(t.texture, x0, y0, x1, y1, t.x, t.y, t.x + t.width, t.y + t.height);
    }

    public void blit(TextureRegion t, int x0, int y0, int x1, int y1, int color) {
        this.blit(t.texture, x0, y0, x1, y1, t.x, t.y, t.x + t.width, t.y + t.height, color);
    }

    public void blitSpliced(Texture t, int x0, int y0, int x1, int y1, int edge) {
        this.blitSpliced(t, x0, y0, x1, y1, 0, 0, t.width, t.height, edge);
    }

    public void blitSpliced(Texture t, int x0, int y0, int x1, int y1, int edge, int color) {
        this.blitSpliced(t, x0, y0, x1, y1, 0, 0, t.width, t.height, edge, color);
    }

    public void blitSpliced(Texture t, int x0, int y0, int x1, int y1, int u0, int v0, int u1, int v1, int edge) {
        this.blitSpliced(t, x0, y0, x1, y1, u0, v0, u1, v1, edge, -1);
    }

    public void blitSpliced(Texture t, int x0, int y0, int x1, int y1, int u0, int v0, int u1, int v1, int edge, int color) {
        boolean mh;
        boolean mw = x1 - x0 == u1 - u0;
        boolean bl = mh = y1 - y0 == v1 - v0;
        if (mw && mh) {
            this.blitTiled(t, x0, y0, x1, y1, u0, v0, u1, v1, color);
        } else if (mw) {
            this.blitTiled(t, x0, y0, x1, y0 + edge, u0, v0, u1, v0 + edge, color);
            this.blitTiled(t, x0, y0 + edge, x1, y1 - edge, u0, v0 + edge, u1, v1 - edge, color);
            this.blitTiled(t, x0, y1 - edge, x1, y1, u0, v1 - edge, u1, v1, color);
        } else if (mh) {
            this.blitTiled(t, x0, y0, x0 + edge, y1, u0, v0, u0 + edge, v1, color);
            this.blitTiled(t, x0 + edge, y0, x1 - edge, y1, u0 + edge, v0, u1 - edge, v1, color);
            this.blitTiled(t, x1 - edge, y0, x1, y1, u1 - edge, v0, u1, v1, color);
        } else {
            this.blitTiled(t, x0, y0, x0 + edge, y0 + edge, u0, v0, u0 + edge, v0 + edge, color);
            this.blitTiled(t, x0 + edge, y0, x1 - edge, y0 + edge, u0 + edge, v0, u1 - edge, v0 + edge, color);
            this.blitTiled(t, x1 - edge, y0, x1, y0 + edge, u1 - edge, v0, u1, v0 + edge, color);
            this.blitTiled(t, x0, y0 + edge, x0 + edge, y1 - edge, u0, v0 + edge, u0 + edge, v1 - edge, color);
            this.blitTiled(t, x0 + edge, y0 + edge, x1 - edge, y1 - edge, u0 + edge, v0 + edge, u1 - edge, v1 - edge, color);
            this.blitTiled(t, x1 - edge, y0 + edge, x1, y1 - edge, u1 - edge, v0 + edge, u1, v1 - edge, color);
            this.blitTiled(t, x0, y1 - edge, x0 + edge, y1, u0, v1 - edge, u0 + edge, v1, color);
            this.blitTiled(t, x0 + edge, y1 - edge, x1 - edge, y1, u0 + edge, v1 - edge, u1 - edge, v1, color);
            this.blitTiled(t, x1 - edge, y1 - edge, x1, y1, u1 - edge, v1 - edge, u1, v1, color);
        }
    }

    public void blitSpliced(TextureRegion t, int x0, int y0, int x1, int y1, int edge) {
        this.blitSpliced(t.texture, x0, y0, x1, y1, t.x, t.y, t.x + t.width, t.y + t.height, edge);
    }

    public void blitSpliced(TextureRegion t, int x0, int y0, int x1, int y1, int edge, int color) {
        this.blitSpliced(t.texture, x0, y0, x1, y1, t.x, t.y, t.x + t.width, t.y + t.height, edge, color);
    }

    public void blitTiled(Texture t, int x0, int y0, int x1, int y1) {
        this.blitTiled(t, x0, y0, x1, y1, 0, 0, t.width, t.height);
    }

    public void blitTiled(Texture t, int x0, int y0, int x1, int y1, int color) {
        this.blitTiled(t, x0, y0, x1, y1, 0, 0, t.width, t.height, color);
    }

    public void blitTiled(Texture t, int x0, int y0, int x1, int y1, int u0, int v0, int u1, int v1) {
        this.blitTiled(t, x0, y0, x1, y1, u0, v0, u1, v1, -1);
    }

    public void blitTiled(Texture t, int x0, int y0, int x1, int y1, int u0, int v0, int u1, int v1, int color) {
        int xs = x0;
        int ys = y0;
        int xf = x1;
        int yf = y1;
        x0 = xs;
        while (x0 < xf) {
            x1 = Math.min(x0 + (u1 - u0), xf);
            u1 = Math.min(u1, u0 + (x1 - x0));
            y0 = ys;
            while (y0 < yf) {
                y1 = Math.min(y0 + (v1 - v0), yf);
                v1 = Math.min(v1, v0 + (y1 - y0));
                this.blit(t, x0, y0, x1, y1, u0, v0, u1, v1, color);
                y0 = y1;
            }
            x0 = x1;
        }
    }

    public void blitTiled(TextureRegion t, int x0, int y0, int x1, int y1) {
        this.blitTiled(t.texture, x0, y0, x1, y1, t.x, t.y, t.x + t.width, t.y + t.height);
    }

    public void blitTiled(TextureRegion t, int x0, int y0, int x1, int y1, int color) {
        this.blitTiled(t.texture, x0, y0, x1, y1, t.x, t.y, t.x + t.width, t.y + t.height, color);
    }

    private void innerBlit(Texture t, int x0, int x1, int y0, int y1, float u0, float u1, float v0, float v1, int color) {
        MultimeterClient.MINECRAFT.m_1218956().m_5325521(t.location);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        int r = ColorUtils.getRed(color);
        int g = ColorUtils.getGreen(color);
        int b = ColorUtils.getBlue(color);
        int a = ColorUtils.getAlpha(color);
        C_5786166 builder = C_5786166.f_7436514;
        builder.m_0346438(7);
        builder.m_7869387(r, g, b, a);
        builder.m_1165938((double)x0, (double)y1, 0.0, (double)u0, (double)v1);
        builder.m_1165938((double)x1, (double)y1, 0.0, (double)u1, (double)v1);
        builder.m_1165938((double)x1, (double)y0, 0.0, (double)u1, (double)v0);
        builder.m_1165938((double)x0, (double)y0, 0.0, (double)u0, (double)v0);
        builder.m_7459300();
    }

    public void pushScissor(int x0, int y0, int x1, int y1) {
        this.applyScissor(this.scissorStack.push(new ScissorBox(x0, y0, x1 - x0, y1 - y0)));
    }

    public void popScissor() {
        this.applyScissor(this.scissorStack.pop());
    }

    private void applyScissor(ScissorBox box) {
        if (box == null) {
            GL11.glDisable((int)3089);
        } else {
            C_8105098 minecraft = MultimeterClient.MINECRAFT;
            C_5837633 target = minecraft.m_4441537();
            C_7799337 window = new C_7799337(minecraft.f_9967940, minecraft.f_0545414, minecraft.f_5990000);
            int windowHeight = target.f_9708480;
            double windowScale = window.m_8052133();
            int x = (int)((double)box.x * windowScale);
            int y = (int)((double)windowHeight - (double)(box.y + box.height) * windowScale);
            int width = (int)((double)box.width * windowScale);
            int height = (int)((double)box.height * windowScale);
            GL11.glEnable((int)3089);
            GL11.glScissor((int)x, (int)y, (int)Math.max(0, width), (int)Math.max(0, height));
        }
    }

    public void renderItem(C_2454309 item, int x, int y) {
        C_2899740.m_1560027();
        GL11.glEnable((int)3553);
        this.itemRenderer.m_5840420(this.font.font, this.textureManager, item, x, y);
    }

    public void drawString(String s, int x, int y) {
        this.font.draw(s, x, y);
    }

    public void drawString(Text t, int x, int y) {
        this.font.draw(t, x, y);
    }

    public void drawString(String s, int x, int y, int color) {
        this.font.draw(s, x, y, color);
    }

    public void drawString(Text t, int x, int y, int color) {
        this.font.draw(t, x, y, color);
    }

    public void drawStringWithShadow(String s, int x, int y) {
        this.font.drawWithShadow(s, x, y);
    }

    public void drawStringWithShadow(Text t, int x, int y) {
        this.font.drawWithShadow(t, x, y);
    }

    public void drawStringWithShadow(String s, int x, int y, int color) {
        this.font.drawWithShadow(s, x, y, color);
    }

    public void drawStringWithShadow(Text t, int x, int y, int color) {
        this.font.drawWithShadow(t, x, y, color);
    }

    public void drawString(String s, int x, int y, int color, boolean shadow) {
        this.font.draw(s, x, y, color, shadow);
    }

    public void drawString(Text t, int x, int y, int color, boolean shadow) {
        this.font.draw(t, x, y, color, shadow);
    }

    public int width(String s) {
        return this.font.width(s);
    }

    public int width(Text t) {
        return this.font.width(t);
    }

    public int height() {
        return this.font.height();
    }

    private static class ScissorStack {
        private final Stack<ScissorBox> boxes = new Stack();

        private ScissorStack() {
        }

        public ScissorBox push(ScissorBox box) {
            if (!this.boxes.isEmpty()) {
                box = this.boxes.peek().intersection(box);
            }
            return this.boxes.push(box);
        }

        public ScissorBox pop() {
            if (this.boxes.isEmpty()) {
                throw new IllegalStateException("popping empty scissor stack");
            }
            this.boxes.pop();
            return this.boxes.isEmpty() ? null : this.boxes.peek();
        }
    }

    private static class ScissorBox {
        private static final ScissorBox EMPTY = new ScissorBox(0, 0, 0, 0);
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        public ScissorBox(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public ScissorBox intersection(ScissorBox o) {
            int x0 = Math.max(this.x, o.x);
            int y0 = Math.max(this.y, o.y);
            int x1 = Math.min(this.x + this.width, o.x + o.width);
            int y1 = Math.min(this.y + this.height, o.y + o.height);
            return x0 == x1 || y0 == y1 ? EMPTY : new ScissorBox(x0, y0, x1 - x0, y1 - y0);
        }
    }
}

