/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.element;

import java.util.Collection;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_1241852;
import net.minecraft.unmapped.C_2454309;
import net.minecraft.unmapped.C_3755722;
import redstone.multimeter.client.gui.GuiRenderer;
import redstone.multimeter.client.gui.element.AbstractElement;
import redstone.multimeter.client.gui.element.Element;
import redstone.multimeter.client.gui.element.SelectorList;
import redstone.multimeter.client.gui.tooltip.Tooltip;
import redstone.multimeter.client.gui.tooltip.Tooltips;

public class BlockSelectorList
extends SelectorList {
    private static final Random RANDOM = new Random();
    private final Consumer<C_0561170> selectionListener;

    public BlockSelectorList(int width, int height, Consumer<C_0561170> selectionListener) {
        this(width, height, 0, 0, selectionListener);
    }

    public BlockSelectorList(int width, int height, int topBorder, int bottomBorder, Consumer<C_0561170> selectionListener) {
        super(width, height, topBorder, bottomBorder);
        this.selectionListener = selectionListener;
        this.setSorter((o1, o2) -> {
            if (o1 instanceof BlockListEntry && o2 instanceof BlockListEntry) {
                BlockListEntry e1 = (BlockListEntry)o1;
                BlockListEntry e2 = (BlockListEntry)o2;
                return COLLATOR.compare(e1.key.toString(), e2.key.toString());
            }
            return 0;
        });
    }

    @Override
    protected void selectionChanged(Element element) {
        super.selectionChanged(element);
        if (element instanceof BlockListEntry) {
            BlockListEntry entry = (BlockListEntry)element;
            this.selectionListener.accept(entry.key);
        }
    }

    public void add(C_0561170 key) {
        this.addChild(new BlockListEntry(this.getEffectiveWidth(), 20, key));
    }

    public void add(Collection<C_0561170> keys) {
        for (C_0561170 key : keys) {
            this.add(key);
        }
    }

    public void setBlockFilter(Predicate<C_0561170> filter) {
        this.setFilter(e -> {
            if (e instanceof BlockListEntry) {
                BlockListEntry entry = (BlockListEntry)e;
                return filter.test(entry.key);
            }
            return false;
        });
    }

    private class BlockListEntry
    extends AbstractElement {
        private final C_0561170 key;
        private final C_2454309 icon;

        protected BlockListEntry(int width, int height, C_0561170 key) {
            super(0, 0, width, height);
            C_1241852 block = (C_1241852)C_1241852.f_7235510.m_1782140(key.toString());
            C_3755722 item = null;
            if (block != null) {
                item = C_3755722.m_0135857((C_1241852)block);
                if (item == null) {
                    item = (C_3755722)C_3755722.f_8921864.m_1782140(key.toString());
                }
                if (item == null) {
                    item = block.m_7534654(0, RANDOM, 0);
                }
            }
            this.key = key;
            this.icon = item == null ? null : new C_2454309(item);
        }

        @Override
        public void render(GuiRenderer renderer, int mouseX, int mouseY) {
            int height = this.getHeight();
            int x = this.getX() + 2;
            int y = this.getY() + (height - 16) / 2;
            if (this.icon != null) {
                renderer.renderItem(this.icon, x, y);
            }
            x = this.getX() + 22;
            y = this.getY() + height - (height + BlockSelectorList.this.font.height()) / 2;
            String text = BlockSelectorList.this.font.trim(this.key.toString(), this.getWidth() - 22);
            renderer.drawStringWithShadow(text, x, y);
        }

        @Override
        public void mouseMove(double mouseX, double mouseY) {
        }

        @Override
        public boolean mouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return false;
        }

        @Override
        public boolean mouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
            return false;
        }

        @Override
        public boolean keyPress(int keyCode) {
            return false;
        }

        @Override
        public boolean keyRelease(int keyCode) {
            return false;
        }

        @Override
        public boolean typeChar(char chr) {
            return false;
        }

        @Override
        public void onRemoved() {
        }

        @Override
        public void tick() {
        }

        @Override
        public Tooltip getTooltip(int mouseX, int mouseY) {
            String keyString;
            Tooltip tooltip = super.getTooltip(mouseX, mouseY);
            if (tooltip.isEmpty() && BlockSelectorList.this.font.width(keyString = this.key.toString()) > this.getWidth() - 22) {
                tooltip = Tooltips.split(BlockSelectorList.this.font, keyString);
            }
            return tooltip;
        }

        @Override
        public void update() {
        }
    }
}

