/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.element;

import java.util.List;
import net.minecraft.unmapped.C_3020744;
import redstone.multimeter.client.gui.GuiRenderer;
import redstone.multimeter.client.gui.element.Element;
import redstone.multimeter.client.gui.element.ScrollableList;
import redstone.multimeter.client.gui.element.button.Button;

public class SelectorList
extends ScrollableList {
    private Element selection;

    protected SelectorList(int width, int height) {
        this(width, height, 0, 0);
    }

    protected SelectorList(int width, int height, int topBorder, int bottomBorder) {
        super(width, height, topBorder, bottomBorder);
    }

    @Override
    protected void renderElement(GuiRenderer renderer, Element element, int mouseX, int mouseY) {
        boolean drawBackground;
        boolean selected = element == this.getSelectedElement();
        boolean hovered = element == this.getHoveredElement();
        boolean bl = drawBackground = selected || hovered;
        if (drawBackground) {
            this.drawBackground(renderer, element, selected);
        }
        super.renderElement(renderer, element, mouseX, mouseY);
        if (drawBackground) {
            this.drawBorder(renderer, element, selected);
        }
    }

    @Override
    public boolean mouseClick(double mouseX, double mouseY, int button) {
        boolean consumed = super.mouseClick(mouseX, mouseY, button);
        if (button == 0) {
            consumed |= this.setSelection(this.getFocusedElement(), true);
        }
        return consumed;
    }

    @Override
    public boolean keyPress(int keyCode) {
        boolean consumed = super.keyPress(keyCode);
        if (!consumed) {
            switch (keyCode) {
                case 15: {
                    return this.moveSelection(!C_3020744.m_5142737(), false);
                }
                case 200: {
                    return this.moveSelection(false, false);
                }
                case 208: {
                    return this.moveSelection(true, false);
                }
                case 201: {
                    return this.moveSelection(false, true);
                }
                case 209: {
                    return this.moveSelection(true, true);
                }
            }
        }
        return consumed;
    }

    @Override
    public void clear() {
        super.clear();
        this.selection = null;
    }

    private boolean setSelection(Element element, boolean playClick) {
        if (element == null || element == this.selection) {
            return false;
        }
        this.selection = element;
        this.selectionChanged(element);
        if (playClick) {
            Button.playClickSound();
        }
        return true;
    }

    private boolean moveSelection(boolean forward, boolean skipAll) {
        List<Element> children = this.getChildren();
        if (children.isEmpty()) {
            return false;
        }
        if (skipAll || this.selection == null) {
            return this.setSelection(children.get(forward ^ skipAll ? 0 : children.size() - 1), false);
        }
        int index = children.indexOf(this.selection);
        if (index < 0) {
            return false;
        }
        if ((index += forward ? 1 : -1) >= 0 && index < children.size()) {
            return this.setSelection(children.get(index), false);
        }
        return false;
    }

    protected Element getSelectedElement() {
        return this.selection;
    }

    protected void selectionChanged(Element element) {
        double dy = this.getAmountOffScreen(element);
        if (dy != 0.0) {
            this.scroll(dy);
        }
    }

    protected void drawBackground(GuiRenderer renderer, Element element, boolean selected) {
        renderer.fill(element.getX(), element.getY(), element.getX() + element.getWidth(), element.getY() + element.getHeight(), this.getBackgroundColor(selected));
    }

    protected void drawBorder(GuiRenderer renderer, Element element, boolean selected) {
        renderer.borders(element.getX(), element.getY(), element.getX() + element.getWidth(), element.getY() + element.getHeight(), this.getBorderColor(selected));
    }

    protected int getBackgroundColor(boolean selected) {
        return selected ? Integer.MIN_VALUE : 0x20000000;
    }

    protected int getBorderColor(boolean selected) {
        return selected ? -1 : 0x40FFFFFF;
    }
}

