/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.element.button;

import java.util.Collections;
import java.util.List;
import net.minecraft.unmapped.C_4976084;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.gui.FontRenderer;
import redstone.multimeter.client.gui.GuiRenderer;
import redstone.multimeter.client.gui.element.AbstractElement;
import redstone.multimeter.client.gui.element.button.SuggestionsProvider;
import redstone.multimeter.client.gui.element.button.TextField;

public class SuggestionsMenu
extends AbstractElement {
    private static final int THRESHOLD_MENU_SIZE = 1;
    private static final int MIN_MENU_SIZE = 1;
    private static final int MAX_MENU_SIZE = 10;
    private static final int ENTRY_SPACING = 2;
    private static final int BORDER_SPACING = 2;
    private final FontRenderer font = MultimeterClient.INSTANCE.getFontRenderer();
    private final TextField input;
    private final SuggestionsProvider provider;
    private int threshold;
    private int minSize;
    private int maxSize;
    private List<String> suggestions;
    private int selected;
    private int hovered;
    private int scroll;
    private int size;

    public SuggestionsMenu(TextField input, SuggestionsProvider provider) {
        super(0, 0, 0, 0);
        this.input = input;
        this.provider = provider;
        this.threshold = 1;
        this.minSize = 1;
        this.maxSize = 10;
        this.suggestions = Collections.emptyList();
        this.selected = -1;
        this.hovered = -1;
        this.scroll = 0;
        this.size = 0;
        this.updatePosition();
        this.updateSize();
    }

    public void setThreshold(int size) {
        this.threshold = size;
    }

    public void setMinSize(int size) {
        this.minSize = size;
    }

    public void setMaxSize(int size) {
        this.maxSize = size;
    }

    public int getMaxHeight() {
        return this.maxSize * (this.font.height() + 2);
    }

    @Override
    public void render(GuiRenderer renderer, int mouseX, int mouseY) {
        if (this.isShowingSuggestions()) {
            renderer.pushMatrix();
            renderer.translate(0.0, 0.0, 10.0);
            this.renderBackground(renderer);
            this.renderHighlights(renderer);
            int x = this.getX() + 2;
            int y = this.getY() + 2;
            int height = this.font.height() + 2;
            for (int i = 0; i < this.size && this.scroll + i < this.suggestions.size(); ++i) {
                renderer.drawString(this.suggestions.get(this.scroll + i), x, y);
                y += height;
            }
            renderer.popMatrix();
        }
    }

    public boolean isShowingSuggestions() {
        return this.isEnabled() && this.hasEnoughSuggestions();
    }

    public boolean isEnabled() {
        return this.input.isFocused() && this.input.isActive();
    }

    private boolean hasEnoughSuggestions() {
        return this.suggestions.size() >= this.threshold;
    }

    private void renderBackground(GuiRenderer renderer) {
        int x0 = this.getX();
        int y0 = this.getY();
        int x1 = x0 + this.getWidth();
        int y1 = y0 + this.getHeight();
        int backgroundColor = this.getBackgroundColor();
        renderer.fill(x0, y0, x1, y1, backgroundColor);
    }

    private void renderHighlights(GuiRenderer renderer) {
        int y1;
        int y0;
        int x0 = this.getX();
        int x1 = x0 + this.getWidth();
        int height = this.font.height() + 2;
        if (this.hovered >= 0) {
            y0 = this.getY() + (this.hovered - this.scroll) * height;
            y1 = y0 + height;
            int hoveredColor = this.getHoveredColor();
            renderer.fill(x0, y0, x1, y1, hoveredColor);
        }
        if (this.selected >= 0) {
            y0 = this.getY() + (this.selected - this.scroll) * height;
            y1 = y0 + height;
            int selectedColor = this.getSelectedColor();
            renderer.fill(x0, y0, x1, y1, selectedColor);
        }
    }

    private int getBackgroundColor() {
        return -16777216;
    }

    private int getHoveredColor() {
        return -13619152;
    }

    private int getSelectedColor() {
        return -10461088;
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.input.isMouseOver(mouseX, mouseY) || super.isMouseOver(mouseX, mouseY);
    }

    @Override
    public void mouseMove(double mouseX, double mouseY) {
        this.hovered = -1;
        if (this.input.isMouseOver(mouseX, mouseY)) {
            this.input.setHoveredAndUpdateCursor(this.isHovered());
        } else {
            int idx;
            this.input.setHoveredAndUpdateCursor(false);
            if (this.isShowingSuggestions() && this.isHovered() && (idx = this.scroll + (int)((mouseY - (double)this.getY()) / (double)(this.font.height() + 2))) >= 0 && idx < this.suggestions.size()) {
                this.hovered = idx;
            }
        }
    }

    @Override
    public boolean mouseClick(double mouseX, double mouseY, int button) {
        if (this.input.isMouseOver(mouseX, mouseY)) {
            return this.input.mouseClick(mouseX, mouseY, button);
        }
        boolean consumed = super.mouseClick(mouseX, mouseY, button);
        if (!consumed && button == 0) {
            int idx;
            if (this.isShowingSuggestions() && (idx = this.hovered) >= 0) {
                this.setSelection(idx);
                this.useSelection();
            }
            consumed = true;
        }
        return consumed;
    }

    @Override
    public boolean mouseRelease(double mouseX, double mouseY, int button) {
        boolean consumed = super.mouseClick(mouseX, mouseY, button);
        return this.input.mouseRelease(mouseX, mouseY, button) || consumed;
    }

    @Override
    public boolean mouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.input.isMouseOver(mouseX, mouseY) && this.input.mouseDrag(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean mouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.input.isMouseOver(mouseX, mouseY)) {
            return this.input.mouseScroll(mouseX, mouseY, scrollX, scrollY);
        }
        if (this.isShowingSuggestions()) {
            this.moveSelection(-((int)scrollY));
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPress(int keyCode) {
        if (keyCode == 1 || keyCode == 28) {
            this.setFocused(false);
        }
        boolean consumed = false;
        if (keyCode == 1) {
            this.setFocused(false);
            consumed = true;
        }
        if (this.hasSuggestions()) {
            consumed = true;
            switch (keyCode) {
                case 200: {
                    this.moveSelection(-1);
                    break;
                }
                case 201: {
                    this.setSelection(0);
                    break;
                }
                case 208: {
                    this.moveSelection(1);
                    break;
                }
                case 209: {
                    this.setSelection(this.suggestions.size() - 1);
                    break;
                }
                case 15: 
                case 28: {
                    this.useSelection();
                    if (keyCode != 28) break;
                    this.setFocused(false);
                    break;
                }
                default: {
                    consumed = false;
                }
            }
        }
        return consumed || this.input.keyPress(keyCode);
    }

    @Override
    public boolean keyRelease(int keyCode) {
        return this.input.keyRelease(keyCode);
    }

    @Override
    public boolean typeChar(char chr) {
        return this.input.typeChar(chr);
    }

    @Override
    public void setFocused(boolean focused) {
        super.setFocused(focused);
        this.input.setFocused(focused);
    }

    @Override
    public void tick() {
    }

    @Override
    public int getHeight() {
        return this.getY() < this.input.getY() ? this.getMaxHeight() : super.getHeight();
    }

    @Override
    public void update() {
        this.suggestions = this.isEnabled() ? this.provider.provide(this.input.getValueBeforeCursor()) : Collections.emptyList();
        this.updateSize();
        this.setSelection(0);
    }

    public void updatePosition() {
        this.setX(this.input.getX() + 2);
        if (this.fitsBelowInput() || !this.fitsAboveInput()) {
            this.setY(this.input.getY() + this.input.getHeight() - 1);
        } else {
            this.setY(this.input.getY() + 1 - this.getMaxHeight());
        }
    }

    private boolean fitsAboveInput() {
        return this.input.getY() + 1 - this.getMaxHeight() >= 0;
    }

    private boolean fitsBelowInput() {
        return this.input.getY() + this.input.getHeight() - 1 + this.getMaxHeight() <= MultimeterClient.MINECRAFT.f_0723335.f_3080061;
    }

    public void updateSize() {
        if (this.hasEnoughSuggestions()) {
            this.size = C_4976084.m_1109374((int)this.suggestions.size(), (int)this.minSize, (int)this.maxSize);
            int width = 4;
            int height = this.size * (this.font.height() + 2);
            for (int i = 0; i < this.size && this.scroll + i < this.suggestions.size(); ++i) {
                String suggestion = this.suggestions.get(this.scroll + i);
                int suggestionWidth = this.font.width(suggestion);
                if (suggestionWidth <= width) continue;
                width = suggestionWidth;
            }
            this.setWidth(width + 4);
            this.setHeight(height);
        } else {
            this.size = 0;
            this.setWidth(0);
            this.setHeight(0);
        }
    }

    public boolean hasSuggestions() {
        return !this.suggestions.isEmpty();
    }

    public boolean hasSelection() {
        return this.hasSuggestions() && this.selected >= 0;
    }

    public String getSelection() {
        return this.hasSelection() ? this.suggestions.get(this.selected) : null;
    }

    public void moveSelection(int amount) {
        int newSelection = this.selected + amount;
        if (newSelection < 0) {
            newSelection = this.suggestions.size() - 1;
        }
        if (newSelection >= this.suggestions.size()) {
            newSelection = 0;
        }
        this.setSelection(newSelection);
    }

    public void setSelection(int index) {
        this.selected = C_4976084.m_1109374((int)index, (int)0, (int)(this.suggestions.size() - 1));
        this.updateScroll();
        this.input.updateSuggestion();
    }

    public void useSelection() {
        if (this.hasSelection()) {
            this.input.setValue(this.getSelection());
        }
    }

    private void updateScroll() {
        if (this.selected >= this.scroll + this.size) {
            this.scroll(this.selected - (this.scroll + this.size) + 1);
        }
        if (this.selected < this.scroll) {
            this.scroll(this.selected - this.scroll);
        }
    }

    private void scroll(int amount) {
        this.setScroll(this.scroll + amount);
    }

    private void setScroll(int value) {
        int oldScroll = this.scroll;
        this.scroll = C_4976084.m_1109374((int)value, (int)0, (int)(this.suggestions.size() - this.size));
        if (this.scroll != oldScroll) {
            this.updateSize();
        }
    }
}

