/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.element.meter;

import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_7778778;
import redstone.multimeter.client.Keybinds;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.gui.element.AbstractParentElement;
import redstone.multimeter.client.gui.element.Label;
import redstone.multimeter.client.gui.element.SimpleList;
import redstone.multimeter.client.gui.element.button.BasicButton;
import redstone.multimeter.client.gui.element.button.Button;
import redstone.multimeter.client.gui.element.button.Slider;
import redstone.multimeter.client.gui.element.button.SuggestionsProvider;
import redstone.multimeter.client.gui.element.button.TextField;
import redstone.multimeter.client.gui.element.button.ToggleButton;
import redstone.multimeter.client.gui.element.meter.MeterPropertyElement;
import redstone.multimeter.client.gui.text.Formatting;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.gui.tooltip.Tooltip;
import redstone.multimeter.client.gui.tooltip.Tooltips;
import redstone.multimeter.common.DimPos;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.common.meter.MeterProperties;
import redstone.multimeter.common.meter.event.EventType;
import redstone.multimeter.common.network.packets.MeterUpdatePacket;
import redstone.multimeter.common.network.packets.RemoveMeterPacket;
import redstone.multimeter.common.network.packets.TeleportToMeterPacket;
import redstone.multimeter.util.ColorUtils;
import redstone.multimeter.util.Dimensions;
import redstone.multimeter.util.Direction;

public class MeterControlsElement
extends AbstractParentElement {
    private final MultimeterClient client = MultimeterClient.INSTANCE;
    private final Label deleteConfirm;
    private final SimpleList controls;
    private int height;
    private Meter meter;
    private Label title = new Label(0, 0, t -> {
        if (this.meter != null) {
            t.addLine(Texts.translatable("rsmm.gui.meterControls.edit", this.meter.getName()).format(Formatting.UNDERLINED)).setShadow(true);
        }
    });
    private Button hideButton = new BasicButton(0, 0, 18, 18, () -> Texts.literal(this.meter != null && this.meter.isHidden() ? "\u25a0" : "\u25a1"), () -> Tooltips.line("%s Meter", this.meter == null || this.meter.isHidden() ? "Unhide" : "Hide"), button -> {
        this.client.getMeterGroup().toggleHidden(this.meter);
        return true;
    });
    private Button deleteButton = new BasicButton(0, 0, 18, 18, () -> Texts.literal("X").format(this.triedDeleting ? Formatting.RED : Formatting.WHITE), () -> Tooltips.keybind(Texts.translatable("rsmm.gui.meterControls.delete"), Keybinds.TOGGLE_METER), button -> {
        this.tryDelete();
        if (this.triedDeleting && C_3020744.m_5142737()) {
            this.tryDelete();
        }
        return true;
    });
    private boolean triedDeleting;

    public MeterControlsElement(int x, int y, int width) {
        super(x, y, width, 0);
        this.deleteConfirm = new Label(0, 0, t -> t.addLine(Texts.translatable("rsmm.gui.meterControls.delete.warning").format(Formatting.ITALIC)).setShadow(true));
        this.deleteConfirm.setVisible(false);
        this.controls = new SimpleList(this.getWidth());
        this.addChild(this.title);
        this.addChild(this.hideButton);
        this.addChild(this.deleteButton);
        this.addChild(this.deleteConfirm);
        this.addChild(this.controls);
    }

    @Override
    public boolean mouseClick(double mouseX, double mouseY, int button) {
        boolean consumed = super.mouseClick(mouseX, mouseY, button);
        if (this.triedDeleting && this.getFocusedElement() != this.deleteButton) {
            this.undoTryDelete();
            consumed = true;
        }
        return consumed;
    }

    @Override
    public boolean keyPress(int keyCode) {
        boolean consumed = super.keyPress(keyCode);
        if (this.triedDeleting && keyCode == 1) {
            this.undoTryDelete();
            consumed = true;
        }
        return consumed;
    }

    @Override
    public void setX(int x) {
        super.setX(x);
        this.updateCoords();
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        this.updateCoords();
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.meter != null;
    }

    @Override
    public void update() {
        Meter prevMeter = this.meter;
        this.meter = this.client.getHud().getSelectedMeter();
        if (this.meter != prevMeter) {
            this.createControls();
        }
        super.update();
        this.updateCoords();
    }

    private void createControls() {
        this.controls.clear();
        if (this.meter == null) {
            return;
        }
        int totalWidth = 375;
        int buttonWidth = 150;
        MeterPropertyElement pos = new MeterPropertyElement(totalWidth, buttonWidth, "pos", () -> Tooltips.line("Click to teleport!"), t -> {
            this.teleport();
            return true;
        });
        pos.addControl("dimension", new TextField(0, 0, 0, 0, Tooltips::empty, dimension -> this.changePos(this.meter.getPos().offset((String)dimension)), () -> this.meter.getPos().getDimension().toString()), SuggestionsProvider.matching(Dimensions.REGISTRY, false));
        pos.addCoordinateControl(Direction.Axis.X, this.meter::getPos, this::changePos);
        pos.addCoordinateControl(Direction.Axis.Y, this.meter::getPos, this::changePos);
        pos.addCoordinateControl(Direction.Axis.Z, this.meter::getPos, this::changePos);
        MeterPropertyElement name = new MeterPropertyElement(totalWidth, buttonWidth, "name");
        name.addControl("", (Button)new TextField(0, 0, 0, 0, Tooltips::empty, this::changeName, this.meter::getName));
        MeterPropertyElement color = new MeterPropertyElement(totalWidth, buttonWidth, "color");
        color.addControl("hex", style -> style.withColor(this.meter.getColor()), (Button)new TextField(0, 0, 0, 0, Tooltips::empty, this::changeColor, () -> ColorUtils.toRGBString(this.meter.getColor())));
        color.addControl("red", style -> style.withColor(Formatting.RED), (Button)new Slider(0, 0, 0, 0, () -> {
            int c = this.meter.getColor();
            int red = ColorUtils.getRed(c);
            return Texts.literal(String.valueOf(red));
        }, Tooltips::empty, value -> {
            int red = (int)Math.round(value * 255.0);
            int c = ColorUtils.setRed(this.meter.getColor(), red);
            this.changeColor(c);
        }, () -> {
            int c = this.meter.getColor();
            int red = ColorUtils.getRed(c);
            return (double)red / 255.0;
        }, 255L));
        color.addControl("blue", style -> style.withColor(Formatting.BLUE), (Button)new Slider(0, 0, 0, 0, () -> {
            int c = this.meter.getColor();
            int blue = ColorUtils.getBlue(c);
            return Texts.literal(String.valueOf(blue));
        }, Tooltips::empty, value -> {
            int blue = (int)Math.round(value * 255.0);
            int c = ColorUtils.setBlue(this.meter.getColor(), blue);
            this.changeColor(c);
        }, () -> {
            int c = this.meter.getColor();
            int blue = ColorUtils.getBlue(c);
            return (double)blue / 255.0;
        }, 255L));
        color.addControl("green", style -> style.withColor(Formatting.GREEN), (Button)new Slider(0, 0, 0, 0, () -> {
            int c = this.meter.getColor();
            int green = ColorUtils.getGreen(c);
            return Texts.literal(String.valueOf(green));
        }, Tooltips::empty, value -> {
            int green = (int)Math.round(value * 255.0);
            int c = ColorUtils.setGreen(this.meter.getColor(), green);
            this.changeColor(c);
        }, () -> {
            int c = this.meter.getColor();
            int green = ColorUtils.getGreen(c);
            return (double)green / 255.0;
        }, 255L));
        MeterPropertyElement movable = new MeterPropertyElement(totalWidth, buttonWidth, "movable");
        movable.addControl("", (Button)new ToggleButton(0, 0, 0, 0, this.meter::isMovable, button -> this.toggleMovable()));
        MeterPropertyElement eventTypes = new MeterPropertyElement(totalWidth, buttonWidth, "eventTypes");
        for (EventType type : EventType.ALL) {
            C_7778778 keybind = Keybinds.TOGGLE_EVENT_TYPES[type.getId()];
            Supplier<Tooltip> tooltip = () -> keybind.m_6463487() == 0 ? Tooltips.EMPTY : Tooltips.keybind(keybind);
            eventTypes.addControl(type.getName(), UnaryOperator.identity(), new ToggleButton(0, 0, 0, 0, () -> this.meter.isMetering(type), button -> this.toggleEventType(type)), tooltip);
        }
        this.controls.add(pos);
        this.controls.add(name);
        this.controls.add(color);
        this.controls.add(movable);
        this.controls.add(eventTypes);
        this.client.getTutorial().onMeterControlsOpened();
    }

    private void updateCoords() {
        this.height = 0;
        if (this.meter != null) {
            int x = this.getX();
            this.title.setX(x + 2);
            this.controls.setX(x);
            this.hideButton.setX(x += this.title.getWidth() + 10);
            this.deleteButton.setX(x += this.hideButton.getWidth() + 2);
            this.deleteConfirm.setX(x += this.deleteButton.getWidth() + 5);
            int y = this.getY() + 20;
            this.title.setY(y);
            this.deleteConfirm.setY(y);
            this.hideButton.setY(y -= 6);
            this.deleteButton.setY(y);
            this.controls.setY(y += 30);
            this.height = this.controls.getY() + this.controls.getHeight() - this.getY();
        }
    }

    private void tryDelete() {
        if (this.triedDeleting) {
            RemoveMeterPacket packet = new RemoveMeterPacket(this.meter.getId());
            this.client.sendPacket(packet);
        }
        this.triedDeleting = !this.triedDeleting;
        this.deleteButton.update();
        this.deleteConfirm.setVisible(this.triedDeleting);
    }

    private void undoTryDelete() {
        this.triedDeleting = false;
        this.deleteButton.update();
        this.deleteConfirm.setVisible(false);
    }

    private void teleport() {
        TeleportToMeterPacket packet = new TeleportToMeterPacket(this.meter.getId());
        this.client.sendPacket(packet);
    }

    private void changePos(DimPos pos) {
        this.changeProperty(properties -> properties.setPos(pos));
    }

    private void changeName(String name) {
        this.changeProperty(properties -> properties.setName(name));
    }

    private void changeColor(String color) {
        try {
            this.changeColor(ColorUtils.fromRGBString(color));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void changeColor(int color) {
        this.changeProperty(properties -> properties.setColor(color));
    }

    private void toggleMovable() {
        this.changeProperty(properties -> properties.setMovable(!this.meter.isMovable()));
    }

    private void toggleEventType(EventType type) {
        this.changeProperty(properties -> properties.setEventTypes(this.meter.getEventTypes() ^ type.flag()));
    }

    private void changeProperty(Consumer<MeterProperties.MutableMeterProperties> consumer) {
        MeterProperties.MutableMeterProperties newProperties = new MeterProperties.MutableMeterProperties();
        consumer.accept(newProperties);
        MeterUpdatePacket packet = new MeterUpdatePacket(this.meter.getId(), newProperties);
        this.client.sendPacket(packet);
    }
}

