/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.hud;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_7799337;
import net.minecraft.unmapped.C_8105098;
import redstone.multimeter.client.Keybinds;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.gui.FontRenderer;
import redstone.multimeter.client.gui.GuiRenderer;
import redstone.multimeter.client.gui.element.AbstractParentElement;
import redstone.multimeter.client.gui.element.Element;
import redstone.multimeter.client.gui.element.Label;
import redstone.multimeter.client.gui.element.button.TransparentButton;
import redstone.multimeter.client.gui.hud.HudRenderer;
import redstone.multimeter.client.gui.hud.HudSettings;
import redstone.multimeter.client.gui.hud.Orientation;
import redstone.multimeter.client.gui.hud.element.MeterEventDetails;
import redstone.multimeter.client.gui.hud.element.MeterListRenderer;
import redstone.multimeter.client.gui.hud.element.PrimaryEventViewer;
import redstone.multimeter.client.gui.hud.element.SecondaryEventViewer;
import redstone.multimeter.client.gui.hud.event.MeterEventRenderDispatcher;
import redstone.multimeter.client.gui.text.Formatting;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.gui.tooltip.Tooltips;
import redstone.multimeter.client.meter.ClientMeterGroup;
import redstone.multimeter.client.option.Options;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.common.meter.log.EventLog;
import redstone.multimeter.util.ColorUtils;

public class MultimeterHud
extends AbstractParentElement {
    public final MultimeterClient client;
    public final FontRenderer font;
    public final HudSettings settings;
    public final MeterEventRenderDispatcher eventRenderers;
    public final List<Meter> meters;
    private int partCount;
    private MeterListRenderer names;
    private PrimaryEventViewer ticks;
    private SecondaryEventViewer subticks;
    private MeterEventDetails details;
    private Label meterGroupSlot;
    private Label meterGroupName;
    private Label tickMarkerCounter;
    private TransparentButton playPauseButton;
    private TransparentButton fastBackwardButton;
    private TransparentButton fastForwardButton;
    private Label printIndicator;
    private int hudX;
    private int hudY;
    private int hudWidth;
    private int hudHeight;
    private boolean paused;
    private boolean wasPaused;
    private int offset;
    private boolean onScreen;
    private Meter selectedMeter;
    private boolean focusMode;
    private Meter focussedMeter;
    private EventLog focussedEvent;
    private long tickMarker;

    public MultimeterHud(MultimeterClient client) {
        this.client = client;
        this.font = client.getFontRenderer();
        this.settings = new HudSettings(this);
        this.eventRenderers = new MeterEventRenderDispatcher(this);
        this.meters = new ArrayList<Meter>();
        this.tickMarker = -1L;
    }

    public void render(GuiRenderer renderer) {
        this.render(renderer, -1, -1);
    }

    @Override
    public void render(GuiRenderer renderer, int mouseX, int mouseY) {
        int index;
        if (!this.hasContent()) {
            return;
        }
        HudRenderer hudRenderer = new HudRenderer(this, renderer);
        renderer.pushMatrix();
        renderer.translate(0.0, 0.0, 100.0);
        List<Element> children = this.getChildren();
        for (index = 0; index < this.partCount; ++index) {
            Element part = children.get(index);
            if (!part.isVisible()) continue;
            hudRenderer.render(part, mouseX, mouseY);
        }
        renderer.popMatrix();
        for (index = this.partCount; index < children.size(); ++index) {
            Element child = children.get(index);
            if (!child.isVisible()) continue;
            child.render(renderer, mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClick(double mouseX, double mouseY, int button) {
        boolean consumed = super.mouseClick(mouseX, mouseY, button);
        if (!consumed) {
            this.selectMeter(null);
        }
        return consumed;
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        int minX = Math.max(this.getX(), this.hudX);
        int maxX = Math.min(this.getX() + this.getAvailableWidth(), this.hudX + this.hudWidth);
        int minY = Math.max(this.getY(), this.hudY);
        int maxY = Math.max(this.getY() + this.getAvailableHeight(), this.hudY + this.hudHeight);
        return mouseX >= (double)minX && mouseX <= (double)maxX && mouseY >= (double)minY && mouseY <= (double)maxY;
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        this.onScreen = false;
        this.settings.forceFullOpacity = false;
        this.settings.ignoreHiddenMeters = true;
        this.meterGroupName.update();
        if (!((Boolean)Options.HUD.PAUSE_INDICATOR.get()).booleanValue()) {
            this.playPauseButton.setVisible(false);
        }
        this.playPauseButton.update();
        this.fastBackwardButton.setVisible(false);
        this.fastForwardButton.setVisible(false);
        this.setX(0);
        this.setY(0);
        this.resetSize();
        this.updateMeterList();
        if (this.paused && ((Boolean)Options.HUD.AUTO_UNPAUSE.get()).booleanValue()) {
            this.togglePaused();
        }
    }

    @Override
    public int getWidth() {
        return this.hudWidth;
    }

    @Override
    public int getHeight() {
        return this.hudHeight;
    }

    @Override
    public void update() {
    }

    @Override
    public void setX(int x) {
        super.setX(x);
        int effectiveWidth = this.names.getWidth() + this.ticks.getWidth();
        int range = this.getAvailableWidth() - effectiveWidth;
        float rawPos = this.getScreenPosX();
        int pos = Math.round((float)range * rawPos);
        switch (this.getOrientationX()) {
            default: {
                x = this.hudX = x + pos;
                this.names.setX(x);
                x += this.settings.gridSize + 1;
                if (this.meterGroupSlot.isVisible()) {
                    this.meterGroupSlot.setX(x);
                    x += this.meterGroupSlot.getWidth() + this.settings.gridSize + 1;
                }
                this.meterGroupName.setX(x);
                x = this.hudX;
                this.ticks.setX(x += this.names.getWidth());
                int w = this.playPauseButton.getWidth();
                this.playPauseButton.setX((x += this.ticks.getWidth()) - 2 * w);
                this.fastBackwardButton.setX(x - 3 * w);
                this.fastForwardButton.setX(x - w);
                this.printIndicator.setX(x - 4 * w);
                this.subticks.setX(x += this.settings.columnWidth + this.settings.gridSize);
                this.tickMarkerCounter.setX(x);
                this.details.setX(x += this.subticks.getWidth() + this.settings.columnWidth + this.settings.gridSize);
                break;
            }
            case RIGHT_TO_LEFT: {
                this.hudX = x + pos + effectiveWidth - this.getWidth();
                x = this.hudX + (this.getWidth() - this.names.getWidth());
                this.names.setX(x);
                x += this.names.getWidth();
                if (this.meterGroupSlot.isVisible()) {
                    this.meterGroupSlot.setX((x -= this.meterGroupSlot.getWidth() + this.settings.gridSize + 1) + 1);
                }
                this.meterGroupName.setX(x -= this.meterGroupName.getWidth() + this.settings.gridSize);
                x = this.hudX + (this.getWidth() - this.names.getWidth());
                this.ticks.setX(x -= this.ticks.getWidth());
                int w = this.playPauseButton.getWidth();
                this.playPauseButton.setX(x + w);
                this.fastBackwardButton.setX(x + 2 * w);
                this.fastForwardButton.setX(x);
                this.printIndicator.setX(x + 3 * w);
                this.tickMarkerCounter.setX(x -= this.settings.columnWidth);
                this.subticks.setX(x -= this.settings.gridSize + this.subticks.getWidth());
                this.details.setX(x -= this.settings.columnWidth + this.settings.gridSize + this.details.getWidth());
            }
        }
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        int range = this.getAvailableHeight() - this.getHeight();
        float position = this.getScreenPosY();
        this.hudY = y + Math.round(position * (float)range);
        switch (this.getOrientationY()) {
            default: {
                y = this.hudY;
                this.names.setY(y);
                this.ticks.setY(y);
                this.subticks.setY(y);
                this.details.setY(y);
                this.meterGroupSlot.setY((y += this.names.getHeight()) + this.settings.gridSize);
                this.meterGroupName.setY(y + this.settings.gridSize);
                this.playPauseButton.setY(++y);
                this.fastBackwardButton.setY(y);
                this.fastForwardButton.setY(y);
                break;
            }
            case BOTTOM_TO_TOP: {
                y = this.hudY + this.settings.rowHeight + this.settings.gridSize;
                this.names.setY(y);
                this.ticks.setY(y);
                this.subticks.setY(y);
                this.details.setY(y - (this.details.getHeight() - this.names.getHeight()));
                this.meterGroupSlot.setY(y - this.meterGroupSlot.getHeight());
                this.meterGroupName.setY(y - this.meterGroupName.getHeight());
                this.playPauseButton.setY(y -= this.playPauseButton.getHeight());
                this.fastBackwardButton.setY(y);
                this.fastForwardButton.setY(y);
            }
        }
        y = this.fastBackwardButton.getMessageY();
        this.tickMarkerCounter.setY(y);
        this.printIndicator.setY(y);
    }

    private void addPart(Element part) {
        this.addChild(part);
        ++this.partCount;
    }

    public void init() {
        this.names = new MeterListRenderer(this);
        this.ticks = new PrimaryEventViewer(this);
        this.subticks = new SecondaryEventViewer(this);
        this.details = new MeterEventDetails(this);
        this.meterGroupSlot = new Label(0, 0, t -> {
            int slot;
            int n = slot = this.client.isPreviewing() ? this.client.getMeterGroupPreview().getSlot() : this.client.getMeterGroup().getSlot();
            if (slot < 0) {
                t.setVisible(false);
            } else {
                t.setVisible(true);
                Text text = Texts.literal("[" + slot + "]");
                int a = Math.round((float)(255 * this.settings.opacity()) / 100.0f);
                int rgb = this.onScreen ? 0xF0F0F0 : 0x404040;
                int color = ColorUtils.setAlpha(rgb, a);
                if (!this.client.isPreviewing() && this.client.getMeterGroup().isDirty()) {
                    text.format(Formatting.BOLD);
                }
                t.addLine(text);
                t.setColor(color);
            }
        }, () -> this.client.isPreviewing() || !this.client.getMeterGroup().isDirty() ? Tooltips.EMPTY : Tooltips.translatable("rsmm.gui.multimeter.meterGroup.slot.unsavedChanges"));
        this.meterGroupName = new Label(0, 0, t -> {
            String name = this.client.isPreviewing() ? this.client.getMeterGroupPreview().getName() : this.client.getMeterGroup().getName();
            Text text = Texts.literal(name);
            int a = Math.round((float)(255 * this.settings.opacity()) / 100.0f);
            int rgb = this.onScreen ? 0xD0D0D0 : 0x202020;
            int color = ColorUtils.setAlpha(rgb, a);
            if (this.paused && !((Boolean)Options.HUD.HIDE_HIGHLIGHT.get()).booleanValue() && !((Boolean)Options.HUD.PAUSE_INDICATOR.get()).booleanValue()) {
                text.append(" (").append(Texts.translatable("rsmm.gui.multimeter.timeline.paused")).append(")");
            }
            t.addLine(text).setColor(color);
        });
        this.tickMarkerCounter = new Label(0, 0, t -> {
            if (this.hasTickMarker()) {
                long tick = this.paused ? this.getSelectedTick() : this.getCurrentTick();
                String text = String.valueOf(tick - this.tickMarker);
                int a = Math.round((float)(255 * this.settings.opacity()) / 100.0f);
                int rgb = this.settings.colorHighlightTickMarker;
                int color = ColorUtils.setAlpha(rgb, a);
                t.addLine(text).setColor(color).setVisible(true);
            } else {
                t.setVisible(false);
            }
        }, () -> Tooltips.keybind(Keybinds.TOGGLE_MARKER));
        this.playPauseButton = new TransparentButton(0, 0, 9, 9, () -> Texts.literal(!this.onScreen ^ this.paused ? "\u23f5" : "\u23f8"), () -> Tooltips.keybind(Keybinds.PAUSE_TIMELINE), button -> {
            this.togglePaused();
            return true;
        });
        this.fastBackwardButton = new TransparentButton(0, 0, 9, 9, () -> Texts.literal(this.getStepSymbol(false, C_3020744.m_7566055())), () -> Tooltips.keybind(Keybinds.STEP_BACKWARD, Keybinds.STEP_BACKWARD, new Object[]{Keybinds.SCROLL_HUD, "scroll"}), button -> {
            this.stepBackward(C_3020744.m_7566055());
            return true;
        }){

            @Override
            public void tick() {
                this.update();
            }
        };
        this.fastForwardButton = new TransparentButton(0, 0, 9, 9, () -> Texts.literal(this.getStepSymbol(true, C_3020744.m_7566055())), () -> Tooltips.keybind(Keybinds.STEP_FORWARD, Keybinds.STEP_FORWARD, new Object[]{Keybinds.SCROLL_HUD, "scroll"}), button -> {
            this.stepForward(C_3020744.m_7566055());
            return true;
        }){

            @Override
            public void tick() {
                this.update();
            }
        };
        this.printIndicator = new Label(0, 0, t -> t.addLine(Texts.literal("P").format(Formatting.BOLD)).setShadow(true), () -> Tooltips.keybind(Keybinds.PRINT_LOGS));
        if (!((Boolean)Options.HUD.PAUSE_INDICATOR.get()).booleanValue()) {
            this.playPauseButton.setVisible(false);
        }
        this.fastBackwardButton.setVisible(false);
        this.fastForwardButton.setVisible(false);
        this.printIndicator.setVisible(false);
        this.partCount = 0;
        this.addPart(this.names);
        this.addPart(this.ticks);
        this.addPart(this.subticks);
        this.addPart(this.details);
        this.addChild(this.meterGroupSlot);
        this.addChild(this.meterGroupName);
        this.addChild(this.tickMarkerCounter);
        this.addChild(this.playPauseButton);
        this.addChild(this.fastBackwardButton);
        this.addChild(this.fastForwardButton);
        this.addChild(this.printIndicator);
        this.optionsChanged();
        this.resetSize();
    }

    private String getStepSymbol(boolean forward, boolean fast) {
        boolean leftToRight;
        boolean bl = leftToRight = this.getOrientationX() == Orientation.X.LEFT_TO_RIGHT;
        if (forward == leftToRight) {
            return fast ? "\u23ed" : "\u23e9";
        }
        return fast ? "\u23ee" : "\u23ea";
    }

    public float getScreenPosX() {
        return (float)((Integer)Options.HUD.SCREEN_POS_X.get()).intValue() / 100.0f;
    }

    public float getScreenPosY() {
        return (float)((Integer)Options.HUD.SCREEN_POS_Y.get()).intValue() / 100.0f;
    }

    public Orientation.X getOrientationX() {
        return (Orientation.X)Options.HUD.ORIENTATION_X.get();
    }

    public Orientation.Y getOrientationY() {
        return (Orientation.Y)Options.HUD.ORIENTATION_Y.get();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void togglePaused() {
        if (!this.client.isPreviewing() && !this.focusMode && this.hasContent()) {
            boolean pause;
            boolean bl = pause = !this.paused;
            if (this.setPaused(pause)) {
                this.client.getTutorial().onPauseHud(pause);
            }
        }
    }

    public boolean setPaused(boolean pause) {
        if (this.paused == pause) {
            return false;
        }
        this.paused = pause;
        this.meterGroupSlot.update();
        this.meterGroupName.update();
        this.playPauseButton.update();
        this.fastBackwardButton.setActive(this.paused);
        this.fastForwardButton.setActive(this.paused);
        if (this.paused) {
            this.updateEventViewersWidth();
        } else {
            this.resetOffset();
            if (this.hasTickMarker() && ((Boolean)Options.HUD.AUTO_REMOVE_MARKER.get()).booleanValue()) {
                this.toggleTickMarker(false);
            }
        }
        return true;
    }

    public int getColumn(long tick) {
        return this.getColumn(tick, false);
    }

    public int getColumn(long tick, boolean allowRightEdge) {
        long first = this.client.getPrevGameTime() + (long)this.offset;
        long last = first + (long)((Integer)Options.HUD.COLUMN_COUNT.get()).intValue();
        if (!allowRightEdge) {
            --last;
        }
        return tick < first || tick > last ? -1 : (int)(tick - first);
    }

    private void setOffset(int offset) {
        this.offset = offset;
        this.updateTickMarkerCounter();
        this.updateEventViewersWidth();
    }

    public void resetOffset() {
        this.setOffset(1 - (Integer)Options.HUD.COLUMN_COUNT.get());
    }

    public void stepBackward(boolean jump) {
        if (!this.client.isPreviewing()) {
            if (this.focusMode) {
                this.moveFocus(this.focussedEvent.getTick(), jump ? 0 : this.focussedEvent.getSubtick(), false);
            } else if (this.paused) {
                this.moveOffset(jump ? 10 : 1, false);
            }
        }
    }

    public void stepForward(boolean jump) {
        if (!this.client.isPreviewing()) {
            if (this.focusMode) {
                this.moveFocus(this.focussedEvent.getTick(), jump ? this.client.getMeterGroup().getLogManager().getSubtickCount(this.focussedEvent.getTick()) : this.focussedEvent.getSubtick(), true);
            } else if (this.paused) {
                this.moveOffset(jump ? 10 : 1, true);
            }
        }
    }

    public void scroll(int amount, boolean forward) {
        if (!this.client.isPreviewing()) {
            if (this.focusMode) {
                this.moveFocus(this.focussedEvent.getTick(), this.focussedEvent.getSubtick(), forward);
            } else {
                this.moveOffset(amount, forward);
            }
        }
    }

    private void moveOffset(int amount, boolean forward) {
        if (!forward) {
            amount *= -1;
        }
        this.setOffset(this.offset + amount);
        this.client.getTutorial().onScrollHud(amount);
    }

    private boolean moveFocus(long tick, int subtick, boolean forward) {
        Meter closestMeter = null;
        EventLog closestEvent = null;
        for (Meter meter : this.meters) {
            EventLog event = forward ? meter.getLogs().getFirstLogAfter(tick, subtick) : meter.getLogs().getLastLogBefore(tick, subtick);
            if (event == null || closestEvent != null && !(forward ? event.isBefore(closestEvent) : event.isAfter(closestEvent))) continue;
            closestMeter = meter;
            closestEvent = event;
        }
        if (closestEvent != null) {
            this.focussedMeter = closestMeter;
            this.focussedEvent = closestEvent;
            this.setOffset(this.offset + (int)(this.focussedEvent.getTick() - this.getSelectedTick()));
        }
        return this.focussedEvent != null;
    }

    public boolean hasContent() {
        return !this.meters.isEmpty();
    }

    public boolean isOnScreen() {
        return this.onScreen;
    }

    public Meter getSelectedMeter() {
        return this.selectedMeter;
    }

    public boolean hasSelectedMeter() {
        return this.selectedMeter != null;
    }

    public boolean selectMeter(int row) {
        if (row >= 0 && row < this.meters.size()) {
            return this.selectMeter(this.meters.get(row));
        }
        return this.selectMeter(null);
    }

    public boolean selectMeter(Meter meter) {
        if (meter == this.selectedMeter) {
            return false;
        }
        this.selectedMeter = meter;
        if (this.onScreen) {
            this.client.getScreen().update();
        }
        return true;
    }

    public boolean isFocusMode() {
        return this.focusMode;
    }

    public void toggleFocusMode() {
        if (!this.client.isPreviewing() && this.hasContent()) {
            boolean enable;
            boolean bl = enable = !this.focusMode;
            if (this.setFocusMode(enable)) {
                String action = enable ? "enabled" : "disabled";
                this.client.sendMessage(Texts.translatable("rsmm.toggleFocusMode." + action), true);
                this.client.getTutorial().onToggleFocusMode(enable);
            } else {
                this.client.sendMessage(Texts.translatable("rsmm.toggleFocusMode.noLogs"), true);
            }
        }
    }

    public boolean setFocusMode(boolean enabled) {
        if (this.focusMode == enabled) {
            return false;
        }
        if (enabled && !this.moveFocus(this.getSelectedTick(), 0, true) && !this.moveFocus(this.getSelectedTick(), Integer.MAX_VALUE, false)) {
            return false;
        }
        this.focusMode = enabled;
        if (this.focusMode) {
            this.wasPaused = this.paused;
            if (!this.wasPaused) {
                this.setPaused(true);
            }
        } else {
            if (!this.wasPaused) {
                this.setPaused(false);
            }
            this.focussedMeter = null;
            this.focussedEvent = null;
        }
        return true;
    }

    public Meter getFocussedMeter() {
        return this.focussedMeter;
    }

    public EventLog getFocussedEvent() {
        return this.focussedEvent;
    }

    public boolean hasTickMarker() {
        return this.tickMarker >= 0L;
    }

    public long getTickMarker() {
        return this.tickMarker;
    }

    public void toggleTickMarker(boolean force) {
        this.tickMarker = this.tickMarker < 0L || force ? (this.paused ? this.getSelectedTick() : this.getCurrentTick()) : -1L;
        this.updateTickMarkerCounter();
    }

    private void updateTickMarkerCounter() {
        this.tickMarkerCounter.update();
        if (this.tickMarkerCounter.isVisible()) {
            int x;
            switch (this.getOrientationX()) {
                default: {
                    x = this.subticks.getX();
                    break;
                }
                case RIGHT_TO_LEFT: {
                    x = this.subticks.getX() + this.subticks.getWidth() - this.tickMarkerCounter.getWidth();
                }
            }
            this.tickMarkerCounter.setX(x);
        }
    }

    public int getHoveredRow(double mouseY) {
        int max = this.meters.size() - 1;
        int row = Math.min(max, (int)((mouseY - (double)this.names.getY()) / (double)(this.settings.rowHeight + this.settings.gridSize)));
        if (this.getOrientationY() == Orientation.Y.BOTTOM_TO_TOP) {
            row = max - row;
        }
        return row;
    }

    public int getSelectedRow() {
        return this.selectedMeter == null ? -1 : this.meters.indexOf(this.selectedMeter);
    }

    public int getFocussedRow() {
        return this.focussedMeter == null ? -1 : this.meters.indexOf(this.focussedMeter);
    }

    public long getSelectedTick() {
        return this.client.getPrevGameTime() + (long)this.offset + (long)((Integer)Options.HUD.SELECTED_COLUMN.get()).intValue();
    }

    public long getCurrentTick() {
        return this.client.getPrevGameTime() + 1L;
    }

    public int getAvailableWidth() {
        return super.getWidth();
    }

    public int getAvailableHeight() {
        return this.onScreen ? this.hudHeight : super.getHeight();
    }

    public void resize(int width, int height) {
        super.setWidth(width);
        super.setHeight(height);
        this.onResized();
    }

    public void onResized() {
        this.updateWidth();
        this.updateHeight();
        if (this.onScreen) {
            this.client.getScreen().update();
        }
    }

    public void resetSize() {
        C_8105098 minecraft = this.client.getMinecraft();
        C_7799337 window = new C_7799337(minecraft.f_9967940, minecraft.f_0545414, minecraft.f_5990000);
        int width = window.m_1713651();
        int height = window.m_5421693();
        this.resize(width, height);
    }

    public void updateWidth() {
        this.names.updateWidth();
        this.ticks.updateWidth();
        this.subticks.updateWidth();
        this.details.updateWidth();
        this.onWidthUpdated();
    }

    public void updateMeterListWidth() {
        this.names.updateWidth();
        this.onWidthUpdated();
    }

    public void updateEventViewersWidth() {
        this.ticks.updateWidth();
        this.subticks.updateWidth();
        this.details.updateWidth();
        this.onWidthUpdated();
    }

    private void onWidthUpdated() {
        this.hudWidth = this.names.getWidth() + this.ticks.getWidth();
        if (this.subticks.getWidth() > 0) {
            this.hudWidth += this.subticks.getWidth() + this.settings.columnWidth + this.settings.gridSize;
            this.hudWidth += this.details.getWidth() + this.settings.columnWidth + this.settings.gridSize;
        }
        this.validateHudWidth();
        this.setX(this.getX());
    }

    private void validateHudWidth() {
        this.hudWidth = Math.min(this.hudWidth, this.getAvailableWidth());
    }

    public void updateHeight() {
        this.names.updateHeight();
        this.ticks.updateHeight();
        this.subticks.updateHeight();
        this.details.updateHeight();
        this.onHeightUpdated();
    }

    private void onHeightUpdated() {
        this.hudHeight = Math.max(this.names.getHeight(), this.details.getHeight()) + this.settings.rowHeight + this.settings.gridSize;
        this.validateHudHeight();
        this.setY(this.getY());
    }

    private void validateHudHeight() {
        this.hudHeight = Math.min(this.hudHeight, this.getAvailableHeight());
    }

    public void updateMeterList() {
        this.meters.clear();
        ClientMeterGroup meterGroup = this.client.isPreviewing() ? this.client.getMeterGroupPreview() : this.client.getMeterGroup();
        for (Meter meter : meterGroup.getMeters()) {
            if (this.settings.ignoreHiddenMeters && meter.isHidden()) continue;
            this.meters.add(meter);
        }
        this.meterGroupSlot.update();
        this.meterGroupName.update();
        this.onResized();
        if (this.selectedMeter != null && !meterGroup.hasMeter(this.selectedMeter)) {
            this.selectMeter(null);
        }
        if (this.focusMode && this.focussedMeter != null && !meterGroup.hasMeter(this.focussedMeter)) {
            this.setFocusMode(false);
        }
        if (this.paused && !this.hasContent()) {
            this.setPaused(false);
        }
    }

    public void reset() {
        this.paused = false;
        this.tickMarker = -1L;
        this.meters.clear();
        this.resetOffset();
        this.setX(0);
        this.setY(0);
    }

    public void tickTime() {
        if (this.paused) {
            this.setOffset(this.offset - 1);
        } else {
            this.updateTickMarkerCounter();
        }
    }

    public void onInitScreen(int width, int height) {
        if (!this.client.hasMultimeterScreenOpen()) {
            return;
        }
        if (this.client.isPreviewing()) {
            this.client.getSavedMeterGroupsManager().setIdle();
        }
        this.onScreen = true;
        if (this.settings.rowHeight < this.font.height()) {
            this.settings.rowHeight = this.font.height();
        }
        this.settings.forceFullOpacity = true;
        this.settings.ignoreHiddenMeters = false;
        this.meterGroupSlot.update();
        this.meterGroupName.update();
        this.playPauseButton.setVisible(true);
        this.playPauseButton.update();
        this.fastBackwardButton.setVisible(true);
        this.fastForwardButton.setVisible(true);
        this.resize(width - 2, height);
        this.updateMeterList();
        if (this.hasContent() && !this.paused && ((Boolean)Options.HUD.AUTO_PAUSE.get()).booleanValue()) {
            this.togglePaused();
        }
    }

    public void optionsChanged() {
        this.settings.optionsChanged();
        this.meterGroupSlot.update();
        this.meterGroupName.update();
        this.playPauseButton.setVisible(this.onScreen || (Boolean)Options.HUD.PAUSE_INDICATOR.get() != false);
        this.onResized();
        if (!this.paused) {
            this.resetOffset();
        }
    }

    public void onTogglePrinter() {
        this.printIndicator.setVisible(this.client.getMeterGroup().getLogManager().getPrinter().isPrinting());
    }
}

