/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.hud.element;

import net.minecraft.unmapped.C_3020744;
import redstone.multimeter.client.Keybinds;
import redstone.multimeter.client.gui.GuiRenderer;
import redstone.multimeter.client.gui.element.AbstractElement;
import redstone.multimeter.client.gui.hud.MultimeterHud;
import redstone.multimeter.client.gui.text.Formatting;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.gui.tooltip.Tooltip;
import redstone.multimeter.client.gui.tooltip.Tooltips;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.common.network.packets.MeterIndexPacket;
import redstone.multimeter.util.ColorUtils;

public class MeterListRenderer
extends AbstractElement {
    private static final int MARGIN = 1;
    private final MultimeterHud hud;
    private int cursorOriginRow;
    private int cursorRow;
    private Meter cursorMeter;
    private int cursorOffsetX;
    private int cursorOffsetY;

    public MeterListRenderer(MultimeterHud hud) {
        super(0, 0, 0, 0);
        this.hud = hud;
        this.cursorOriginRow = -1;
        this.cursorRow = -1;
    }

    @Override
    public void render(GuiRenderer renderer, int mouseX, int mouseY) {
        renderer.pushMatrix();
        this.drawCursorMeter(renderer, mouseX, mouseY);
        renderer.translate(0.0, 0.0, -1.0);
        this.drawHighlights(renderer, mouseX, mouseY);
        renderer.translate(0.0, 0.0, -1.0);
        this.drawNames(renderer, mouseX, mouseY);
        renderer.translate(0.0, 0.0, -1.0);
        renderer.fill(0, 0, this.getWidth(), this.getHeight(), this.hud.settings.colorBackground);
        renderer.popMatrix();
    }

    @Override
    public void mouseMove(double mouseX, double mouseY) {
    }

    @Override
    public boolean mouseClick(double mouseX, double mouseY, int button) {
        boolean consumed = super.mouseClick(mouseX, mouseY, button);
        if (button == 0) {
            this.cursorOriginRow = this.hud.getHoveredRow(mouseY);
        }
        return consumed || this.cursorOriginRow >= 0;
    }

    @Override
    public boolean mouseRelease(double mouseX, double mouseY, int button) {
        boolean consumed = super.mouseRelease(mouseX, mouseY, button);
        if (button == 0) {
            if (this.cursorMeter == null) {
                if (this.cursorRow < 0) {
                    consumed = this.hud.selectMeter(this.cursorOriginRow);
                }
            } else {
                consumed = this.changeMeterIndex(this.cursorMeter, this.cursorOriginRow, this.hud.getHoveredRow(mouseY));
            }
            this.cursorOriginRow = -1;
            this.cursorRow = -1;
            this.cursorMeter = null;
        }
        return consumed;
    }

    @Override
    public boolean mouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        int n = this.cursorRow = this.isMouseOver(mouseX, mouseY) ? this.hud.getHoveredRow(mouseY) : -1;
        if (this.cursorMeter == null && this.cursorOriginRow >= 0) {
            this.cursorMeter = this.hud.meters.get(this.cursorOriginRow);
            this.cursorOffsetX = this.getX() - (int)mouseX;
            this.cursorOffsetY = this.getY() - (int)mouseY + this.cursorOriginRow * (this.hud.settings.rowHeight + this.hud.settings.gridSize);
        }
        return false;
    }

    @Override
    public boolean mouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        return false;
    }

    @Override
    public boolean keyPress(int keyCode) {
        if (!this.hud.hasSelectedMeter()) {
            return false;
        }
        switch (keyCode) {
            case 200: {
                this.moveSelection(C_3020744.m_7566055() ? -this.hud.getSelectedRow() : -1);
                break;
            }
            case 208: {
                this.moveSelection(C_3020744.m_7566055() ? this.hud.meters.size() - 1 - this.hud.getSelectedRow() : 1);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean keyRelease(int keyCode) {
        return false;
    }

    @Override
    public boolean typeChar(char chr) {
        return false;
    }

    @Override
    public void tick() {
    }

    @Override
    public Tooltip getTooltip(int mouseX, int mouseY) {
        if (Keybinds.OPEN_METER_CONTROLS.m_6463487() == 0 || this.cursorMeter != null) {
            return super.getTooltip(mouseX, mouseY);
        }
        int hoveredRow = this.hud.getHoveredRow(mouseY);
        if (hoveredRow < 0 || hoveredRow == this.hud.getSelectedRow()) {
            return super.getTooltip(mouseX, mouseY);
        }
        return Tooltips.keybind(Keybinds.OPEN_METER_CONTROLS);
    }

    @Override
    public void update() {
    }

    private void drawCursorMeter(GuiRenderer renderer, int mouseX, int mouseY) {
        if (this.cursorMeter != null) {
            renderer.pushMatrix();
            int startX = mouseX + this.cursorOffsetX;
            int startY = mouseY + this.cursorOffsetY;
            int alpha = 221;
            int x = startX;
            int y = startY;
            if (this.cursorOriginRow == this.hud.getSelectedRow()) {
                this.drawHighlight(renderer, x, y, true);
                renderer.translate(0.0, 0.0, -0.1);
            }
            x = startX + this.hud.settings.gridSize + 1;
            y = startY + this.hud.settings.gridSize + 1 + this.hud.settings.rowHeight - (this.hud.settings.rowHeight + this.hud.font.height()) / 2;
            this.drawName(renderer, this.cursorMeter, x, y, ColorUtils.setAlpha(0xFFFFFF, alpha));
            renderer.translate(0.0, 0.0, -0.1);
            int x0 = startX;
            int y0 = startY;
            int x1 = x0 + this.getWidth();
            int y1 = y0 + this.hud.settings.rowHeight + 2 * this.hud.settings.gridSize;
            int color = ColorUtils.setAlpha(this.hud.settings.colorBackground, alpha);
            renderer.fill(x0, y0, x1, y1, color);
            renderer.popMatrix();
        }
    }

    private void drawHighlights(GuiRenderer renderer, int mouseX, int mouseY) {
        int focussedRow;
        if (this.hud.isOnScreen()) {
            if (this.cursorMeter == null && this.isMouseOver(mouseX, mouseY)) {
                this.drawHighlight(renderer, this.hud.getHoveredRow(mouseY), false);
            }
            int selectedRow = this.hud.getSelectedRow();
            if ((this.cursorMeter == null || selectedRow != this.cursorOriginRow) && selectedRow >= 0) {
                int highlightRow = selectedRow;
                if (this.cursorMeter != null) {
                    if (selectedRow > this.cursorOriginRow && selectedRow <= this.cursorRow) {
                        --highlightRow;
                    }
                    if (selectedRow < this.cursorOriginRow && selectedRow >= this.cursorRow) {
                        ++highlightRow;
                    }
                }
                this.drawHighlight(renderer, highlightRow, true);
            }
        } else if (this.hud.isFocusMode() && (focussedRow = this.hud.getFocussedRow()) != -1) {
            this.drawHighlight(renderer, focussedRow, true);
        }
    }

    private void drawHighlight(GuiRenderer renderer, int row, boolean selection) {
        int x = 0;
        int y = row * (this.hud.settings.rowHeight + this.hud.settings.gridSize);
        this.drawHighlight(renderer, x, y, selection);
    }

    private void drawHighlight(GuiRenderer renderer, int x, int y, boolean selection) {
        int x0 = x;
        int y0 = y;
        int x1 = x0 + this.getWidth();
        int y1 = y0 + this.hud.settings.rowHeight + 2 * this.hud.settings.gridSize;
        int color = selection ? this.hud.settings.colorHighlightSelected : this.hud.settings.colorHighlightHovered;
        renderer.borders(x0, y0, x1, y1, color);
    }

    private void drawNames(GuiRenderer renderer, int mouseX, int mouseY) {
        if (this.hud.settings.rowHeight < this.hud.font.height()) {
            return;
        }
        int startX = this.hud.settings.gridSize + 1;
        int startY = this.hud.settings.gridSize + 1 + this.hud.settings.rowHeight - (this.hud.settings.rowHeight + this.hud.font.height()) / 2;
        for (int index = 0; index < this.hud.meters.size(); ++index) {
            Meter meter = this.hud.meters.get(index);
            if (meter == this.cursorMeter) continue;
            int offset = index;
            if (this.cursorMeter != null && this.cursorRow >= 0) {
                if (index > this.cursorOriginRow && index <= this.cursorRow) {
                    --offset;
                }
                if (index < this.cursorOriginRow && index >= this.cursorRow) {
                    ++offset;
                }
            }
            int x = startX;
            int y = startY + offset * (this.hud.settings.rowHeight + this.hud.settings.gridSize);
            this.drawName(renderer, meter, x, y, -1);
        }
    }

    private void drawName(GuiRenderer renderer, Meter meter, int x, int y, int color) {
        Text name = Texts.literal(meter.getName());
        if (meter.isHidden()) {
            name.format(Formatting.GRAY, Formatting.ITALIC);
        }
        renderer.drawString(name, x, y, color);
    }

    public void updateWidth() {
        int width = 0;
        for (Meter meter : this.hud.meters) {
            int nameWidth = this.hud.font.width(meter.getName());
            if (nameWidth <= width) continue;
            width = nameWidth;
        }
        this.setWidth(width + 2 * this.hud.settings.gridSize + 1);
    }

    public void updateHeight() {
        this.setHeight(this.hud.meters.size() * (this.hud.settings.rowHeight + this.hud.settings.gridSize) + this.hud.settings.gridSize);
    }

    private void moveSelection(int amount) {
        int row = (this.hud.getSelectedRow() + amount) % this.hud.meters.size();
        this.hud.selectMeter(row < 0 ? row + this.hud.meters.size() : row);
    }

    private boolean changeMeterIndex(Meter meter, int oldIndex, int index) {
        if (meter == null || oldIndex < 0 || index < 0) {
            return false;
        }
        this.hud.meters.remove(oldIndex);
        this.hud.meters.add(index, meter);
        MeterIndexPacket packet = new MeterIndexPacket(meter.getId(), index);
        this.hud.client.sendPacket(packet);
        return true;
    }
}

