/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.hud.event;

import redstone.multimeter.client.gui.GuiRenderer;
import redstone.multimeter.client.gui.hud.MultimeterHud;
import redstone.multimeter.client.gui.hud.event.MeterEventRenderer;
import redstone.multimeter.client.option.Options;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.common.meter.event.EventType;
import redstone.multimeter.common.meter.event.MeterEvent;
import redstone.multimeter.common.meter.log.EventLog;
import redstone.multimeter.common.meter.log.MeterLogs;

public class BasicEventRenderer
extends MeterEventRenderer {
    public BasicEventRenderer(MultimeterHud hud) {
        super(hud, null);
    }

    @Override
    public void renderTickLogs(GuiRenderer renderer, int x, int y, long firstTick, long lastTick, Meter meter) {
        int index;
        y += this.hud.settings.gridSize;
        MeterLogs logs = meter.getLogs();
        EventLog log = logs.getLog(this.type, index = logs.getLastLogBefore(this.type, firstTick) + 1);
        if (log == null) {
            return;
        }
        long lastHudTick = firstTick + (long)((Integer)Options.HUD.COLUMN_COUNT.get()).intValue();
        if (lastHudTick > lastTick) {
            lastHudTick = lastTick;
        }
        long tick = -1L;
        while (log.isBefore(lastHudTick)) {
            if (log.isAfter(tick)) {
                tick = log.getTick();
                int column = (int)(tick - firstTick);
                int columnX = x + column * (this.hud.settings.columnWidth + this.hud.settings.gridSize) + this.hud.settings.gridSize;
                this.drawEvent(renderer, columnX, y, meter, log.getEvent());
            }
            if ((log = logs.getLog(this.type, ++index)) != null) continue;
            break;
        }
    }

    @Override
    public void renderSubtickLogs(GuiRenderer renderer, int x, int y, long tick, int subtickCount, Meter meter) {
        int index;
        y += this.hud.settings.gridSize;
        MeterLogs logs = meter.getLogs();
        EventLog log = logs.getLog(this.type, index = logs.getLastLogBefore(this.type, tick) + 1);
        if (log == null) {
            return;
        }
        while (log.isBefore(tick, subtickCount)) {
            int column = log.getSubtick();
            int columnX = x + column * (this.hud.settings.columnWidth + this.hud.settings.gridSize) + this.hud.settings.gridSize;
            this.drawEvent(renderer, columnX, y, meter, log.getEvent());
            if ((log = logs.getLog(this.type, ++index)) != null) continue;
            break;
        }
    }

    public void setType(EventType type) {
        this.type = type;
    }

    protected void drawEvent(GuiRenderer renderer, int x, int y, Meter meter, MeterEvent event) {
        renderer.pushMatrix();
        this.drawCenter(renderer, x, y, meter, event);
        renderer.translate(0.0, 0.0, -0.01);
        this.drawEdges(renderer, x, y, meter, event);
        renderer.popMatrix();
    }

    protected void drawEdges(GuiRenderer renderer, int x, int y, Meter meter, MeterEvent event) {
        int height = this.hud.settings.scale * (3 + this.hud.settings.hparity);
        if (this.hud.settings.rowHeight < height) {
            return;
        }
        int heightOffset = (this.hud.settings.rowHeight - height) / 2 + this.hud.settings.hparity;
        int x0 = x;
        int y0 = y + heightOffset;
        int x1 = x0 + this.hud.settings.columnWidth;
        int y1 = y0 + height;
        int color = this.hud.settings.colorBackground;
        renderer.fill(x0, y0, x1, y1, color);
    }

    protected void drawCenter(GuiRenderer renderer, int x, int y, Meter meter, MeterEvent event) {
        int height = this.hud.settings.scale * (1 + this.hud.settings.hparity);
        int heightOffset = (this.hud.settings.rowHeight - height) / 2 + this.hud.settings.hparity;
        int x0 = x;
        int y0 = y + heightOffset;
        int x1 = x0 + this.hud.settings.columnWidth;
        int y1 = y0 + height;
        int color = meter.getColor();
        renderer.fill(x0, y0, x1, y1, color);
    }
}

