/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.hud.event;

import redstone.multimeter.client.gui.GuiRenderer;
import redstone.multimeter.client.gui.hud.MultimeterHud;
import redstone.multimeter.client.gui.hud.event.BasicEventRenderer;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.common.meter.event.EventType;
import redstone.multimeter.common.meter.event.MeterEvent;

public class ScheduledEventRenderer
extends BasicEventRenderer {
    public ScheduledEventRenderer(MultimeterHud hud, EventType type) {
        super(hud);
        this.setType(type);
    }

    @Override
    protected void drawEdges(GuiRenderer renderer, int x, int y, Meter meter, MeterEvent event) {
        if (this.scheduling(event)) {
            int width = this.hud.settings.scale * (3 + this.hud.settings.wparity);
            int widthOffset = (this.hud.settings.columnWidth - width) / 2;
            int height = this.hud.settings.scale * (this.hud.settings.rowHeight / this.hud.settings.scale / 3 + 2);
            int heightOffset = (this.hud.settings.rowHeight - height) / 2 + this.hud.settings.hparity;
            if (this.hud.settings.columnWidth < width) {
                return;
            }
            int x0 = x + widthOffset;
            int y0 = y + heightOffset;
            int x1 = x0 + width;
            int y1 = y0 + height;
            int color = this.hud.settings.colorBackground;
            renderer.fill(x0, y0, x1, y1, color);
        } else {
            super.drawEdges(renderer, x, y, meter, event);
        }
    }

    @Override
    protected void drawCenter(GuiRenderer renderer, int x, int y, Meter meter, MeterEvent event) {
        if (this.scheduling(event)) {
            int width = this.hud.settings.scale * (1 + this.hud.settings.wparity);
            int widthOffset = (this.hud.settings.columnWidth - width) / 2;
            int height = this.hud.settings.scale * (this.hud.settings.rowHeight / this.hud.settings.scale / 3);
            int heightOffset = (this.hud.settings.rowHeight - height) / 2 + this.hud.settings.hparity;
            if (this.hud.settings.columnWidth < width) {
                return;
            }
            int x0 = x + widthOffset;
            int y0 = y + heightOffset;
            int x1 = x0 + width;
            int y1 = y0 + height;
            int color = meter.getColor();
            renderer.fill(x0, y0, x1, y1, color);
        } else {
            super.drawCenter(renderer, x, y, meter, event);
        }
    }

    protected boolean scheduling(MeterEvent event) {
        return event.getMetadata() >> 30 == 1;
    }
}

