/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.screen;

import java.util.List;
import java.util.Map;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_4966580;
import org.lwjgl.input.Keyboard;
import redstone.multimeter.client.gui.element.ScrollableList;
import redstone.multimeter.client.gui.element.button.BasicButton;
import redstone.multimeter.client.gui.element.option.OptionsCategoryElement;
import redstone.multimeter.client.gui.screen.DefaultMeterPropertiesScreen;
import redstone.multimeter.client.gui.screen.RSMMScreen;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.gui.tooltip.Tooltips;
import redstone.multimeter.client.option.Option;
import redstone.multimeter.client.option.Options;

public class OptionsScreen
extends RSMMScreen {
    public OptionsScreen() {
        super(Texts.literal("%s Options", "Redstone Multimeter"), true);
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        Options.validate();
        this.minecraft.f_9967940.m_2313216();
        Keyboard.enableRepeatEvents((boolean)false);
        this.client.getHud().optionsChanged();
    }

    @Override
    protected void initScreen() {
        Keyboard.enableRepeatEvents((boolean)true);
        ScrollableList list = new ScrollableList(this.getWidth(), this.getHeight(), 52, 36);
        list.setSpacing(20);
        list.setDrawBackground(true);
        list.setX(this.getX());
        list.setY(this.getY());
        int categoryWidth = list.getEffectiveWidth();
        for (Map.Entry<String, List<Option>> entry : Options.byCategory().entrySet()) {
            String category = entry.getKey();
            List<Option> options = entry.getValue();
            if ("rsmm.option.hidden".equals(category)) continue;
            list.add(new OptionsCategoryElement(categoryWidth, category, options));
        }
        int x = this.getX() + this.getWidth() / 2;
        int y = this.getY() + 22;
        BasicButton properties = new BasicButton(x - 154, y, 150, 20, () -> Texts.translatable("rsmm.gui.defaultMeterProperties.title"), Tooltips::empty, button -> {
            this.client.openScreen(new DefaultMeterPropertiesScreen());
            return true;
        });
        BasicButton controls = new BasicButton(x + 4, y, 150, 20, Texts::guiControls, Tooltips::empty, button -> {
            this.minecraft.m_6408915((C_3020744)new C_4966580((C_3020744)this.wrapper, this.minecraft.f_9967940));
            return true;
        });
        y = this.getY() + this.getHeight() - 28;
        BasicButton reset = new BasicButton(x - 154, y, 150, 20, Texts::guiControlsReset, Tooltips::empty, button -> {
            for (Option option : Options.all()) {
                option.reset();
            }
            this.update();
            return true;
        });
        BasicButton done = new BasicButton(x + 4, y, 150, 20, Texts::guiDone, Tooltips::empty, button -> {
            this.close();
            return true;
        });
        this.addChild(list);
        this.addChild(properties);
        this.addChild(controls);
        this.addChild(reset);
        this.addChild(done);
    }
}

