/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.screen;

import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_8105098;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.gui.FontRenderer;
import redstone.multimeter.client.gui.GuiRenderer;
import redstone.multimeter.client.gui.element.AbstractParentElement;
import redstone.multimeter.client.gui.screen.ScreenWrapper;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.texture.Textures;
import redstone.multimeter.client.gui.tooltip.Tooltip;

public abstract class RSMMScreen
extends AbstractParentElement {
    protected final MultimeterClient client = MultimeterClient.INSTANCE;
    protected final C_8105098 minecraft = MultimeterClient.MINECRAFT;
    protected final FontRenderer font = this.client.getFontRenderer();
    private final Text title;
    private final boolean drawTitle;
    protected ScreenWrapper wrapper;

    protected RSMMScreen(Text title, boolean drawTitle) {
        this.title = title;
        this.drawTitle = drawTitle;
    }

    @Override
    public void render(GuiRenderer renderer, int mouseX, int mouseY) {
        Tooltip tooltip;
        this.renderBackground(renderer);
        this.renderContent(renderer, mouseX, mouseY);
        if (this.drawTitle) {
            int width = this.font.width(this.title);
            int x = this.getX() + (this.getWidth() - width) / 2;
            int y = this.getY() + 6;
            this.font.drawWithShadow(this.title, x, y);
        }
        if (!(tooltip = this.getTooltip(mouseX, mouseY)).isEmpty()) {
            renderer.tooltip(tooltip, mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClick(double mouseX, double mouseY, int button) {
        return super.mouseClick(mouseX, mouseY, button) || this.client.getInputHandler().mouseClick(this, mouseX, mouseY, button);
    }

    @Override
    public boolean keyPress(int keyCode) {
        return super.keyPress(keyCode) || this.client.getInputHandler().keyPress(this, keyCode);
    }

    @Override
    public boolean mouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        return this.client.getInputHandler().mouseScroll(this, scrollX, scrollY) || super.mouseScroll(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    public final boolean isHovered() {
        return true;
    }

    @Override
    public final void setX(int x) {
    }

    @Override
    public final void setY(int y) {
    }

    public void init(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        this.removeChildren();
        this.initScreen();
        this.update();
        double mouseX = (double)Mouse.getX() * (double)width / (double)this.minecraft.f_0545414;
        double mouseY = (double)Mouse.getY() * (double)height / (double)this.minecraft.f_5990000;
        this.mouseMove(mouseX, mouseY);
    }

    protected abstract void initScreen();

    protected boolean shouldCloseOnEsc() {
        return true;
    }

    public void close() {
        this.minecraft.m_6408915(this.wrapper.getParent());
    }

    protected boolean hasTransparentBackground() {
        return this.minecraft.f_4601986 != null;
    }

    protected void renderBackground(GuiRenderer renderer) {
        if (this.hasTransparentBackground()) {
            renderer.gradient(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), -1072689136, -804253680);
        } else {
            int x0 = this.getX();
            int y0 = this.getY();
            int x1 = x0 + this.getWidth();
            int y1 = y0 + this.getHeight();
            int u0 = x0 / 2;
            int v0 = y0 / 2;
            int u1 = x1 / 2;
            int v1 = y1 / 2;
            renderer.blit(Textures.OPTIONS_BACKGROUND, x0, y0, x1, y1, u0, v0, u1, v1, -12566464);
        }
    }

    protected void renderContent(GuiRenderer renderer, int mouseX, int mouseY) {
        super.render(renderer, mouseX, mouseY);
    }

    public Text getTitle() {
        return this.title;
    }

    public boolean isPauseScreen() {
        return true;
    }

    public static boolean isAltDown() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }

    public static boolean isControlPressed() {
        return C_3020744.m_7566055() && !C_3020744.m_5142737() && !RSMMScreen.isAltDown();
    }
}

