/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.screen;

import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_8105098;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import redstone.multimeter.client.gui.GuiRenderer;
import redstone.multimeter.client.gui.screen.RSMMScreen;

public class ScreenWrapper
extends C_3020744 {
    private final C_3020744 parent;
    private final RSMMScreen screen;
    private double prevMouseX;
    private double prevMouseY;
    private double mouseX;
    private double mouseY;
    private int touchEvents;
    private int lastButton;
    private long lastClickTime;

    public ScreenWrapper(C_3020744 parent, RSMMScreen screen) {
        this.parent = parent;
        this.screen = screen;
        this.screen.wrapper = this;
    }

    public void m_7261014(int mouseX, int mouseY, float delta) {
        this.m_7546051();
        this.screen.render(new GuiRenderer(), mouseX, mouseY);
    }

    public final void m_3593494() {
        this.screen.init(this.f_5465691, this.f_3080061);
    }

    public void m_2450377() {
        this.screen.tick();
    }

    public void m_8984281() {
        this.screen.onRemoved();
    }

    public void m_3356138() {
        boolean consumed = false;
        this.prevMouseX = this.mouseX;
        this.prevMouseY = this.mouseY;
        this.mouseX = (double)Mouse.getEventX() * (double)this.f_5465691 / (double)this.f_7153641.f_0545414;
        this.mouseY = (double)(this.f_3080061 - 1) - (double)Mouse.getEventY() * (double)this.f_3080061 / (double)this.f_7153641.f_5990000;
        if (this.mouseX != this.prevMouseX || this.mouseY != this.prevMouseY) {
            this.screen.mouseMove(this.mouseX, this.mouseY);
        }
        int button = Mouse.getEventButton();
        if (Mouse.getEventButtonState()) {
            if (this.f_7153641.f_9967940.f_6270799 && this.touchEvents++ > 0) {
                return;
            }
            this.lastButton = button;
            this.lastClickTime = C_8105098.m_6224581();
            consumed = this.screen.mouseClick(this.mouseX, this.mouseY, button);
        } else if (button != -1) {
            if (this.f_7153641.f_9967940.f_6270799 && --this.touchEvents > 0) {
                return;
            }
            consumed = this.screen.mouseRelease(this.mouseX, this.mouseY, button);
            if (button == this.lastButton) {
                this.lastButton = -1;
            }
        } else if (this.lastButton != -1 && C_8105098.m_6224581() - this.lastClickTime > 0L) {
            double deltaX = this.mouseX - this.prevMouseX;
            double deltaY = this.mouseY - this.prevMouseY;
            consumed = this.screen.mouseDrag(this.mouseX, this.mouseY, this.lastButton, deltaX, deltaY);
        }
        double scrollY = 0.009 * (double)Mouse.getEventDWheel();
        if (scrollY != 0.0) {
            consumed = this.screen.mouseScroll(this.mouseX, this.mouseY, 0.0, scrollY);
        }
        if (consumed) {
            this.screen.mouseMove(this.mouseX, this.mouseY);
        }
    }

    public void m_7427265() {
        char chr = Keyboard.getEventCharacter();
        int key = Keyboard.getEventKey();
        boolean consumed = false;
        if (key != 0) {
            if (Keyboard.getEventKeyState()) {
                consumed = this.screen.keyPress(key);
                if (!consumed && key == 1) {
                    this.screen.close();
                }
            } else {
                consumed = this.screen.keyRelease(key);
            }
        }
        if (chr >= ' ') {
            consumed = this.screen.typeChar(chr);
        }
        if (consumed) {
            this.screen.mouseMove(this.mouseX, this.mouseY);
        }
    }

    public C_3020744 getParent() {
        return this.parent;
    }

    public RSMMScreen getScreen() {
        return this.screen;
    }
}

