/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.screen;

import redstone.multimeter.client.gui.element.Label;
import redstone.multimeter.client.gui.element.ScrollableList;
import redstone.multimeter.client.gui.element.SimpleList;
import redstone.multimeter.client.gui.element.button.BasicButton;
import redstone.multimeter.client.gui.screen.RSMMScreen;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.gui.tooltip.Tooltips;
import redstone.multimeter.common.TickPhaseTree;

public class TickPhaseTreeScreen
extends RSMMScreen {
    private TickPhaseTree tickPhaseTree;
    private long lastRequestTime;

    public TickPhaseTreeScreen() {
        super(Texts.translatable("rsmm.gui.tickPhases.title"), true);
        this.tickPhaseTree = this.client.getTickPhaseTree();
        this.lastRequestTime = -1L;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.lastRequestTime > 0L && System.currentTimeMillis() - this.lastRequestTime > 30000L) {
            this.request();
        }
    }

    @Override
    protected void initScreen() {
        this.lastRequestTime = -1L;
        if (!this.tickPhaseTree.isComplete()) {
            this.request();
            Text text = Texts.translatable("rsmm.gui.tickPhases.requesting");
            int x = this.getX() + (this.getWidth() - this.font.width(text)) / 2;
            int y = this.getY() + (this.getHeight() - this.font.height()) / 2;
            Label textElement = new Label(x, y, t -> t.addLine(text).setShadow(true), () -> {
                if (this.lastRequestTime > 0L) {
                    long time = System.currentTimeMillis();
                    long delta = (time - this.lastRequestTime) / 1000L;
                    return Tooltips.line(Texts.translatable("rsmm.gui.tickPhases.requesting.tooltip", delta));
                }
                return Tooltips.empty();
            }, t -> {
                this.request();
                return true;
            });
            x = this.getX() + (this.getWidth() - 150) / 2;
            y = this.getY() + this.getHeight() - 28;
            BasicButton done = new BasicButton(x + 4, y, 150, 20, Texts::guiDone, Tooltips::empty, button -> {
                this.close();
                return true;
            });
            this.addChild(textElement);
            this.addChild(done);
        } else {
            int top = 32;
            int bottom = 40;
            int x = this.getX();
            int y = this.getY();
            ScrollableList list = new ScrollableList(this.getWidth(), this.getHeight(), top, bottom);
            ((SimpleList)list).setDrawBackground(true);
            ((SimpleList)list).setX(x);
            ((SimpleList)list).setY(y);
            Label text = new Label(0, 0, t -> this.addTextForTickPhase((Label)t, this.tickPhaseTree.root, ""));
            list.add(text);
            x = this.getX() + this.getWidth() / 2;
            y = this.getY() + this.getHeight() - 28;
            BasicButton rebuild = new BasicButton(x - 154, y, 150, 20, () -> Texts.translatable("rsmm.gui.tickPhases.refresh"), Tooltips::empty, button -> {
                this.rebuild();
                return true;
            });
            BasicButton done = new BasicButton(x + 4, y, 150, 20, Texts::guiDone, Tooltips::empty, button -> {
                this.close();
                return true;
            });
            this.addChild(list);
            this.addChild(rebuild);
            this.addChild(done);
        }
    }

    @Override
    protected boolean hasTransparentBackground() {
        return false;
    }

    private void request() {
        this.client.requestTickPhaseTree();
        this.lastRequestTime = System.currentTimeMillis();
    }

    private void rebuild() {
        this.client.rebuildTickPhaseTree();
        this.close();
    }

    private void addTextForTickPhase(Label text, TickPhaseTree.Node node, String indent) {
        boolean root = node.parent == null;
        text.addLine(Texts.composite(indent + (root ? "" : "__"), node.task.getName(), " ", String.join((CharSequence)" ", node.args)));
        if (!root) {
            indent = indent + "   ";
        }
        indent = indent + "|";
        for (int index = 0; index < node.children.size(); ++index) {
            this.addTextForTickPhase(text, node.children.get(index), indent);
        }
    }

    public void refresh() {
        this.tickPhaseTree = this.client.getTickPhaseTree();
        this.init(this.getWidth(), this.getHeight());
    }
}

