/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.text;

import java.util.Objects;
import net.minecraft.unmapped.C_0149027;
import net.minecraft.unmapped.C_8529493;

public class ClickEvent {
    private final Action action;
    private final String value;

    private ClickEvent(Action action, String value) {
        this.action = action;
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClickEvent)) {
            return false;
        }
        ClickEvent event = (ClickEvent)o;
        return this.action == event.action && Objects.equals(this.value, event.value);
    }

    public Action getAction() {
        return this.action;
    }

    public String getValue() {
        return this.value;
    }

    public C_8529493 resolve() {
        switch (this.action.ordinal()) {
            case 0: {
                return new C_8529493(C_0149027.f_1413720, this.value);
            }
            case 1: {
                return new C_8529493(C_0149027.f_9481677, this.value);
            }
            case 2: {
                return new C_8529493(C_0149027.f_2090706, this.value);
            }
            case 3: {
                return null;
            }
        }
        throw new IllegalStateException("unable to resolve click event " + this.action.name());
    }

    public static ClickEvent resolve(C_8529493 clickEvent) {
        switch (clickEvent.m_5282441()) {
            case f_1413720: {
                return ClickEvent.openUrl(clickEvent.m_4139926());
            }
            case f_9481677: {
                return ClickEvent.runCommand(clickEvent.m_4139926());
            }
            case f_2090706: {
                return ClickEvent.suggestCommand(clickEvent.m_4139926());
            }
        }
        return null;
    }

    public static ClickEvent openUrl(String url) {
        return new ClickEvent(Action.OPEN_URL, url);
    }

    public static ClickEvent runCommand(String command) {
        return new ClickEvent(Action.RUN_COMMAND, command);
    }

    public static ClickEvent suggestCommand(String command) {
        return new ClickEvent(Action.SUGGEST_COMMAND, command);
    }

    public static ClickEvent copyToClipboard(String text) {
        return new ClickEvent(Action.COPY_TO_CLIPBOARD, text);
    }

    public static enum Action {
        OPEN_URL,
        RUN_COMMAND,
        SUGGEST_COMMAND,
        COPY_TO_CLIPBOARD;

    }
}

