/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.text;

import net.minecraft.unmapped.C_1160932;
import net.minecraft.unmapped.C_1331819;
import net.minecraft.unmapped.C_1716360;
import net.minecraft.unmapped.C_7778778;
import net.minecraft.unmapped.C_9550253;
import redstone.multimeter.client.gui.text.Formatting;
import redstone.multimeter.client.gui.text.LiteralText;
import redstone.multimeter.client.gui.text.Style;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.TranslatableText;

public class Texts {
    public static final Text MOD_NAME = Texts.literal("Redstone Multimeter");
    public static final Text GUI_DONE = Texts.translatable("gui.done");
    public static final Text GUI_CANCEL = Texts.translatable("gui.cancel");
    public static final Text GUI_CONTROLS = Texts.translatable("options.controls");
    public static final Text GUI_CONTROLS_RESET = Texts.translatable("controls.reset");
    public static final String ACTION_BAR_KEY = "rsmm:action_bar|";

    public static Text of(Object o) {
        if (o instanceof Text) {
            return (Text)o;
        }
        if (o instanceof C_9550253) {
            return Texts.resolve((C_9550253)o);
        }
        if (o instanceof String) {
            return Texts.resolve((String)o);
        }
        return Texts.literal(o.toString());
    }

    public static Text actionBar(Object t) {
        return Texts.literal(ACTION_BAR_KEY).append(Texts.of(t));
    }

    public static Text literal(String t) {
        return new LiteralText(t);
    }

    public static Text literal(String t, Object ... args) {
        return new LiteralText(String.format(t, args));
    }

    public static Text translatable(String t) {
        return new TranslatableText(t, new Object[0]);
    }

    public static Text translatable(String t, Object ... args) {
        return new TranslatableText(t, args);
    }

    public static Text composite(Object ... ts) {
        Text t = Texts.literal("");
        for (Object o : ts) {
            t.append(Texts.of(o));
        }
        return t;
    }

    public static Text modName() {
        return MOD_NAME;
    }

    public static Text guiDone() {
        return GUI_DONE;
    }

    public static Text guiCancel() {
        return GUI_CANCEL;
    }

    public static Text guiControls() {
        return GUI_CONTROLS;
    }

    public static Text guiControlsReset() {
        return GUI_CONTROLS_RESET;
    }

    public static Text keyValue(Object key, Object value) {
        return Texts.composite(Texts.composite(key, ": ").format(Formatting.GOLD), value);
    }

    public static Text keybinds(Object ... keybinds) {
        Text t = Texts.literal("");
        int i = 0;
        for (Object o : keybinds) {
            Text keybind = o instanceof C_7778778 ? Texts.keybind(true, (C_7778778)o) : (o instanceof Integer ? Texts.key((Integer)o) : (o instanceof Object[] ? Texts.keys(true, (Object[])o) : Texts.key(o)));
            if (keybind == null) continue;
            if (i++ > 0) {
                t.append(" OR ");
            }
            t.append(keybind);
        }
        if (i == 0) {
            t.append(Texts.composite("<", Texts.translatable("rsmm.keybind.unbound"), ">"));
        }
        return t;
    }

    public static Text keys(Object ... keys) {
        return Texts.keys(false, keys);
    }

    private static Text keys(boolean nullable, Object ... keys) {
        Text t = Texts.literal("");
        for (int i = 0; i < keys.length; ++i) {
            Object o = keys[i];
            Text key = o instanceof C_7778778 ? Texts.keybind(nullable, (C_7778778)o) : (o instanceof Integer ? Texts.key((Integer)o) : Texts.key(o));
            if (nullable && key == null) {
                return null;
            }
            if (i > 0) {
                t.append(" + ");
            }
            t.append(key);
        }
        return t;
    }

    public static Text keybind(C_7778778 keybind) {
        return Texts.keybind(false, keybind);
    }

    private static Text keybind(boolean nullable, C_7778778 keybind) {
        if (keybind.m_6463487() == 0) {
            if (nullable) {
                return null;
            }
            return Texts.composite("<", Texts.translatable("rsmm.keybind.unbound"), ">");
        }
        return Texts.key(keybind.m_6463487());
    }

    public static Text key(int key) {
        return Texts.key(C_1331819.m_9293214((int)key));
    }

    public static Text key(Object name) {
        return Texts.of(name).format(Formatting.YELLOW);
    }

    public static Text resolve(C_9550253 component) {
        Text t;
        if (component instanceof C_1716360) {
            t = Texts.literal(((C_1716360)component).m_0284473());
        } else if (component instanceof C_1160932) {
            C_1160932 translatable = (C_1160932)component;
            t = Texts.translatable(translatable.m_2010687(), translatable.m_7340073());
        } else {
            throw new IllegalStateException("cannot convert " + component + " to RSMM Text!");
        }
        t.format(Style.resolve(component.m_9212619()));
        for (Object sibling : component.m_7123482()) {
            t.append(Texts.resolve((C_9550253)sibling));
        }
        return t;
    }

    public static Text resolve(String fs) {
        Text t = Texts.literal("");
        Style s = Style.EMPTY;
        int from = 0;
        boolean lastWasFormattingPrefix = false;
        boolean lastWasFormatting = false;
        for (int to = 0; to < fs.length(); ++to) {
            boolean thisIsStringEnd;
            char chr = fs.charAt(to);
            boolean thisIsFormattingPrefix = chr == '\u00a7';
            boolean bl = thisIsStringEnd = to == fs.length() - 1;
            if (lastWasFormattingPrefix) {
                Formatting f = Formatting.byCode(chr);
                s = f == Formatting.RESET ? Style.EMPTY : s.applyFormattings(f);
                if (thisIsStringEnd) {
                    from = to;
                }
                lastWasFormattingPrefix = false;
                lastWasFormatting = true;
            } else if (thisIsFormattingPrefix) {
                lastWasFormattingPrefix = true;
                lastWasFormatting = false;
            } else {
                if (lastWasFormatting) {
                    from = to;
                }
                if (thisIsStringEnd) {
                    ++to;
                }
                lastWasFormattingPrefix = false;
                lastWasFormatting = false;
            }
            if (!thisIsFormattingPrefix && !thisIsStringEnd) continue;
            if (from != to) {
                t.append(Texts.literal(fs.substring(from, to)).format(s));
            }
            from = to;
        }
        return t;
    }
}

