/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.text;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.unmapped.C_1160932;
import net.minecraft.unmapped.C_4576025;
import net.minecraft.unmapped.C_9550253;
import redstone.multimeter.client.gui.text.BaseText;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.Texts;

public class TranslatableText
extends BaseText {
    private static final Pattern ARG_FORMAT = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");
    private final String key;
    private final Object[] args;
    private List<Text> resolved;
    private long resolvedLanguageLoadTimestamp;

    TranslatableText(String key, Object ... args) {
        this.key = key;
        this.args = args;
    }

    @Override
    void buildString(StringBuilder sb, boolean formatted) {
        long languageLoadTimestamp = C_4576025.m_3269011();
        if (this.resolved == null || this.resolvedLanguageLoadTimestamp != languageLoadTimestamp) {
            String translation = C_4576025.m_3547652((String)this.key);
            this.resolvedLanguageLoadTimestamp = languageLoadTimestamp;
            this.resolve(translation);
        }
        this.buildString(sb, formatted, this.resolved);
    }

    @Override
    C_9550253 buildText() {
        Object[] args = new Object[this.args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = this.args[i];
            if (arg instanceof Text) {
                arg = ((Text)arg).resolve();
            }
            args[i] = arg;
        }
        return new C_1160932(this.key, args);
    }

    private void resolve(String translation) {
        this.resolved = new ArrayList<Text>();
        Matcher matcher = ARG_FORMAT.matcher(translation);
        int nextArgIndex = 0;
        int nextCharIndex = 0;
        while (matcher.find(nextCharIndex)) {
            int matchStart = matcher.start();
            int matchEnd = matcher.end();
            if (matchStart > nextCharIndex) {
                this.resolved.add(Texts.literal(translation.substring(nextCharIndex, matchStart)));
            }
            String formatting = matcher.group(2);
            String partWithFormatting = translation.substring(matchStart, matchEnd);
            if ("%".equals(formatting) && "%%".equals(partWithFormatting)) {
                this.resolved.add(Texts.literal("%"));
            } else {
                int argIndex;
                if (!"s".equals(formatting)) {
                    throw new IllegalStateException("Unsupported format: '" + partWithFormatting + "'");
                }
                String matchedArgIndex = matcher.group(1);
                int n = argIndex = matchedArgIndex != null ? Integer.parseInt(matchedArgIndex) - 1 : nextArgIndex++;
                if (argIndex < this.args.length) {
                    this.resolved.add(this.resolveArg(argIndex));
                }
            }
            nextCharIndex = matchEnd;
        }
        if (nextCharIndex < translation.length()) {
            this.resolved.add(Texts.literal(translation.substring(nextCharIndex)));
        }
    }

    private Text resolveArg(int index) {
        if (index >= this.args.length) {
            throw new IndexOutOfBoundsException("arg " + index + " is out of bounds for 0-" + this.args.length);
        }
        Object arg = this.args[index];
        if (arg == null) {
            return Texts.literal("null");
        }
        return Texts.of(arg);
    }
}

