/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.meter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_1241852;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_5553933;
import net.minecraft.unmapped.C_7778778;
import net.minecraft.unmapped.C_8105098;
import redstone.multimeter.RedstoneMultimeterMod;
import redstone.multimeter.client.Keybinds;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.option.Options;
import redstone.multimeter.common.DimPos;
import redstone.multimeter.common.meter.ColorPicker;
import redstone.multimeter.common.meter.MeterProperties;
import redstone.multimeter.common.meter.MeterPropertiesManager;
import redstone.multimeter.common.meter.event.EventType;

public class ClientMeterPropertiesManager
extends MeterPropertiesManager {
    private static final String PROPERTIES_PATH = "meter/default_properties";
    private static final String RESOURCES_PATH = String.format("/assets/%s/%s", "redstone_multimeter", "meter/default_properties");
    private static final String FILE_EXTENSION = ".json";
    private static final String DEFAULT_KEY = "block";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final MultimeterClient client;
    private final Path dir;
    private final Map<C_0561170, MeterProperties> defaults;
    private final Map<C_0561170, MeterProperties> overrides;
    private final Map<C_0561170, MeterProperties> cache;

    public ClientMeterPropertiesManager(MultimeterClient client) {
        this.client = client;
        this.dir = this.client.getConfigDirectory().resolve(PROPERTIES_PATH);
        this.defaults = new HashMap<C_0561170, MeterProperties>();
        this.overrides = new HashMap<C_0561170, MeterProperties>();
        this.cache = new HashMap<C_0561170, MeterProperties>();
        this.initDefaults();
        if (!Files.exists(this.dir, new LinkOption[0])) {
            try {
                Files.createDirectories(this.dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("unable to create parent directories of meter properties file", e);
            }
        }
    }

    @Override
    protected C_5553933 getWorld(DimPos pos) {
        C_8105098 minecraft = this.client.getMinecraft();
        return pos.is((C_5553933)minecraft.f_4601986) ? minecraft.f_4601986 : null;
    }

    @Override
    protected void postValidation(MeterProperties.MutableMeterProperties properties, C_5553933 world, int x, int y, int z) {
        C_1241852 block = world.m_9893076(x, y, z);
        MeterProperties defaultProperties = this.getDefaultProperties(block);
        if (defaultProperties != null) {
            properties.fill(defaultProperties);
        }
        if (properties.getName() != null && ((Boolean)Options.RedstoneMultimeter.NUMBERED_NAMES.get()).booleanValue()) {
            String name = properties.getName();
            int number = this.client.getMeterGroup().getNextMeterIndex();
            properties.setName(String.format("%s %d", name, number));
        }
        if (properties.getColor() == null) {
            properties.setColor(((ColorPicker)Options.RedstoneMultimeter.COLOR_PICKER.get()).next());
        }
        if (((Boolean)Options.RedstoneMultimeter.SHIFTY_METERS.get()).booleanValue()) {
            properties.setMovable(!C_3020744.m_5142737());
        }
        for (int index = 0; index < EventType.ALL.length; ++index) {
            C_7778778 keybind = Keybinds.TOGGLE_EVENT_TYPES[index];
            if (!keybind.m_7042641()) continue;
            EventType type = EventType.ALL[index];
            properties.toggleEventType(type);
        }
        if (((Boolean)Options.RedstoneMultimeter.AUTO_RANDOM_TICKS.get()).booleanValue() && block.m_5805464() && !properties.hasEventType(EventType.RANDOM_TICK)) {
            properties.toggleEventType(EventType.RANDOM_TICK);
        }
    }

    public Map<C_0561170, MeterProperties> getDefaults() {
        return Collections.unmodifiableMap(this.defaults);
    }

    public Map<C_0561170, MeterProperties> getOverrides() {
        return Collections.unmodifiableMap(this.overrides);
    }

    public <T extends MeterProperties> void update(Map<C_0561170, T> newOverrides) {
        HashMap<C_0561170, MeterProperties> prev = new HashMap<C_0561170, MeterProperties>(this.overrides);
        this.overrides.clear();
        this.cache.clear();
        for (Map.Entry<C_0561170, T> entry : newOverrides.entrySet()) {
            C_0561170 key = entry.getKey();
            MeterProperties properties = (MeterProperties)entry.getValue();
            prev.remove(key);
            this.overrides.put(key, properties.immutable());
        }
        this.save();
        for (C_0561170 key : prev.keySet()) {
            this.deleteOverrideFile(key);
        }
    }

    public MeterProperties getDefaultProperties(C_1241852 block) {
        String id = C_1241852.f_7235510.m_1232808((Object)block);
        if (id == null) {
            return null;
        }
        C_0561170 key = new C_0561170(id);
        return this.cache.computeIfAbsent(key, _key -> {
            String namespace = key.m_1302635();
            C_0561170 defaultKey = new C_0561170(namespace, DEFAULT_KEY);
            return new MeterProperties.MutableMeterProperties().fill(this.overrides.get(key)).fill(this.defaults.get(key)).fill(this.overrides.get(defaultKey)).fill(this.defaults.get(defaultKey)).immutable();
        });
    }

    private void initDefaults() {
        HashSet<String> namespaces = new HashSet<String>();
        for (String id : C_1241852.f_7235510.m_6106460()) {
            C_0561170 key = new C_0561170(id);
            this.loadDefaultProperties(key);
            if (!namespaces.add(key.m_1302635())) continue;
            this.loadDefaultProperties(new C_0561170(key.m_1302635(), DEFAULT_KEY));
        }
    }

    private void loadDefaultProperties(C_0561170 key) {
        String path = String.format("%s/%s/%s%s", RESOURCES_PATH, key.m_1302635(), key.m_8655655(), FILE_EXTENSION);
        InputStream resource = this.getClass().getResourceAsStream(path);
        if (resource == null) {
            return;
        }
        try (InputStreamReader isr = new InputStreamReader(resource);){
            ClientMeterPropertiesManager.loadProperties(this.defaults, key, isr);
        }
        catch (JsonIOException | JsonSyntaxException | IOException e) {
            RedstoneMultimeterMod.LOGGER.warn("exception while loading default meter properties", e);
        }
    }

    public void reload() {
        this.overrides.clear();
        this.cache.clear();
        try {
            for (Path dirForNamespace : Files.newDirectoryStream(this.dir, f -> Files.isDirectory(f, new LinkOption[0]))) {
                String namespace = dirForNamespace.getFileName().toString();
                for (Path file : Files.newDirectoryStream(dirForNamespace, f -> Files.isRegularFile(f, new LinkOption[0]))) {
                    this.loadUserOverrides(namespace, file);
                }
            }
        }
        catch (Exception e) {
            RedstoneMultimeterMod.LOGGER.warn("exception while reloading meter properties", (Throwable)e);
        }
    }

    private void loadUserOverrides(String namespace, Path file) throws Exception {
        String path = file.getFileName().toString();
        if (!path.endsWith(FILE_EXTENSION)) {
            return;
        }
        path = path.substring(0, path.length() - FILE_EXTENSION.length());
        try (BufferedReader br = Files.newBufferedReader(file);){
            ClientMeterPropertiesManager.loadProperties(this.overrides, new C_0561170(namespace, path), br);
        }
    }

    private static void loadProperties(Map<C_0561170, MeterProperties> map, C_0561170 key, Reader reader) {
        JsonElement rawJson = (JsonElement)GSON.fromJson(reader, JsonElement.class);
        if (rawJson.isJsonObject()) {
            JsonObject json = rawJson.getAsJsonObject();
            MeterProperties properties = MeterProperties.fromJson(json);
            map.put(key, properties);
        }
    }

    public void save() {
        try {
            for (Map.Entry<C_0561170, MeterProperties> entry : this.overrides.entrySet()) {
                C_0561170 key = entry.getKey();
                MeterProperties properties = entry.getValue();
                this.saveUserOverrides(key, properties);
            }
        }
        catch (Exception e) {
            RedstoneMultimeterMod.LOGGER.warn("exception while saving meter properties", (Throwable)e);
        }
    }

    private void saveUserOverrides(C_0561170 key, MeterProperties properties) throws Exception {
        String namespace = key.m_1302635();
        String path = key.m_8655655();
        Path dirForNamespace = this.dir.resolve(namespace);
        if (!Files.exists(dirForNamespace, new LinkOption[0])) {
            Files.createDirectories(dirForNamespace, new FileAttribute[0]);
        }
        if (!Files.isDirectory(dirForNamespace, new LinkOption[0])) {
            throw new IOException("Unable to save properties for '" + key.toString() + "' - the '" + namespace + "' folder does not exist and cannot be created!");
        }
        Path file = dirForNamespace.resolve(String.format("%s%s", path, FILE_EXTENSION));
        if (Files.exists(file, new LinkOption[0]) && !Files.isRegularFile(file, new LinkOption[0])) {
            RedstoneMultimeterMod.LOGGER.warn("Unable to save properties for '" + key.toString() + "' - the '" + path + "' file does not exist and cannot be created!");
            return;
        }
        JsonObject json = properties.toJson();
        try (BufferedWriter bw = Files.newBufferedWriter(file, new OpenOption[0]);){
            bw.write(GSON.toJson((JsonElement)json));
        }
    }

    private void deleteOverrideFile(C_0561170 key) {
        String namespace = key.m_1302635();
        String path = key.m_8655655();
        try {
            Path folder = this.dir.resolve(namespace);
            Path file = folder.resolve(String.format("%s%s", path, FILE_EXTENSION));
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            RedstoneMultimeterMod.LOGGER.warn("exception while deleting meter properties override file", (Throwable)e);
        }
    }
}

