/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.render;

import net.minecraft.unmapped.C_3362006;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_5553933;
import net.minecraft.unmapped.C_5786166;
import net.minecraft.unmapped.C_6607881;
import net.minecraft.unmapped.C_8105098;
import org.lwjgl.opengl.GL11;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.meter.ClientMeterGroup;
import redstone.multimeter.client.option.Options;
import redstone.multimeter.client.render.MeterNameMode;
import redstone.multimeter.common.DimPos;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.util.ColorUtils;

public class MeterRenderer {
    private final MultimeterClient client;
    private final C_8105098 minecraft;

    public MeterRenderer(MultimeterClient client) {
        this.client = client;
        this.minecraft = this.client.getMinecraft();
    }

    public void renderMeters(float tickDelta) {
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2884);
        this.renderMeters(this::renderMeterHighlight, tickDelta);
    }

    public void renderMeterNameTags(float tickDelta) {
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3553);
        MeterNameMode mode = (MeterNameMode)Options.RedstoneMultimeter.RENDER_METER_NAMES.get();
        if (mode == MeterNameMode.ALWAYS || mode == MeterNameMode.WHEN_PREVIEWING && this.client.isPreviewing() || mode == MeterNameMode.IN_FOCUS_MODE && this.client.getHud().isFocusMode() && !this.client.isPreviewing()) {
            this.renderMeters(this::renderMeterNameTag, tickDelta);
        }
        GL11.glEnable((int)2929);
    }

    private void renderMeters(MeterPartRenderer renderer, float tickDelta) {
        if (this.client.isPreviewing() || !this.client.getHud().isFocusMode()) {
            ClientMeterGroup meterGroup = this.client.isPreviewing() ? this.client.getMeterGroupPreview() : this.client.getMeterGroup();
            for (Meter meter : meterGroup.getMeters()) {
                if (!meter.isIn((C_5553933)this.minecraft.f_4601986)) continue;
                renderer.render(meter, tickDelta);
            }
        } else {
            Meter focussed = this.client.getHud().getFocussedMeter();
            if (focussed != null && focussed.isIn((C_5553933)this.minecraft.f_4601986)) {
                renderer.render(focussed, tickDelta);
            }
        }
    }

    private void renderMeterHighlight(Meter meter, float tickDelta) {
        C_5786166 bufferBuilder = C_5786166.f_7436514;
        DimPos pos = meter.getPos();
        int color = meter.getColor();
        boolean movable = meter.isMovable();
        C_6607881 camera = this.minecraft.f_2096674;
        double cameraX = camera.f_7928345 + (camera.f_6638345 - camera.f_7928345) * (double)tickDelta;
        double cameraY = camera.f_6367672 + (camera.f_1187082 - camera.f_6367672) * (double)tickDelta;
        double cameraZ = camera.f_5666338 + (camera.f_9103758 - camera.f_5666338) * (double)tickDelta;
        double dx = (double)pos.getX() - cameraX;
        double dy = (double)pos.getY() - cameraY;
        double dz = (double)pos.getZ() - cameraZ;
        GL11.glPushMatrix();
        GL11.glTranslated((double)dx, (double)dy, (double)dz);
        float r = (float)ColorUtils.getRed(color) / 255.0f;
        float g = (float)ColorUtils.getGreen(color) / 255.0f;
        float b = (float)ColorUtils.getBlue(color) / 255.0f;
        this.renderMeterHighlight(bufferBuilder, r, g, b, 0.5f);
        if (movable) {
            this.renderMeterOutline(bufferBuilder, r, g, b, 1.0f);
        }
        GL11.glPopMatrix();
    }

    private void renderMeterNameTag(Meter meter, float tickDelta) {
        int range;
        double rangeSquared;
        double dz;
        double dy;
        String name = meter.getName();
        DimPos pos = meter.getPos();
        C_6607881 camera = this.minecraft.f_2096674;
        double cameraX = camera.f_7928345 + (camera.f_6638345 - camera.f_7928345) * (double)tickDelta;
        double cameraY = camera.f_6367672 + (camera.f_1187082 - camera.f_6367672) * (double)tickDelta;
        double cameraZ = camera.f_5666338 + (camera.f_9103758 - camera.f_5666338) * (double)tickDelta;
        double dx = (double)pos.getX() - cameraX;
        double distanceSquared = dx * dx + (dy = (double)pos.getY() - cameraY) * dy + (dz = (double)pos.getZ() - cameraZ) * dz;
        if (distanceSquared < (rangeSquared = (double)((range = ((Integer)Options.RedstoneMultimeter.METER_NAME_RANGE.get()).intValue()) * range))) {
            this.renderNameTag(this.minecraft.f_0426313, name, dx + 0.5, dy + 0.75, dz + 0.5);
        }
    }

    private void renderMeterHighlight(C_5786166 bufferBuilder, float r, float g, float b, float a) {
        bufferBuilder.m_0346438(7);
        this.drawBox(bufferBuilder, r, g, b, a, false);
        bufferBuilder.m_7459300();
    }

    private void renderMeterOutline(C_5786166 bufferBuilder, float r, float g, float b, float a) {
        bufferBuilder.m_0346438(1);
        this.drawBox(bufferBuilder, r, g, b, a, true);
        bufferBuilder.m_7459300();
    }

    private void drawBox(C_5786166 buffer, float r, float g, float b, float a, boolean outline) {
        float c0 = -0.002f;
        float c1 = 1.002f;
        buffer.m_4553900(r, g, b, a);
        buffer.m_4415074((double)c0, (double)c0, (double)c0);
        buffer.m_4415074((double)c0, (double)c0, (double)c1);
        buffer.m_4415074((double)c0, (double)c1, (double)c1);
        buffer.m_4415074((double)c0, (double)c1, (double)c0);
        if (outline) {
            buffer.m_4415074((double)c0, (double)c0, (double)c0);
        }
        buffer.m_4415074((double)c1, (double)c0, (double)c0);
        buffer.m_4415074((double)c1, (double)c1, (double)c0);
        buffer.m_4415074((double)c1, (double)c1, (double)c1);
        buffer.m_4415074((double)c1, (double)c0, (double)c1);
        if (outline) {
            buffer.m_4415074((double)c1, (double)c0, (double)c0);
        }
        buffer.m_4415074((double)c0, (double)c0, (double)c0);
        buffer.m_4415074((double)c0, (double)c1, (double)c0);
        buffer.m_4415074((double)c1, (double)c1, (double)c0);
        buffer.m_4415074((double)c1, (double)c0, (double)c0);
        if (outline) {
            buffer.m_4415074((double)c0, (double)c0, (double)c0);
        }
        buffer.m_4415074((double)c0, (double)c0, (double)c1);
        buffer.m_4415074((double)c1, (double)c0, (double)c1);
        buffer.m_4415074((double)c1, (double)c1, (double)c1);
        buffer.m_4415074((double)c0, (double)c1, (double)c1);
        if (outline) {
            buffer.m_4415074((double)c0, (double)c0, (double)c1);
        }
        buffer.m_4415074((double)c0, (double)c0, (double)c0);
        buffer.m_4415074((double)c1, (double)c0, (double)c0);
        buffer.m_4415074((double)c1, (double)c0, (double)c1);
        buffer.m_4415074((double)c0, (double)c0, (double)c1);
        if (outline) {
            buffer.m_4415074((double)c0, (double)c0, (double)c0);
        }
        buffer.m_4415074((double)c0, (double)c1, (double)c0);
        buffer.m_4415074((double)c0, (double)c1, (double)c1);
        buffer.m_4415074((double)c1, (double)c1, (double)c1);
        buffer.m_4415074((double)c1, (double)c1, (double)c0);
        if (outline) {
            buffer.m_4415074((double)c0, (double)c1, (double)c0);
        }
    }

    private void renderNameTag(C_3831727 textRenderer, String name, double dx, double dy, double dz) {
        C_3362006 entityRenderDispatcher = C_3362006.f_9792930;
        float yaw = entityRenderDispatcher.f_5107786;
        float pitch = entityRenderDispatcher.f_2592027;
        GL11.glPushMatrix();
        GL11.glTranslated((double)dx, (double)dy, (double)dz);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.025f, (float)-0.025f, (float)0.025f);
        textRenderer.m_4683674(name, -textRenderer.m_0040387(name) / 2, 0, -1);
        GL11.glPopMatrix();
    }

    @FunctionalInterface
    private static interface MeterPartRenderer {
        public void render(Meter var1, float var2);
    }
}

