/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.tutorial;

import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_8105098;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.gui.screen.RSMMScreen;
import redstone.multimeter.client.option.Options;
import redstone.multimeter.client.tutorial.TutorialListener;
import redstone.multimeter.client.tutorial.TutorialStep;
import redstone.multimeter.client.tutorial.instance.TutorialInstance;
import redstone.multimeter.common.DimPos;
import redstone.multimeter.common.meter.Meter;

public class Tutorial
implements TutorialListener {
    private static final int MAX_TIME = 3600;
    private static final int COOLDOWN = 24;
    private final C_8105098 minecraft;
    private final MultimeterClient client;
    private TutorialInstance instance;
    private int time;
    private int cooldown;

    public Tutorial(MultimeterClient client) {
        this.minecraft = client.getMinecraft();
        this.client = client;
        this.cooldown = 120;
    }

    public C_8105098 getMinecraft() {
        return this.minecraft;
    }

    public MultimeterClient getClient() {
        return this.client;
    }

    @Override
    public void onScreenOpened(C_3020744 screen) {
        if (this.instance != null && !this.instance.isCompleted()) {
            this.instance.onScreenOpened(screen);
        }
    }

    @Override
    public void onScreenOpened(RSMMScreen screen) {
        if (this.instance != null && !this.instance.isCompleted()) {
            this.instance.onScreenOpened(screen);
        }
    }

    @Override
    public void onToggleHud(boolean enabled) {
        if (this.instance != null && !this.instance.isCompleted()) {
            this.instance.onToggleHud(enabled);
        }
    }

    @Override
    public void onPauseHud(boolean paused) {
        if (this.instance != null && !this.instance.isCompleted()) {
            this.instance.onPauseHud(paused);
        }
    }

    @Override
    public void onScrollHud(int amount) {
        if (this.instance != null && !this.instance.isCompleted()) {
            this.instance.onScrollHud(amount);
        }
    }

    @Override
    public void onMeterControlsOpened() {
        if (this.instance != null && !this.instance.isCompleted()) {
            this.instance.onMeterControlsOpened();
        }
    }

    @Override
    public void onJoinMeterGroup() {
        if (this.instance != null && !this.instance.isCompleted()) {
            this.instance.onJoinMeterGroup();
        }
    }

    @Override
    public void onLeaveMeterGroup() {
        if (this.instance != null && !this.instance.isCompleted()) {
            this.instance.onLeaveMeterGroup();
        }
    }

    @Override
    public void onMeterGroupRefreshed() {
        if (this.instance != null && !this.instance.isCompleted()) {
            this.instance.onMeterGroupRefreshed();
        }
    }

    @Override
    public void onMeterAddRequested(DimPos pos) {
        if (this.instance != null && !this.instance.isCompleted()) {
            this.instance.onMeterAddRequested(pos);
        }
    }

    @Override
    public void onMeterAdded(Meter meter) {
        if (this.instance != null && !this.instance.isCompleted()) {
            this.instance.onMeterAdded(meter);
        }
    }

    @Override
    public void onMeterRemoveRequested(DimPos pos) {
        if (this.instance != null && !this.instance.isCompleted()) {
            this.instance.onMeterRemoveRequested(pos);
        }
    }

    @Override
    public void onMeterRemoved(Meter meter) {
        if (this.instance != null && !this.instance.isCompleted()) {
            this.instance.onMeterRemoved(meter);
        }
    }

    public void tick() {
        if (this.canDoTutorial()) {
            if (this.instance == null) {
                if (this.cooldown < 0) {
                    this.start();
                } else {
                    --this.cooldown;
                }
            } else if (this.instance.isCompleted()) {
                TutorialStep nextStep = this.instance.getNextStep();
                if (nextStep != null) {
                    this.advance(nextStep);
                }
            } else if (this.time++ > 3600) {
                this.advance(TutorialStep.NONE);
            } else {
                this.instance.tick();
            }
        } else {
            this.stop();
        }
    }

    public void reset() {
        this.advance((TutorialStep)Options.Hidden.TUTORIAL_STEP.getDefault());
    }

    public void advance(TutorialStep step) {
        if (step == Options.Hidden.TUTORIAL_STEP.get()) {
            return;
        }
        Options.Hidden.TUTORIAL_STEP.set(step);
        Options.validate();
        this.minecraft.f_9967940.m_2313216();
        this.stop();
    }

    private boolean canDoTutorial() {
        return false;
    }

    private void start() {
        this.stop();
        this.instance = ((TutorialStep)Options.Hidden.TUTORIAL_STEP.get()).createInstance(this);
        this.instance.start();
        this.time = 0;
    }

    private void stop() {
        if (this.instance != null) {
            this.instance.stop();
            this.instance = null;
            this.time = -1;
            this.cooldown = 24;
        }
    }
}

