/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.tutorial.instance;

import net.minecraft.unmapped.C_2270380;
import net.minecraft.unmapped.C_3628668;
import redstone.multimeter.client.Keybinds;
import redstone.multimeter.client.gui.element.tutorial.StagedTutorialToast;
import redstone.multimeter.client.gui.element.tutorial.TutorialToast;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.meter.ClientMeterGroup;
import redstone.multimeter.client.tutorial.Tutorial;
import redstone.multimeter.client.tutorial.TutorialStep;
import redstone.multimeter.client.tutorial.instance.StagedTutorialInstance;
import redstone.multimeter.common.DimPos;
import redstone.multimeter.common.meter.Meter;

public class PlaceMeterTutorial
extends StagedTutorialInstance {
    private Stage stage;
    private DimPos lastRequest;

    public PlaceMeterTutorial(Tutorial tutorial) {
        super(tutorial);
        this.findStage();
    }

    @Override
    protected C_2270380 createAchievement() {
        return new C_2270380("stats.rsmm.place_meter", "rsmm.place_meter", -1, -1, C_3628668.f_5944942, null);
    }

    protected TutorialToast createToast() {
        return new StagedTutorialToast(this, TutorialStep.PLACE_METER.getName(), TutorialStep.PLACE_METER.getDescription(Texts.keybind(Keybinds.TOGGLE_METER)));
    }

    @Override
    public void onJoinMeterGroup() {
        if (this.stage == Stage.JOIN_METER_GROUP) {
            this.findStage();
        }
    }

    @Override
    public void onLeaveMeterGroup() {
        this.findStage();
    }

    @Override
    public void onMeterGroupRefreshed() {
        this.findStage();
    }

    @Override
    public void onMeterAddRequested(DimPos pos) {
        if (this.stage == Stage.ADD_METER) {
            this.lastRequest = pos;
        }
    }

    @Override
    public void onMeterAdded(Meter meter) {
        if (this.stage == Stage.ADD_METER && meter.getPos().equals(this.lastRequest)) {
            this.lastRequest = null;
            this.completed = true;
        }
    }

    @Override
    public void tick() {
    }

    @Override
    public TutorialStep getNextStep() {
        return TutorialStep.PAUSE_TIMELINE;
    }

    @Override
    public float getProgress() {
        return this.completed ? 1.0f : (float)this.stage.ordinal() / 2.0f;
    }

    private void findStage() {
        ClientMeterGroup meterGroup = this.tutorial.getClient().getMeterGroup();
        this.stage = !meterGroup.isSubscribed() ? Stage.JOIN_METER_GROUP : Stage.ADD_METER;
        this.lastRequest = null;
    }

    public static enum Stage {
        JOIN_METER_GROUP,
        ADD_METER;

    }
}

