/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.tutorial.instance;

import net.minecraft.unmapped.C_2270380;
import net.minecraft.unmapped.C_3628668;
import redstone.multimeter.client.Keybinds;
import redstone.multimeter.client.gui.element.tutorial.StagedTutorialToast;
import redstone.multimeter.client.gui.element.tutorial.TutorialToast;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.meter.ClientMeterGroup;
import redstone.multimeter.client.tutorial.Tutorial;
import redstone.multimeter.client.tutorial.TutorialStep;
import redstone.multimeter.client.tutorial.instance.StagedTutorialInstance;
import redstone.multimeter.common.DimPos;
import redstone.multimeter.common.meter.Meter;

public class RemoveMeterTutorial
extends StagedTutorialInstance {
    private Stage stage;
    private DimPos lastRequest;

    public RemoveMeterTutorial(Tutorial tutorial) {
        super(tutorial);
        this.findStage();
    }

    @Override
    protected C_2270380 createAchievement() {
        return new C_2270380("stats.rsmm.remove_meter", "rsmm.remove_meter", -1, -1, C_3628668.f_5944942, null);
    }

    protected TutorialToast createToast() {
        return new StagedTutorialToast(this, TutorialStep.REMOVE_METER.getName(), TutorialStep.REMOVE_METER.getDescription(Texts.keybind(Keybinds.TOGGLE_METER)));
    }

    @Override
    public void onJoinMeterGroup() {
        if (this.stage == Stage.JOIN_METER_GROUP) {
            this.findStage();
        }
    }

    @Override
    public void onLeaveMeterGroup() {
        this.findStage();
    }

    @Override
    public void onMeterGroupRefreshed() {
        this.findStage();
    }

    @Override
    public void onMeterAdded(Meter meter) {
        if (this.stage == Stage.ADD_METER) {
            this.findStage();
        }
    }

    @Override
    public void onMeterRemoveRequested(DimPos pos) {
        if (this.stage == Stage.REMOVE_METER) {
            this.lastRequest = pos;
        }
    }

    @Override
    public void onMeterRemoved(Meter meter) {
        if (this.stage == Stage.REMOVE_METER && meter.getPos().equals(this.lastRequest)) {
            this.lastRequest = null;
            this.completed = true;
        }
    }

    @Override
    public void tick() {
    }

    @Override
    public TutorialStep getNextStep() {
        return TutorialStep.NONE;
    }

    @Override
    public float getProgress() {
        return this.completed ? 1.0f : (float)this.stage.ordinal() / 3.0f;
    }

    private void findStage() {
        ClientMeterGroup meterGroup = this.tutorial.getClient().getMeterGroup();
        this.stage = !meterGroup.isSubscribed() ? Stage.JOIN_METER_GROUP : (!meterGroup.hasMeters() ? Stage.ADD_METER : Stage.REMOVE_METER);
        this.lastRequest = null;
    }

    public static enum Stage {
        JOIN_METER_GROUP,
        ADD_METER,
        REMOVE_METER;

    }
}

