/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.server.MinecraftServer;
import net.minecraft.unmapped.C_1730529;
import net.minecraft.unmapped.C_2691400;
import net.minecraft.unmapped.C_3292284;
import net.minecraft.unmapped.C_5100287;
import net.minecraft.unmapped.C_5917668;
import net.minecraft.unmapped.C_7238350;
import net.minecraft.unmapped.C_8003398;
import net.minecraft.unmapped.C_8433864;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.common.meter.MeterGroup;
import redstone.multimeter.interfaces.mixin.IMinecraftServer;
import redstone.multimeter.server.Multimeter;
import redstone.multimeter.server.MultimeterServer;
import redstone.multimeter.server.meter.ServerMeterGroup;

public class MeterGroupCommand
extends C_5917668 {
    private static final String COMMAND_NAME = "metergroup";
    private static final String USAGE_LIST = MeterGroupCommand.singleUsage("list");
    private static final String USAGE_SUBSCRIBE_DEFAULT = MeterGroupCommand.singleUsage("subscribe");
    private static final String USAGE_SUBSCRIBE_NAME = MeterGroupCommand.singleUsage("subscribe <name>");
    private static final String USAGE_SUBSCRIBE = MeterGroupCommand.buildUsage(USAGE_SUBSCRIBE_DEFAULT, USAGE_SUBSCRIBE_NAME);
    private static final String USAGE_UNSUBSCRIBE = MeterGroupCommand.singleUsage("unsubscribe");
    private static final String USAGE_PRIVATE_QUERY = MeterGroupCommand.singleUsage("private");
    private static final String USAGE_PRIVATE_SET = MeterGroupCommand.singleUsage("private <private true|false>");
    private static final String USAGE_PRIVATE = MeterGroupCommand.buildUsage(USAGE_PRIVATE_QUERY, USAGE_PRIVATE_SET);
    private static final String USAGE_MEMBERS_LIST = MeterGroupCommand.singleUsage("members list");
    private static final String USAGE_MEMBERS_ADD = MeterGroupCommand.singleUsage("members add <player>");
    private static final String USAGE_MEMBERS_REMOVE = MeterGroupCommand.singleUsage("members remove <player>");
    private static final String USAGE_MEMBERS_CLEAR = MeterGroupCommand.singleUsage("members clear");
    private static final String USAGE_MEMBERS = MeterGroupCommand.buildUsage(USAGE_MEMBERS_LIST, USAGE_MEMBERS_ADD, USAGE_MEMBERS_REMOVE, USAGE_MEMBERS_CLEAR);
    private static final String USAGE_CLEAR = MeterGroupCommand.singleUsage("clear");
    private static final String TOTAL_USAGE_MEMBER = MeterGroupCommand.buildUsage(USAGE_LIST, USAGE_SUBSCRIBE, USAGE_UNSUBSCRIBE, USAGE_CLEAR);
    private static final String TOTAL_USAGE_OWNER = MeterGroupCommand.buildUsage(USAGE_LIST, USAGE_SUBSCRIBE, USAGE_UNSUBSCRIBE, USAGE_PRIVATE, USAGE_MEMBERS, USAGE_CLEAR);
    private final MultimeterServer server;
    private final Multimeter multimeter;

    private static String singleUsage(String usage) {
        return String.format("/%s %s", COMMAND_NAME, usage);
    }

    private static String buildUsage(String ... usages) {
        return String.join((CharSequence)" OR ", usages);
    }

    public MeterGroupCommand(MinecraftServer server) {
        this.server = ((IMinecraftServer)server).getMultimeterServer();
        this.multimeter = this.server.getMultimeter();
    }

    public int compareTo(Object o) {
        return this.m_5227702((C_8433864)o);
    }

    public String m_2274818() {
        return COMMAND_NAME;
    }

    public String m_5298415(C_1730529 source) {
        return this.isOwnerOfSubscription(source) ? TOTAL_USAGE_OWNER : TOTAL_USAGE_MEMBER;
    }

    public List<String> m_0376737(C_1730529 source, String[] args) {
        boolean isOwner = this.isOwnerOfSubscription(source);
        switch (args.length) {
            case 1: {
                if (isOwner) {
                    return MeterGroupCommand.m_4910259((String[])args, (String[])new String[]{"clear", "subscribe", "unsubscribe", "private", "members", "list"});
                }
                return MeterGroupCommand.m_4910259((String[])args, (String[])new String[]{"clear", "subscribe", "unsubscribe", "list"});
            }
            case 2: {
                switch (args[0]) {
                    case "subscribe": {
                        return MeterGroupCommand.m_5579985((String[])args, this.listMeterGroups(source));
                    }
                    case "private": {
                        if (!isOwner) break;
                        return MeterGroupCommand.m_4910259((String[])args, (String[])new String[]{"true", "false"});
                    }
                    case "members": {
                        if (!isOwner) break;
                        return MeterGroupCommand.m_4910259((String[])args, (String[])new String[]{"clear", "add", "remove", "list"});
                    }
                }
                break;
            }
            case 3: {
                if (!isOwner || !args[0].equals("members")) break;
                switch (args[1]) {
                    case "add": {
                        return MeterGroupCommand.m_4910259((String[])args, (String[])this.server.getMinecraftServer().m_6773955());
                    }
                    case "remove": {
                        return MeterGroupCommand.m_5579985((String[])args, this.listMembers(source).keySet());
                    }
                }
            }
        }
        return Collections.emptyList();
    }

    public void m_2644869(C_1730529 source, String[] args) throws C_8003398 {
        if (!this.isMultimeterClient(source)) {
            throw new C_2691400();
        }
        if (args.length > 0) {
            switch (args[0]) {
                case "list": {
                    if (args.length == 1) {
                        this.list(source);
                        return;
                    }
                    throw new C_7238350(USAGE_LIST, new Object[0]);
                }
                case "subscribe": {
                    if (args.length == 1) {
                        this.subscribe(source, null);
                        return;
                    }
                    String name = "";
                    for (int index = 1; index < args.length; ++index) {
                        name = name + args[index] + " ";
                    }
                    this.subscribe(source, name);
                    return;
                }
                case "unsubscribe": {
                    if (args.length == 1) {
                        this.unsubscribe(source);
                        return;
                    }
                    throw new C_7238350(USAGE_UNSUBSCRIBE, new Object[0]);
                }
                case "private": {
                    if (!this.isOwnerOfSubscription(source)) break;
                    switch (args.length) {
                        case 1: {
                            this.queryPrivate(source);
                            return;
                        }
                        case 2: {
                            switch (args[1]) {
                                case "true": {
                                    this.setPrivate(source, true);
                                    return;
                                }
                                case "false": {
                                    this.setPrivate(source, false);
                                    return;
                                }
                            }
                            throw new C_7238350(USAGE_PRIVATE_SET, new Object[0]);
                        }
                    }
                    throw new C_7238350(USAGE_PRIVATE, new Object[0]);
                }
                case "members": {
                    if (!this.isOwnerOfSubscription(source)) break;
                    if (args.length > 1) {
                        switch (args[1]) {
                            case "list": {
                                if (args.length == 2) {
                                    this.membersList(source);
                                    return;
                                }
                                throw new C_7238350(USAGE_MEMBERS_LIST, new Object[0]);
                            }
                            case "add": {
                                if (args.length == 3) {
                                    this.membersAdd(source, MeterGroupCommand.parsePlayers(source, args[2]));
                                    return;
                                }
                                throw new C_7238350(USAGE_MEMBERS_ADD, new Object[0]);
                            }
                            case "remove": {
                                if (args.length == 3) {
                                    this.membersRemovePlayer(source, args[2]);
                                    return;
                                }
                                throw new C_7238350(USAGE_MEMBERS_REMOVE, new Object[0]);
                            }
                            case "clear": {
                                if (args.length == 2) {
                                    this.membersClear(source);
                                    return;
                                }
                                throw new C_7238350(USAGE_MEMBERS_CLEAR, new Object[0]);
                            }
                        }
                    }
                    throw new C_7238350(USAGE_MEMBERS, new Object[0]);
                }
                case "clear": {
                    if (args.length == 1) {
                        this.clear(source);
                        return;
                    }
                    throw new C_7238350(USAGE_CLEAR, new Object[0]);
                }
            }
        }
        throw new C_7238350(this.m_5298415(source), new Object[0]);
    }

    private boolean isMultimeterClient(C_1730529 source) {
        return this.run(source, player -> this.server.isMultimeterClient((C_3292284)player));
    }

    private boolean isOwnerOfSubscription(C_1730529 source) {
        return this.run(source, player -> this.multimeter.isOwnerOfSubscription((C_3292284)player));
    }

    private Collection<String> listMeterGroups(C_1730529 source) {
        ArrayList<String> names = new ArrayList<String>();
        this.command(source, (C_3292284 player) -> {
            for (ServerMeterGroup meterGroup : this.multimeter.getMeterGroups()) {
                if (meterGroup.isPrivate() && !meterGroup.hasMember(player) && !meterGroup.isOwnedBy(player)) continue;
                names.add(meterGroup.getName());
            }
        });
        return names;
    }

    private Map<String, UUID> listMembers(C_1730529 source) {
        HashMap<String, UUID> names = new HashMap<String, UUID>();
        this.command(source, (C_3292284 player) -> {
            ServerMeterGroup meterGroup = this.multimeter.getSubscription(player);
            if (meterGroup != null && meterGroup.isOwnedBy(player)) {
                for (UUID playerUUID : meterGroup.getMembers()) {
                    String playerName = this.multimeter.getServer().getPlayerList().getName(playerUUID);
                    if (playerName == null) continue;
                    names.put(playerName, playerUUID);
                }
            }
        });
        return names;
    }

    private void list(C_1730529 source) {
        Collection<String> names = this.listMeterGroups(source);
        if (names.isEmpty()) {
            MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.list.failure.none"));
        } else {
            Text message = Texts.translatable("rsmm.command.metergroup.list.success");
            for (String name : names) {
                message.append("\n  " + name);
            }
            MeterGroupCommand.sendSuccess(source, message);
        }
    }

    private void subscribe(C_1730529 source, String name) {
        this.command(source, (C_3292284 player) -> {
            if (name == null) {
                this.multimeter.subscribeToDefaultMeterGroup(player);
                MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.subscribe.success.default"));
            } else if (this.multimeter.hasMeterGroup(name)) {
                ServerMeterGroup meterGroup = this.multimeter.getMeterGroup(name);
                if (!meterGroup.isPrivate() || meterGroup.hasMember(player) || meterGroup.isOwnedBy(player)) {
                    this.multimeter.subscribeToMeterGroup(meterGroup, player);
                    MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.subscribe.success.joined", name));
                } else {
                    MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.subscribe.failure.private"));
                }
            } else if (MeterGroup.isValidName(name)) {
                this.multimeter.createMeterGroup(player, name);
                MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.subscribe.success.created", name));
            } else {
                MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.subscribe.failure.invalid", name));
            }
        });
    }

    private void unsubscribe(C_1730529 source) {
        this.command(source, (ServerMeterGroup meterGroup, C_3292284 player) -> {
            this.multimeter.unsubscribeFromMeterGroup(meterGroup, player);
            MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.unsubscribe.success", meterGroup.getName()));
        });
    }

    private void queryPrivate(C_1730529 source) {
        this.command(source, (ServerMeterGroup meterGroup, C_3292284 player) -> {
            String status = meterGroup.isPrivate() ? "private" : "public";
            MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.private.query.success." + status, meterGroup.getName()));
        });
    }

    private void setPrivate(C_1730529 source, boolean isPrivate) {
        this.command(source, (ServerMeterGroup meterGroup, C_3292284 player) -> {
            if (meterGroup.isOwnedBy(player)) {
                meterGroup.setPrivate(isPrivate);
                String status = isPrivate ? "private" : "public";
                MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.private.set.success." + status, meterGroup.getName()));
            } else {
                MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.private.set.failure.notOwner"));
            }
        });
    }

    private void membersList(C_1730529 source) {
        Map<String, UUID> members = this.listMembers(source);
        this.commandMembers(source, (meterGroup, owner) -> {
            if (members.isEmpty()) {
                MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.members.list.failure.none", meterGroup.getName()));
            } else {
                Text message = Texts.translatable("rsmm.command.metergroup.members.list.success", meterGroup.getName());
                for (Map.Entry member : members.entrySet()) {
                    message.append("\n  " + (String)member.getKey());
                }
                MeterGroupCommand.sendSuccess(source, message);
            }
        });
    }

    private void membersAdd(C_1730529 source, Collection<C_3292284> players) {
        this.commandMembers(source, (meterGroup, owner) -> {
            for (C_3292284 player : players) {
                if (player == owner) {
                    MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.members.add.failure.self"));
                    continue;
                }
                if (meterGroup.hasMember(player)) {
                    MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.members.add.failure.alreadyMember", player.m_6689989(), meterGroup.getName()));
                    continue;
                }
                if (!this.multimeter.getServer().isMultimeterClient(player)) {
                    MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.members.add.failure.notInstalled", player.m_6689989()));
                    continue;
                }
                this.multimeter.addMemberToMeterGroup(meterGroup, player.m_2013188());
                MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.members.add.success", player.m_6689989(), meterGroup.getName()));
            }
        });
    }

    private void membersRemovePlayer(C_1730529 source, String playerName) {
        this.commandMembers(source, (meterGroup, owner) -> {
            Map.Entry<String, UUID> member = this.findMember(this.listMembers(source), playerName);
            if (member == null) {
                C_3292284 player = this.multimeter.getServer().getPlayerList().get(playerName);
                if (player == owner) {
                    MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.members.remove.failure.self"));
                } else {
                    MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.members.remove.failure.noSuchMember", meterGroup.getName(), playerName));
                }
            } else {
                this.multimeter.removeMemberFromMeterGroup(meterGroup, member.getValue());
                MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.members.remove.success", member.getKey(), meterGroup.getName()));
            }
        });
    }

    private Map.Entry<String, UUID> findMember(Map<String, UUID> members, String playerName) {
        String key = playerName.toLowerCase();
        for (Map.Entry<String, UUID> member : members.entrySet()) {
            if (!member.getKey().toLowerCase().equals(key)) continue;
            return member;
        }
        return null;
    }

    private void membersClear(C_1730529 source) {
        this.commandMembers(source, (meterGroup, owner) -> {
            this.multimeter.clearMembersOfMeterGroup(meterGroup);
            MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.members.clear.success", meterGroup.getName()));
        });
    }

    private void commandMembers(C_1730529 source, MeterGroupCommandExecutor command) {
        this.command(source, (ServerMeterGroup meterGroup, C_3292284 player) -> {
            if (meterGroup.isOwnedBy(player)) {
                command.run(meterGroup, player);
                if (!meterGroup.isPrivate()) {
                    MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.members.warning.public"));
                }
            }
        });
    }

    private void clear(C_1730529 source) {
        this.command(source, (ServerMeterGroup meterGroup, C_3292284 player) -> {
            this.multimeter.clearMeterGroup(meterGroup);
            MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.clear.success", meterGroup.getName()));
        });
    }

    private void command(C_1730529 source, MeterGroupCommandExecutor command) {
        this.command(source, (C_3292284 player) -> {
            ServerMeterGroup meterGroup = this.multimeter.getSubscription(player);
            if (meterGroup == null) {
                MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.warning.notSubscribed"));
            } else {
                command.run(meterGroup, player);
            }
        });
    }

    private void command(C_1730529 source, MultimeterCommandExecutor command) {
        this.run(source, p -> {
            command.run((C_3292284)p);
            return true;
        });
    }

    private boolean run(C_1730529 source, Function<C_3292284, Boolean> command) {
        try {
            return command.apply(MeterGroupCommand.m_0707287((C_1730529)source));
        }
        catch (C_8003398 e) {
            return false;
        }
    }

    private static List<C_3292284> parsePlayers(C_1730529 source, String arg) throws C_8003398 {
        C_3292284[] players = C_5100287.m_4244462((C_1730529)source, (String)arg);
        if (players.length == 0) {
            return Arrays.asList(C_5917668.m_9838422((C_1730529)source, (String)arg));
        }
        return Arrays.asList(players);
    }

    private static void sendSuccess(C_1730529 source, Text message) {
        MeterGroupCommand.sendSuccess(source, message, false);
    }

    private static void sendSuccess(C_1730529 source, Text message, boolean actionBar) {
        if (actionBar) {
            throw new UnsupportedOperationException();
        }
        source.m_3031403(message.resolve());
    }

    @FunctionalInterface
    private static interface MultimeterCommandExecutor {
        public void run(C_3292284 var1);
    }

    @FunctionalInterface
    private static interface MeterGroupCommandExecutor {
        public void run(ServerMeterGroup var1, C_3292284 var2);
    }
}

