/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.common;

import com.google.common.base.Objects;
import net.minecraft.unmapped.C_2018497;
import net.minecraft.unmapped.C_5553933;
import redstone.multimeter.util.Dimensions;
import redstone.multimeter.util.Direction;

public class DimPos {
    private final String dimension;
    private final int x;
    private final int y;
    private final int z;

    public DimPos(String dimension, int x, int y, int z) {
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public DimPos(C_5553933 world, int x, int y, int z) {
        this(Dimensions.REGISTRY.getKey(world.f_6669533.f_8006473), x, y, z);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DimPos) {
            DimPos other = (DimPos)obj;
            return other.dimension.equals(this.dimension) && other.x == this.x && other.y == this.y && other.z == this.z;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.dimension, this.x, this.y, this.z});
    }

    public String toString() {
        return String.format("%s[%d, %d, %d]", this.dimension.toString(), this.x, this.y, this.z);
    }

    public String getDimension() {
        return this.dimension;
    }

    public boolean is(C_5553933 world) {
        return (Integer)Dimensions.REGISTRY.m_6111517(this.dimension) == world.f_6669533.f_8006473;
    }

    public DimPos offset(String dimension) {
        return new DimPos(dimension, this.x, this.y, this.z);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public boolean is(int x, int y, int z) {
        return x == this.x && y == this.y && z == this.z;
    }

    public DimPos offset(Direction dir) {
        return this.offset(dir, 1);
    }

    public DimPos offset(Direction dir, int distance) {
        return this.offset(distance * dir.getOffsetX(), distance * dir.getOffsetY(), distance * dir.getOffsetZ());
    }

    public DimPos offset(Direction.Axis axis) {
        return this.offset(axis, 1);
    }

    public DimPos offset(Direction.Axis axis, int distance) {
        return this.offset(axis.choose(distance, 0, 0), axis.choose(0, distance, 0), axis.choose(0, 0, distance));
    }

    public DimPos offset(int dx, int dy, int dz) {
        return new DimPos(this.dimension, this.x + dx, this.y + dy, this.z + dz);
    }

    public C_2018497 toNbt() {
        C_2018497 nbt = new C_2018497();
        nbt.m_1991972("dim", this.dimension);
        nbt.m_6525930("x", this.x);
        nbt.m_6525930("y", this.y);
        nbt.m_6525930("z", this.z);
        return nbt;
    }

    public static DimPos fromNbt(C_2018497 nbt) {
        String dimension = nbt.m_1107321("dim");
        int x = nbt.m_2250123("x");
        int y = nbt.m_2250123("y");
        int z = nbt.m_2250123("z");
        return new DimPos(dimension, x, y, z);
    }
}

