/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.common;

import java.util.Arrays;
import net.minecraft.unmapped.C_3225627;
import net.minecraft.unmapped.C_6684392;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.gui.tooltip.TooltipBuilder;
import redstone.multimeter.common.TickTask;
import redstone.multimeter.util.NbtUtils;

public class TickPhase {
    public static final TickPhase UNKNOWN = new TickPhase(TickTask.UNKNOWN);
    private final TickTask[] tasks;

    public TickPhase(TickTask ... tasks) {
        this.tasks = tasks;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TickPhase)) {
            return false;
        }
        return Arrays.equals((Object[])this.tasks, (Object[])((TickPhase)obj).tasks);
    }

    public String toString() {
        String string = this.tasks[0].getName().buildString();
        for (int index = 1; index < this.tasks.length; ++index) {
            string = string + " > " + this.tasks[index].getName().buildString();
        }
        return string;
    }

    public void buildTooltip(TooltipBuilder builder) {
        builder.line(Texts.keyValue("tick phase", this.tasks[0].getName()));
        String whitespace = "              ";
        for (int index = 1; index < this.tasks.length; ++index) {
            builder.line(Texts.composite(whitespace, "> ", this.tasks[index].getName()));
            whitespace = whitespace + "  ";
        }
    }

    public TickPhase startTask(TickTask task) {
        if (this == UNKNOWN || this.tasks.length == 0) {
            return new TickPhase(task);
        }
        TickTask[] array = new TickTask[this.tasks.length + 1];
        for (int index = 0; index < this.tasks.length; ++index) {
            array[index] = this.tasks[index];
        }
        array[this.tasks.length] = task;
        return new TickPhase(array);
    }

    public TickPhase endTask() {
        if (this == UNKNOWN || this.tasks.length == 1) {
            return UNKNOWN;
        }
        TickTask[] array = new TickTask[this.tasks.length - 1];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.tasks[index];
        }
        return new TickPhase(array);
    }

    public TickPhase swapTask(TickTask task) {
        if (this == UNKNOWN || this.tasks.length == 1) {
            return new TickPhase(task);
        }
        TickTask[] array = new TickTask[this.tasks.length];
        for (int index = 0; index < this.tasks.length; ++index) {
            array[index] = this.tasks[index];
        }
        array[array.length - 1] = task;
        return new TickPhase(array);
    }

    public TickTask peekTask() {
        return this.tasks.length == 0 ? TickTask.UNKNOWN : this.tasks[this.tasks.length - 1];
    }

    public C_3225627 toNbt() {
        if (this == UNKNOWN) {
            return NbtUtils.NULL;
        }
        byte[] array = new byte[this.tasks.length];
        for (int index = 0; index < array.length; ++index) {
            array[index] = (byte)this.tasks[index].getId();
        }
        return new C_6684392(array);
    }

    public static TickPhase fromNbt(C_3225627 nbt) {
        if (nbt.m_0346400() != 7) {
            return UNKNOWN;
        }
        C_6684392 nbtArray = (C_6684392)nbt;
        byte[] array = nbtArray.m_7659981();
        TickTask[] tasks = new TickTask[array.length];
        for (int index = 0; index < tasks.length; ++index) {
            tasks[index] = TickTask.byId(array[index]);
        }
        return new TickPhase(tasks);
    }
}

