/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.common.meter;

import java.awt.Color;
import redstone.multimeter.client.option.Cyclable;

public enum ColorPicker implements Cyclable<ColorPicker>
{
    RANDOM("random", "RANDOM"){
        private int index;

        @Override
        public int next() {
            float hue = ((float)(this.index * 11 % 8) + (float)(this.index / 8) / 2.0f) / 8.0f;
            this.index = (this.index + 1) % 16;
            return Color.HSBtoRGB(hue, 0.7f, 1.0f);
        }
    }
    ,
    RAINBOW("rainbow", "RAINBOW"){
        private int index;

        @Override
        public int next() {
            float hue = (float)this.index / 32.0f;
            this.index = (this.index + 1) % 32;
            return Color.HSBtoRGB(hue, 0.7f, 1.0f);
        }
    };

    private final String key;
    private final String legacyKey;

    private ColorPicker(String key, String legacyKey) {
        this.key = key;
        this.legacyKey = legacyKey;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String legacyKey() {
        return this.legacyKey;
    }

    public abstract int next();
}

