/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.common.meter;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import net.minecraft.unmapped.C_2018497;
import net.minecraft.unmapped.C_3225627;
import net.minecraft.unmapped.C_5553933;
import redstone.multimeter.common.DimPos;
import redstone.multimeter.common.meter.MeterProperties;
import redstone.multimeter.common.meter.event.EventType;
import redstone.multimeter.common.meter.log.MeterLogs;
import redstone.multimeter.util.ColorUtils;

public class Meter {
    private static final AtomicLong ID_COUNTER = new AtomicLong(0L);
    private final long id;
    private final MeterProperties.MutableMeterProperties properties;
    private final MeterLogs logs;
    private boolean powered;
    private boolean active;
    private boolean hidden;

    public Meter(long id, MeterProperties.MutableMeterProperties properties) {
        this.id = id;
        this.properties = properties.mutable();
        this.logs = new MeterLogs();
    }

    public Meter(MeterProperties.MutableMeterProperties properties) {
        this(ID_COUNTER.getAndIncrement(), properties);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Meter) {
            Meter meter = (Meter)obj;
            return meter.id == this.id;
        }
        return false;
    }

    public long getId() {
        return this.id;
    }

    public MeterProperties getProperties() {
        return this.properties.immutable();
    }

    public MeterLogs getLogs() {
        return this.logs;
    }

    public void applyUpdate(Consumer<MeterProperties.MutableMeterProperties> update) {
        update.accept(this.properties);
    }

    public DimPos getPos() {
        return this.properties.getPos();
    }

    public boolean isIn(C_5553933 world) {
        return this.properties.getPos().is(world);
    }

    public String getName() {
        return this.properties.getName();
    }

    public int getColor() {
        return ColorUtils.setAlpha(this.properties.getColor(), 255);
    }

    public boolean isMovable() {
        return this.properties.getMovable();
    }

    public int getEventTypes() {
        return this.properties.getEventTypes();
    }

    public boolean isMetering(EventType type) {
        return this.properties.hasEventType(type);
    }

    public boolean isPowered() {
        return this.powered;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean setPowered(boolean powered) {
        boolean wasPowered = this.powered;
        this.powered = powered;
        return wasPowered != powered;
    }

    public boolean setActive(boolean active) {
        boolean wasActive = this.active;
        this.active = active;
        return wasActive != active;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void toggleHidden() {
        this.setHidden(!this.hidden);
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public C_2018497 toNbt() {
        C_2018497 nbt = new C_2018497();
        nbt.m_7177295("id", this.id);
        nbt.m_2972230("properties", (C_3225627)this.properties.toNbt());
        nbt.m_0815577("powered", this.powered);
        nbt.m_0815577("active", this.active);
        return nbt;
    }

    public static Meter fromNbt(C_2018497 nbt) {
        long id = nbt.m_7737691("id");
        MeterProperties properties = MeterProperties.fromNbt(nbt.m_6015642("properties"));
        boolean powered = nbt.m_0539249("powered");
        boolean active = nbt.m_0539249("active");
        Meter meter = new Meter(id, properties.mutable());
        meter.setPowered(powered);
        meter.setActive(active);
        return meter;
    }
}

