/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.common.meter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.unmapped.C_2018497;
import net.minecraft.unmapped.C_3225627;
import redstone.multimeter.common.DimPos;
import redstone.multimeter.common.meter.event.EventType;
import redstone.multimeter.util.ColorUtils;

public class MeterProperties {
    private DimPos pos;
    private String name;
    private Integer color;
    private Boolean movable;
    private Integer eventTypes;

    public MeterProperties() {
    }

    public MeterProperties(DimPos pos, String name, Integer color, Boolean movable, Integer eventTypes) {
        this.pos = pos;
        this.name = name;
        this.color = color;
        this.movable = movable;
        this.eventTypes = eventTypes;
    }

    public String toString() {
        return String.format("MeterProperties[pos: %s, name: %s, color: %s, movable: %s, event types: %s]", this.pos, this.name, this.color, this.movable, this.eventTypes);
    }

    public int hashCode() {
        return Objects.hash(this.pos, this.name, this.color, this.movable, this.eventTypes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MeterProperties)) {
            return false;
        }
        MeterProperties p = (MeterProperties)o;
        return Objects.equals(this.pos, p.pos) && Objects.equals(this.name, p.name) && Objects.equals(this.color, p.color) && Objects.equals(this.movable, p.movable) && Objects.equals(this.eventTypes, p.eventTypes);
    }

    public DimPos getPos() {
        return this.pos;
    }

    public String getName() {
        return this.name;
    }

    public Integer getColor() {
        return this.color;
    }

    public Boolean getMovable() {
        return this.movable;
    }

    public Integer getEventTypes() {
        return this.eventTypes;
    }

    public boolean hasEventType(EventType type) {
        return this.eventTypes != null && (this.eventTypes & type.flag()) != 0;
    }

    public MutableMeterProperties mutable() {
        return new MutableMeterProperties().fill(this);
    }

    public MeterProperties immutable() {
        return this;
    }

    public C_2018497 toNbt() {
        C_2018497 nbt = new C_2018497();
        if (this.pos != null) {
            nbt.m_2972230("pos", (C_3225627)this.pos.toNbt());
        }
        if (this.name != null) {
            nbt.m_1991972("name", this.name);
        }
        if (this.color != null) {
            nbt.m_6525930("color", this.color.intValue());
        }
        if (this.movable != null) {
            nbt.m_0815577("movable", this.movable.booleanValue());
        }
        if (this.eventTypes != null) {
            nbt.m_6525930("event types", this.eventTypes.intValue());
        }
        return nbt;
    }

    public static MeterProperties fromNbt(C_2018497 nbt) {
        MeterProperties properties = new MeterProperties();
        if (nbt.m_6440996("pos")) {
            properties.pos = DimPos.fromNbt(nbt.m_6015642("pos"));
        }
        if (nbt.m_6440996("name")) {
            properties.name = nbt.m_1107321("name");
        }
        if (nbt.m_6440996("color")) {
            properties.color = nbt.m_2250123("color");
        }
        if (nbt.m_6440996("movable")) {
            properties.movable = nbt.m_0539249("movable");
        }
        if (nbt.m_6440996("event types")) {
            properties.eventTypes = nbt.m_2250123("event types");
        }
        return properties;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.name != null) {
            json.addProperty("name", this.name);
        }
        if (this.color != null) {
            json.addProperty("color", ColorUtils.toRGBString(this.color));
        }
        if (this.movable != null) {
            json.addProperty("movable", this.movable);
        }
        if (this.eventTypes != null) {
            JsonArray types = new JsonArray();
            for (EventType type : EventType.ALL) {
                if (!this.hasEventType(type)) continue;
                types.add(type.getLegacyKey());
            }
            json.add("event_types", (JsonElement)types);
        }
        return json;
    }

    public static MeterProperties fromJson(JsonObject json) {
        JsonElement typesJson;
        JsonElement movableJson;
        JsonElement colorJson;
        JsonElement nameJson;
        MeterProperties properties = new MeterProperties();
        if (json.has("name") && (nameJson = json.get("name")).isJsonPrimitive()) {
            properties.name = nameJson.getAsString();
        }
        if (json.has("color") && (colorJson = json.get("color")).isJsonPrimitive()) {
            try {
                properties.color = ColorUtils.fromRGBString(colorJson.getAsString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (json.has("movable") && (movableJson = json.get("movable")).isJsonPrimitive()) {
            properties.movable = movableJson.getAsBoolean();
        }
        if (json.has("event_types") && (typesJson = json.get("event_types")).isJsonArray()) {
            properties.eventTypes = 0;
            JsonArray types = typesJson.getAsJsonArray();
            for (int index = 0; index < types.size(); ++index) {
                String typeName;
                EventType type;
                JsonElement typeJson = types.get(index);
                if (!typeJson.isJsonPrimitive() || (type = EventType.byLegacyKey(typeName = typeJson.getAsString())) == null) continue;
                MeterProperties meterProperties = properties;
                Integer.valueOf(meterProperties.eventTypes | type.flag());
                meterProperties.eventTypes = meterProperties.eventTypes;
            }
        }
        return properties;
    }

    public static class MutableMeterProperties
    extends MeterProperties {
        public boolean setPos(DimPos pos) {
            DimPos prevPos = ((MeterProperties)this).pos;
            ((MeterProperties)this).pos = pos;
            return prevPos == null || !prevPos.equals(pos);
        }

        public boolean setName(String name) {
            String prevName = ((MeterProperties)this).name;
            ((MeterProperties)this).name = name;
            return prevName == null || !prevName.equals(name);
        }

        public boolean setColor(Integer color) {
            Integer prevColor = ((MeterProperties)this).color;
            ((MeterProperties)this).color = color;
            return prevColor == null || !prevColor.equals(color);
        }

        public boolean setMovable(Boolean movable) {
            Boolean prevMovable = ((MeterProperties)this).movable;
            ((MeterProperties)this).movable = movable;
            return prevMovable == null || !prevMovable.equals(movable);
        }

        public boolean setEventTypes(Integer eventTypes) {
            Integer prevEventTypes = ((MeterProperties)this).eventTypes;
            ((MeterProperties)this).eventTypes = eventTypes;
            return prevEventTypes == null || !prevEventTypes.equals(eventTypes);
        }

        public boolean toggleEventType(EventType type) {
            if (((MeterProperties)this).eventTypes == null) {
                ((MeterProperties)this).eventTypes = 0;
            }
            return this.setEventTypes(((MeterProperties)this).eventTypes ^ type.flag());
        }

        @Override
        public MutableMeterProperties mutable() {
            return this;
        }

        @Override
        public MeterProperties immutable() {
            return new MeterProperties(((MeterProperties)this).pos, ((MeterProperties)this).name, ((MeterProperties)this).color, ((MeterProperties)this).movable, ((MeterProperties)this).eventTypes);
        }

        public MutableMeterProperties fill(MeterProperties properties) {
            if (properties == null) {
                return this;
            }
            if (((MeterProperties)this).pos == null) {
                ((MeterProperties)this).pos = properties.pos;
            }
            if (((MeterProperties)this).name == null) {
                ((MeterProperties)this).name = properties.name;
            }
            if (((MeterProperties)this).color == null) {
                ((MeterProperties)this).color = properties.color;
            }
            if (((MeterProperties)this).movable == null) {
                ((MeterProperties)this).movable = properties.movable;
            }
            if (((MeterProperties)this).eventTypes == null) {
                ((MeterProperties)this).eventTypes = properties.eventTypes;
            }
            return this;
        }
    }
}

