/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.common.meter.event;

import java.util.ArrayList;
import net.minecraft.unmapped.C_2018497;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.gui.tooltip.Tooltip;
import redstone.multimeter.client.gui.tooltip.TooltipBuilder;
import redstone.multimeter.client.gui.tooltip.Tooltips;
import redstone.multimeter.common.meter.event.EventType;

public class MeterEvent {
    private EventType type;
    private int metadata;

    private MeterEvent() {
    }

    public MeterEvent(EventType type, int metadata) {
        this.type = type;
        this.metadata = metadata;
    }

    public String toString() {
        String string = this.type.getLegacyKey();
        Tooltip tooltip = Tooltips.builder().lines(this::buildTooltip).build();
        ArrayList<String> parts = new ArrayList<String>();
        int partCount = 0;
        for (Text line : tooltip) {
            if (partCount++ <= 0) continue;
            parts.add(line.buildString());
        }
        if (!parts.isEmpty()) {
            string = string + "[" + String.join((CharSequence)", ", parts) + "]";
        }
        return string;
    }

    public EventType getType() {
        return this.type;
    }

    public int getMetadata() {
        return this.metadata;
    }

    public void buildTooltip(TooltipBuilder builder) {
        builder.line(Texts.keyValue("event type", this.type.getName())).lines(b -> this.type.buildTooltip(builder, this.metadata));
    }

    public C_2018497 toNbt() {
        C_2018497 nbt = new C_2018497();
        nbt.m_2972230("type", this.type.toNbt());
        nbt.m_6525930("metadata", this.metadata);
        return nbt;
    }

    public static MeterEvent fromNbt(C_2018497 nbt) {
        MeterEvent event = new MeterEvent();
        event.type = EventType.fromNbt(nbt.m_9800739("type"));
        event.metadata = nbt.m_2250123("metadata");
        return event;
    }
}

