/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.common.meter.log;

import net.minecraft.unmapped.C_2018497;
import net.minecraft.unmapped.C_3225627;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.gui.tooltip.Tooltip;
import redstone.multimeter.client.gui.tooltip.Tooltips;
import redstone.multimeter.common.TickPhase;
import redstone.multimeter.common.meter.event.MeterEvent;

public class EventLog {
    private long tick;
    private int subtick;
    private TickPhase tickPhase;
    private MeterEvent event;

    private EventLog() {
    }

    public EventLog(long tick, int subtick, TickPhase tickPhase, MeterEvent event) {
        this.tick = tick;
        this.subtick = subtick;
        this.tickPhase = tickPhase;
        this.event = event;
    }

    public long getTick() {
        return this.tick;
    }

    public int getSubtick() {
        return this.subtick;
    }

    public boolean isAt(long tick) {
        return this.tick == tick;
    }

    public boolean isAt(long tick, int subtick) {
        return this.tick == tick && this.subtick == subtick;
    }

    public boolean isBefore(long tick) {
        return this.tick < tick;
    }

    public boolean isBefore(long tick, int subtick) {
        if (this.tick == tick) {
            return this.subtick < subtick;
        }
        return this.tick < tick;
    }

    public boolean isBefore(EventLog event) {
        return this.isBefore(event.getTick(), event.getSubtick());
    }

    public boolean isAfter(long tick) {
        return this.tick > tick;
    }

    public boolean isAfter(long tick, int subtick) {
        if (this.tick == tick) {
            return this.subtick > subtick;
        }
        return this.tick > tick;
    }

    public boolean isAfter(EventLog event) {
        return this.isAfter(event.getTick(), event.getSubtick());
    }

    public TickPhase getTickPhase() {
        return this.tickPhase;
    }

    public MeterEvent getEvent() {
        return this.event;
    }

    public Tooltip getTooltip() {
        return Tooltips.builder().lines(this.event::buildTooltip).line(Texts.keyValue("tick", this.tick)).line(Texts.keyValue("subtick", this.subtick)).lines(this.tickPhase::buildTooltip).build();
    }

    public C_2018497 toNbt() {
        C_2018497 nbt = new C_2018497();
        nbt.m_2972230("meter event", (C_3225627)this.event.toNbt());
        nbt.m_7177295("tick", this.tick);
        nbt.m_6525930("subtick", this.subtick);
        nbt.m_2972230("tick phase", this.tickPhase.toNbt());
        return nbt;
    }

    public static EventLog fromNbt(C_2018497 nbt) {
        EventLog log = new EventLog();
        log.event = MeterEvent.fromNbt(nbt.m_6015642("meter event"));
        log.tick = nbt.m_7737691("tick");
        log.subtick = nbt.m_2250123("subtick");
        log.tickPhase = TickPhase.fromNbt(nbt.m_9800739("tick phase"));
        return log;
    }
}

