/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.common.meter.log;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.unmapped.C_2018497;
import net.minecraft.unmapped.C_3225627;
import net.minecraft.unmapped.C_5693434;
import redstone.multimeter.common.meter.event.EventType;
import redstone.multimeter.common.meter.log.EventLog;
import redstone.multimeter.util.ListUtils;

public class MeterLogs {
    private final List<EventLog>[] eventLogs;
    private long count = 0L;

    public MeterLogs() {
        List[] lists = new List[EventType.ALL.length];
        for (int index = 0; index < lists.length; ++index) {
            lists[index] = new ArrayList();
        }
        this.eventLogs = lists;
    }

    public void clear() {
        for (List<EventLog> logs : this.eventLogs) {
            logs.clear();
        }
        this.count = 0L;
    }

    public boolean isEmpty() {
        return this.count == 0L;
    }

    private List<EventLog> getLogs(EventType type) {
        return this.eventLogs[type.getId()];
    }

    public void add(EventLog log) {
        EventType type = log.getEvent().getType();
        List<EventLog> logs = this.getLogs(type);
        logs.add(this.getLastLogBefore(type, log.getTick(), log.getSubtick()) + 1, log);
        ++this.count;
    }

    public void clearOldLogs(long cutoff) {
        for (List<EventLog> logs : this.eventLogs) {
            EventLog log;
            while (!logs.isEmpty() && (log = logs.get(0)).getTick() <= cutoff) {
                logs.remove(0);
            }
        }
    }

    public EventLog getLog(EventType type, int index) {
        if (index < 0) {
            return null;
        }
        List<EventLog> logs = this.getLogs(type);
        if (index >= logs.size()) {
            return null;
        }
        return logs.get(index);
    }

    public int getLastLogBefore(EventType type, long tick) {
        return this.getLastLogBefore(type, tick, 0);
    }

    public int getLastLogBefore(EventType type, long tick, int subtick) {
        List<EventLog> logs = this.getLogs(type);
        if (logs.isEmpty() || !logs.get(0).isBefore(tick, subtick)) {
            return -1;
        }
        if (logs.get(logs.size() - 1).isBefore(tick, subtick)) {
            return logs.size() - 1;
        }
        int index = ListUtils.binarySearch(logs, event -> event.isBefore(tick, subtick));
        EventLog log = logs.get(index);
        while (!log.isBefore(tick, subtick)) {
            if (index == 0) {
                return -1;
            }
            log = logs.get(--index);
        }
        return index;
    }

    public EventLog getLastLogBefore(long tick) {
        return this.getLastLogBefore(tick, 0);
    }

    public EventLog getLastLogBefore(long tick, int subtick) {
        EventLog lastLog = null;
        for (EventType type : EventType.ALL) {
            int index = this.getLastLogBefore(type, tick, subtick);
            EventLog log = this.getLog(type, index);
            if (lastLog != null && (log == null || !log.isAfter(lastLog))) continue;
            lastLog = log;
        }
        return lastLog;
    }

    public int getFirstLogAfter(EventType type, long tick) {
        return this.getFirstLogAfter(type, tick, Integer.MAX_VALUE);
    }

    public int getFirstLogAfter(EventType type, long tick, int subtick) {
        List<EventLog> logs = this.getLogs(type);
        if (logs.isEmpty() || !logs.get(logs.size() - 1).isAfter(tick, subtick)) {
            return -1;
        }
        if (logs.get(0).isAfter(tick, subtick)) {
            return 0;
        }
        int index = ListUtils.binarySearch(logs, event -> event.isBefore(tick, subtick));
        EventLog log = logs.get(index);
        while (!log.isAfter(tick, subtick)) {
            if (index == logs.size() - 1) {
                return -1;
            }
            log = logs.get(++index);
        }
        return index;
    }

    public EventLog getFirstLogAfter(long tick) {
        return this.getFirstLogAfter(tick, 0);
    }

    public EventLog getFirstLogAfter(long tick, int subtick) {
        EventLog firstLog = null;
        for (EventType type : EventType.ALL) {
            int index = this.getFirstLogAfter(type, tick, subtick);
            EventLog log = this.getLog(type, index);
            if (firstLog != null && (log == null || !log.isBefore(firstLog))) continue;
            firstLog = log;
        }
        return firstLog;
    }

    public EventLog getLogAt(long tick, int subtick) {
        EventLog log = this.getLastLogBefore(tick, subtick + 1);
        return log != null && log.isAt(tick, subtick) ? log : null;
    }

    public C_2018497 toNbt() {
        C_2018497 nbt = new C_2018497();
        for (EventType type : EventType.ALL) {
            C_5693434 logs = this.toNbt(type);
            if (logs.m_8051737() <= 0) continue;
            nbt.m_2972230(type.getLegacyKey(), (C_3225627)logs);
        }
        return nbt;
    }

    private C_5693434 toNbt(EventType type) {
        C_5693434 list = new C_5693434();
        for (EventLog log : this.getLogs(type)) {
            list.m_0728373((C_3225627)log.toNbt());
        }
        return list;
    }

    public static Collection<EventLog> fromNbt(C_2018497 nbt) {
        ArrayList<EventLog> logs = new ArrayList<EventLog>();
        for (String key : nbt.m_5340812()) {
            EventType type = EventType.byLegacyKey(key);
            if (type == null) continue;
            logs.addAll(MeterLogs.fromNbt(type, nbt.m_7623152(key, 10)));
        }
        return logs;
    }

    public static Collection<EventLog> fromNbt(EventType type, C_5693434 nbt) {
        ArrayList<EventLog> logs = new ArrayList<EventLog>();
        for (int i = 0; i < nbt.m_8051737(); ++i) {
            logs.add(EventLog.fromNbt(nbt.m_1469498(i)));
        }
        return logs;
    }
}

