/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.common.network.packets;

import net.minecraft.unmapped.C_2018497;
import net.minecraft.unmapped.C_3225627;
import net.minecraft.unmapped.C_3292284;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.meter.ClientMeterGroup;
import redstone.multimeter.common.meter.MeterGroup;
import redstone.multimeter.common.network.RSMMPacket;
import redstone.multimeter.server.Multimeter;
import redstone.multimeter.server.MultimeterServer;

public class MeterGroupRefreshPacket
implements RSMMPacket {
    private String name;
    private C_2018497 meterGroupData;

    public MeterGroupRefreshPacket() {
    }

    public MeterGroupRefreshPacket(MeterGroup meterGroup) {
        this.name = meterGroup.getName();
        this.meterGroupData = meterGroup.toNbt();
    }

    @Override
    public void encode(C_2018497 data) {
        data.m_1991972("name", this.name);
        data.m_2972230("data", (C_3225627)this.meterGroupData);
    }

    @Override
    public void decode(C_2018497 data) {
        this.name = data.m_1107321("name");
        this.meterGroupData = data.m_6015642("data");
    }

    @Override
    public void handle(MultimeterServer server, C_3292284 player) {
        Multimeter multimeter = server.getMultimeter();
        if (multimeter.hasSubscription(player)) {
            multimeter.refreshMeterGroup(player);
        }
    }

    @Override
    public void handle(MultimeterClient client) {
        ClientMeterGroup meterGroup = client.getMeterGroup();
        if (meterGroup.getName().equals(this.name)) {
            meterGroup.refresh(this.meterGroupData);
        } else {
            meterGroup.subscribe(-1, this.name);
        }
    }
}

