/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.common.network.packets;

import net.minecraft.unmapped.C_2018497;
import net.minecraft.unmapped.C_3292284;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.meter.ClientMeterGroup;
import redstone.multimeter.common.network.RSMMPacket;
import redstone.multimeter.server.Multimeter;
import redstone.multimeter.server.MultimeterServer;
import redstone.multimeter.server.meter.ServerMeterGroup;

public class MeterGroupSubscriptionPacket
implements RSMMPacket {
    private String name;
    private boolean subscribe;

    public MeterGroupSubscriptionPacket() {
    }

    public MeterGroupSubscriptionPacket(String name, boolean subscribed) {
        this.name = name;
        this.subscribe = subscribed;
    }

    @Override
    public void encode(C_2018497 data) {
        data.m_1991972("name", this.name);
        data.m_0815577("subscribe", this.subscribe);
    }

    @Override
    public void decode(C_2018497 data) {
        this.name = data.m_1107321("name");
        this.subscribe = data.m_0539249("subscribe");
    }

    @Override
    public void handle(MultimeterServer server, C_3292284 player) {
        Multimeter multimeter = server.getMultimeter();
        ServerMeterGroup meterGroup = multimeter.getMeterGroup(this.name);
        if (this.subscribe) {
            if (meterGroup == null) {
                multimeter.createMeterGroup(player, this.name);
            } else {
                multimeter.subscribeToMeterGroup(meterGroup, player);
            }
        } else if (meterGroup == null) {
            multimeter.refreshMeterGroup(player);
        } else {
            multimeter.unsubscribeFromMeterGroup(meterGroup, player);
        }
    }

    @Override
    public void handle(MultimeterClient client) {
        ClientMeterGroup meterGroup = client.getMeterGroup();
        ClientMeterGroup meterGroupPreview = client.getMeterGroupPreview();
        if (this.subscribe) {
            client.handleSubscribeToMeterGroup(this.name);
        } else {
            meterGroup.unsubscribe(false);
        }
        meterGroupPreview.stopPreviewing();
        if (client.getHud().isFocusMode()) {
            client.getHud().setFocusMode(false);
        }
    }
}

