/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.common.network.packets;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.unmapped.C_2018497;
import net.minecraft.unmapped.C_3225627;
import net.minecraft.unmapped.C_3292284;
import net.minecraft.unmapped.C_5693434;
import net.minecraft.unmapped.C_9785392;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.common.meter.MeterProperties;
import redstone.multimeter.common.network.RSMMPacket;
import redstone.multimeter.interfaces.mixin.INbtList;
import redstone.multimeter.server.MultimeterServer;

public class MeterUpdatesPacket
implements RSMMPacket {
    private List<Long> removedMeters;
    private Long2ObjectMap<MeterProperties> meterUpdates;
    private List<Long> meters;

    public MeterUpdatesPacket() {
        this.removedMeters = new ArrayList<Long>();
        this.meterUpdates = new Long2ObjectOpenHashMap();
        this.meters = new ArrayList<Long>();
    }

    public MeterUpdatesPacket(List<Long> removedMeters, Map<Long, MeterProperties> updates, List<Long> meters) {
        this.removedMeters = new ArrayList<Long>(removedMeters);
        this.meterUpdates = new Long2ObjectOpenHashMap(updates);
        this.meters = new ArrayList<Long>(meters);
    }

    @Override
    public void encode(C_2018497 data) {
        int i;
        C_5693434 list;
        if (!this.removedMeters.isEmpty()) {
            list = new C_5693434();
            for (i = 0; i < this.removedMeters.size(); ++i) {
                list.m_0728373((C_3225627)new C_9785392(this.removedMeters.get(i).longValue()));
            }
            data.m_2972230("removed", (C_3225627)list);
        }
        if (!this.meterUpdates.isEmpty()) {
            list = new C_5693434();
            for (Long2ObjectMap.Entry entry : this.meterUpdates.long2ObjectEntrySet()) {
                long id = entry.getLongKey();
                MeterProperties update = (MeterProperties)entry.getValue();
                C_2018497 nbt = update.toNbt();
                nbt.m_7177295("id", id);
                list.m_0728373((C_3225627)nbt);
            }
            data.m_2972230("updates", (C_3225627)list);
        }
        if (!this.meters.isEmpty()) {
            list = new C_5693434();
            for (i = 0; i < this.meters.size(); ++i) {
                list.m_0728373((C_3225627)new C_9785392(this.meters.get(i).longValue()));
            }
            data.m_2972230("meters", (C_3225627)list);
        }
    }

    @Override
    public void decode(C_2018497 data) {
        long id;
        C_9785392 nbt;
        int i;
        C_5693434 ids;
        if (data.m_6440996("removed")) {
            ids = data.m_7623152("removed", 4);
            for (i = 0; i < ids.m_8051737(); ++i) {
                nbt = ((INbtList)ids).getLong(i);
                id = nbt.m_7940320();
                this.removedMeters.add(id);
            }
        }
        if (data.m_6440996("updates")) {
            C_5693434 updates = data.m_7623152("updates", 10);
            for (i = 0; i < updates.m_8051737(); ++i) {
                nbt = updates.m_1469498(i);
                id = nbt.m_7737691("id");
                MeterProperties update = MeterProperties.fromNbt((C_2018497)nbt);
                this.meterUpdates.put(id, (Object)update);
            }
        }
        if (data.m_6440996("meters")) {
            ids = data.m_7623152("meters", 4);
            for (i = 0; i < ids.m_8051737(); ++i) {
                nbt = ((INbtList)ids).getLong(i);
                id = nbt.m_7940320();
                this.meters.add(id);
            }
        }
    }

    @Override
    public void handle(MultimeterServer server, C_3292284 player) {
    }

    @Override
    public void handle(MultimeterClient client) {
        client.getMeterGroup().updateMeters(this.removedMeters, this.meterUpdates, this.meters);
    }
}

