/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.mixin.common;

import java.util.Iterator;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraft.unmapped.C_1241852;
import net.minecraft.unmapped.C_2286850;
import net.minecraft.unmapped.C_2670477;
import net.minecraft.unmapped.C_3198459;
import net.minecraft.unmapped.C_3865296;
import net.minecraft.unmapped.C_5528202;
import net.minecraft.unmapped.C_5553933;
import net.minecraft.unmapped.C_6466836;
import net.minecraft.unmapped.C_6849228;
import net.minecraft.unmapped.C_7141926;
import net.minecraft.unmapped.C_8042654;
import net.minecraft.unmapped.C_8525326;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import redstone.multimeter.common.TickTask;
import redstone.multimeter.interfaces.mixin.IMinecraftServer;
import redstone.multimeter.interfaces.mixin.IServerWorld;
import redstone.multimeter.server.MultimeterServer;
import redstone.multimeter.util.Dimensions;

@Mixin(value={C_3865296.class})
public abstract class ServerWorldMixin
extends C_5553933
implements IServerWorld {
    @Shadow
    @Final
    private MinecraftServer f_4443467;
    @Shadow
    @Final
    private Set<C_6466836> f_7448670;
    private int rsmm$scheduledTicks;
    private int rsmm$currentDepth;
    private boolean rsmm$firstTickingChunk;

    private ServerWorldMixin(C_5528202 storage, String name, C_3198459 dimension, C_2670477 settings, C_8525326 profiler) {
        super(storage, name, dimension, settings, profiler);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void startTickTaskTickLevel(CallbackInfo ci) {
        this.rsmm$startTickTask(TickTask.TICK_LEVEL, new String[]{Dimensions.REGISTRY.getKey(this.f_6669533.f_8006473)});
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiler/Profiler;push(Ljava/lang/String;)V", args={"ldc=mobSpawner"})})
    private void startTickTaskMobSpawning(CallbackInfo ci) {
        this.rsmm$startTickTask(TickTask.MOB_SPAWNING, new String[0]);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V", args={"ldc=chunkSource"})})
    private void swapTickTaskChunkSource(CallbackInfo ci) {
        this.rsmm$swapTickTask(TickTask.CHUNK_SOURCE, new String[0]);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/WorldData;setTime(J)V")})
    private void swapTickTaskTickTime(CallbackInfo ci) {
        this.rsmm$swapTickTask(TickTask.TICK_TIME, new String[0]);
        this.getMultimeterServer().tickTime(this);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V", args={"ldc=tickPending"})})
    private void swapTickTaskScheduledTicks(CallbackInfo ci) {
        this.rsmm$swapTickTask(TickTask.SCHEDULED_TICKS, new String[0]);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V", args={"ldc=tickBlocks"})})
    private void swapTickTaskTickChunks(CallbackInfo ci) {
        this.rsmm$swapTickTask(TickTask.TICK_CHUNKS, new String[0]);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V", args={"ldc=chunkMap"})})
    private void swapTickTaskChunkMap(CallbackInfo ci) {
        this.rsmm$swapTickTask(TickTask.CHUNK_MAP, new String[0]);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V", args={"ldc=village"})})
    private void swapTickTaskVillages(CallbackInfo ci) {
        this.rsmm$swapTickTask(TickTask.VILLAGES, new String[0]);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V", args={"ldc=portalForcer"})})
    private void swapTickTaskPortals(CallbackInfo ci) {
        this.rsmm$swapTickTask(TickTask.PORTALS, new String[0]);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;doBlockEvents()V")})
    private void swapTickTaskBlockEvents(CallbackInfo ci) {
        this.rsmm$swapTickTask(TickTask.BLOCK_EVENTS, new String[0]);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void endTickTaskTickBlockEventsAndLevel(CallbackInfo ci) {
        this.rsmm$endTickTask();
        this.rsmm$endTickTask();
    }

    @Inject(method={"wakeSleepingPlayers"}, at={@At(value="HEAD")})
    private void startTickTaskWakeSleepingPlayers(CallbackInfo ci) {
        this.rsmm$startTickTask(TickTask.WAKE_SLEEPING_PLAYERS, new String[0]);
    }

    @Inject(method={"wakeSleepingPlayers"}, at={@At(value="TAIL")})
    private void endTickTaskWakeSleepingPlayers(CallbackInfo ci) {
        this.rsmm$endTickTask();
    }

    @Inject(method={"tickChunks"}, at={@At(value="INVOKE", target="Ljava/util/Set;iterator()Ljava/util/Iterator;")})
    private void pollTickingChunks(CallbackInfo ci) {
        this.rsmm$firstTickingChunk = true;
    }

    @Inject(method={"tickChunks"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Ljava/util/Iterator;hasNext()Z")})
    private void startOrSwapOrEndTickTaskTickChunk(CallbackInfo ci, int succeeded, int attempts, Iterator<C_7141926> it) {
        if (it.hasNext()) {
            if (this.rsmm$firstTickingChunk) {
                this.rsmm$startTickTask(TickTask.TICK_CHUNK, new String[0]);
            } else {
                this.rsmm$swapTickTask(TickTask.TICK_CHUNK, new String[0]);
            }
        } else if (!this.rsmm$firstTickingChunk) {
            this.rsmm$endTickTask();
        }
        this.rsmm$firstTickingChunk = false;
    }

    @Inject(method={"tickChunks"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V", args={"ldc=thunder"})})
    private void swapTickTaskThunder(CallbackInfo ci) {
        this.rsmm$swapTickTask(TickTask.THUNDER, new String[0]);
    }

    @Inject(method={"tickChunks"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V", args={"ldc=iceandsnow"})})
    private void swapTickTaskPrecipitation(CallbackInfo ci) {
        this.rsmm$swapTickTask(TickTask.PRECIPITATION, new String[0]);
    }

    @Inject(method={"tickChunks"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V", args={"ldc=tickBlocks"})})
    private void swapTickTaskRandomTicks(CallbackInfo ci) {
        this.rsmm$swapTickTask(TickTask.RANDOM_TICKS, new String[0]);
    }

    @Inject(method={"tickChunks"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/block/Block;tick(Lnet/minecraft/world/World;IIILjava/util/Random;)V")})
    private void logRandomTick(CallbackInfo ci, int succeeded, int attempts, Iterator<C_7141926> it, C_7141926 chunkPos, int chunkX, int chunkZ, C_6849228 chunk, C_8042654[] sections, int sectionIndex, int maxSectionIndex, C_8042654 section, int attempt, int randomNumber, int localX, int localZ, int localY) {
        this.getMultimeter().logRandomTick(this, chunkX + localX, section.m_8362961() + localY, chunkZ + localZ);
    }

    @Inject(method={"scheduleTick(IIILnet/minecraft/block/Block;II)V"}, at={@At(value="HEAD")})
    private void captureScheduledTicks(int x, int y, int z, C_1241852 block, int delay, int priority, CallbackInfo ci) {
        this.rsmm$scheduledTicks = this.f_7448670.size();
    }

    @Inject(method={"scheduleTick(IIILnet/minecraft/block/Block;II)V"}, at={@At(value="TAIL")})
    private void logScheduleTick(int x, int y, int z, C_1241852 block, int delay, int priority, CallbackInfo ci) {
        if (this.rsmm$scheduledTicks != this.f_7448670.size()) {
            this.getMultimeter().logScheduledTick(this, x, y, z, priority, true);
        }
    }

    @Inject(method={"doScheduledTicks"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/block/Block;tick(Lnet/minecraft/world/World;IIILjava/util/Random;)V")})
    private void logScheduledTick(boolean debug, CallbackInfoReturnable<Boolean> cir, Iterator<C_6466836> scheduledTicksThisTick, C_6466836 scheduledTick) {
        this.getMultimeter().logScheduledTick(this, scheduledTick.f_3919118, scheduledTick.f_9302931, scheduledTick.f_1185883, scheduledTick.f_8907322, false);
    }

    @Inject(method={"tickWeather"}, at={@At(value="HEAD")})
    private void startTickTaskWeather(CallbackInfo ci) {
        this.rsmm$startTickTask(TickTask.WEATHER, new String[0]);
    }

    @Inject(method={"tickWeather"}, at={@At(value="TAIL")})
    private void endTickTaskWeather(CallbackInfo ci) {
        this.rsmm$endTickTask();
    }

    @Inject(method={"addBlockEvent"}, at={@At(value="TAIL")})
    private void addBlockEvent(int x, int y, int z, C_1241852 block, int type, int data, CallbackInfo ci) {
        this.getMultimeter().logBlockEvent(this, x, y, z, type, this.rsmm$currentDepth + 1, true);
    }

    @Inject(method={"doBlockEvents"}, at={@At(value="HEAD")})
    private void onRunBlockEvents(CallbackInfo ci) {
        this.rsmm$currentDepth = -1;
    }

    @Inject(method={"doBlockEvents"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld$BlockEventQueue;isEmpty()Z")})
    private void onNextBlockEventQueue(CallbackInfo ci) {
        ++this.rsmm$currentDepth;
    }

    @Inject(method={"doBlockEvents"}, at={@At(value="TAIL")})
    private void postRunBlockEvents(CallbackInfo ci) {
        this.rsmm$currentDepth = -1;
    }

    @Inject(method={"doBlockEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/Block;doEvent(Lnet/minecraft/world/World;IIIII)Z")})
    private void logBlockEvent(C_2286850 blockEvent, CallbackInfoReturnable<Boolean> cir) {
        this.getMultimeter().logBlockEvent(this, blockEvent.m_5395344(), blockEvent.m_9898999(), blockEvent.m_8133472(), blockEvent.m_5600958(), this.rsmm$currentDepth, false);
    }

    @Override
    public MultimeterServer getMultimeterServer() {
        return ((IMinecraftServer)this.f_4443467).getMultimeterServer();
    }
}

